/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.pcsc.impl;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.java.impl.AbstractJUno;
import de.bos_bremen.java.pcsc.EnhancedJPCSCReaderState;
import de.bos_bremen.java.pcsc.JPCSC;
import de.bos_bremen.java.pcsc.JPCSCReaderState;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.jni.pcsc.EnhancedPCSCReaderState;
import de.bos_bremen.jni.pcsc.PCSC;
import de.bos_bremen.jni.pcsc.PCSCException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class AbstractJPCSC
extends AbstractJUno<PCSCException>
implements JPCSC {
    @Override
    public PCSCException mapThrowable(int mode, PCSCException cause) {
        return cause;
    }

    public AbstractJPCSC(List<Integer> supportedSystemList, List<Integer> supportedVersionList) throws IllegalArgumentException {
        super(supportedSystemList, supportedVersionList);
    }

    @Override
    public final long establishContext(int scope, Object pvReserved1, Object pvReserved2) throws PCSCException, IllegalArgumentException {
        if (scope != 2 && scope != 1 && scope != 0) {
            throw new IllegalArgumentException("unknown scope given");
        }
        if (pvReserved1 != null || pvReserved2 != null) {
            throw new IllegalArgumentException("pvReserved[1|2] not null");
        }
        return PCSC.SCardEstablishContext(scope, pvReserved1, pvReserved2);
    }

    @Override
    public final void releaseContext(long contextHandle) throws PCSCException {
        PCSC.SCardReleaseContext(contextHandle);
    }

    @Override
    public final boolean isValidContext(long contextHandle) throws PCSCException {
        return PCSC.SCardIsValidContext(contextHandle);
    }

    @Override
    public final String[] listReaderGroups(long contextHandle) throws PCSCException {
        int requiredLength = PCSC.SCardListReaderGroups(contextHandle, null);
        byte[] buffer = new byte[requiredLength];
        PCSC.SCardListReaderGroups(contextHandle, buffer);
        StringTokenizer st = new StringTokenizer(new String(buffer), new String(new char[]{'\u0000'}));
        ArrayList<String> groups = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            groups.add(st.nextToken());
        }
        return groups.toArray(new String[0]);
    }

    @Override
    public final String[] listReaders(long contextHandle, String[] readerGroups) throws PCSCException, IllegalArgumentException {
        byte[] readerGroupsString = null;
        if (readerGroups != null && readerGroups.length > 0) {
            Object readerGroupsStringTemp = "";
            for (String group : readerGroups) {
                if (group == null) {
                    throw new IllegalArgumentException("readerGroups must not contain a null element");
                }
                readerGroupsStringTemp = (String)readerGroupsStringTemp + group + "\u0000";
            }
            readerGroupsStringTemp = (String)readerGroupsStringTemp + "\u0000";
            readerGroupsString = ((String)readerGroupsStringTemp).getBytes();
        }
        int requiredLength = PCSC.SCardListReaders(contextHandle, readerGroupsString, null);
        byte[] buffer = new byte[requiredLength];
        PCSC.SCardListReaders(contextHandle, readerGroupsString, buffer);
        StringTokenizer st = new StringTokenizer(new String(buffer), new String(new char[]{'\u0000'}));
        ArrayList<String> readers = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            readers.add(st.nextToken());
        }
        return readers.toArray(new String[0]);
    }

    @Override
    public synchronized void getStatusChange(long contextHandle, int timeout, JPCSCReaderState[] readerStates) throws PCSCException, IllegalArgumentException {
        if (timeout < -1) {
            throw new IllegalArgumentException("negative timeout (other than -1) not permitted");
        }
        if (readerStates == null || readerStates.length == 0) {
            throw new IllegalArgumentException("readerStates not permitted as null or empty");
        }
        PCSC.SCardGetStatusChange(contextHandle, timeout, readerStates);
        for (JPCSCReaderState state : readerStates) {
            state.setCurrentState(state.getEventState());
        }
    }

    @Override
    public final long connect(long contextHandle, String reader, int shareMode, Protocol protocol) throws PCSCException, IllegalArgumentException {
        return this.connect(contextHandle, reader, shareMode, protocol, 10000);
    }

    @Override
    public final long connect(long contextHandle, String reader, int shareMode, Protocol protocol, int timeout) throws PCSCException, IllegalArgumentException {
        if (reader == null || reader.length() == 0) {
            throw new IllegalArgumentException("reader name not permitted as null or empty");
        }
        if (shareMode != 3 && shareMode != 1 && shareMode != 2) {
            throw new IllegalArgumentException("unknown share mode given");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol not permitted as null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("negative timeout not permitted");
        }
        if (shareMode == 1) {
            long[] connectData = PCSC.SCardConnect(contextHandle, reader, shareMode, protocol.getValue());
            protocol.setValue((int)connectData[1]);
            return connectData[0];
        }
        Semaphore sync = new Semaphore(0);
        ConnectExecutor executor = new ConnectExecutor(timeout, sync, contextHandle, reader, shareMode, protocol.getValue());
        Waiter waiter = new Waiter(timeout, sync);
        executor.start();
        waiter.run();
        if (!executor.isSuccess()) {
            PCSCException ex = executor.getException();
            throw ex != null ? ex : new PCSCException("SCardConnect", "connect timed out", -1L);
        }
        protocol.setValue(executor.getProtocol());
        return executor.getCard();
    }

    @Override
    public final void disconnect(long cardHandle, int dispositionMode) throws PCSCException, IllegalArgumentException {
        this.disconnect(cardHandle, dispositionMode, 10000);
    }

    @Override
    public final void disconnect(long cardHandle, int dispositionMode, int timeout) throws PCSCException, IllegalArgumentException {
        if (dispositionMode != 3 && dispositionMode != 0 && dispositionMode != 1 && dispositionMode != 2) {
            throw new IllegalArgumentException("unknown disposition given");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("negative timeout not permitted");
        }
        Semaphore sync = new Semaphore(0);
        DisconnectExecutor executor = new DisconnectExecutor(timeout, sync, cardHandle, dispositionMode);
        Waiter waiter = new Waiter(timeout, sync);
        executor.start();
        waiter.run();
        if (!executor.isSuccess()) {
            PCSCException ex = executor.getException();
            throw ex != null ? ex : new PCSCException("SCardDisconnect", "disconnect timed out", -1L);
        }
    }

    @Override
    public void reconnect(long cardHandle, int shareMode, Protocol protocol, int disposition) throws PCSCException, IllegalArgumentException {
        if (disposition != 3 && disposition != 0 && disposition != 1 && disposition != 2) {
            throw new IllegalArgumentException("unknown disposition mode given");
        }
        if (shareMode != 3 && shareMode != 1 && shareMode != 2) {
            throw new IllegalArgumentException("unknown share mode given");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol not permitted as null");
        }
    }

    @Override
    public final void status(long cardHandle, EnhancedJPCSCReaderState readerState) throws PCSCException, IllegalArgumentException {
        this.status(cardHandle, readerState, 10000);
    }

    @Override
    public final synchronized void status(long cardHandle, EnhancedJPCSCReaderState readerState, int timeout) throws PCSCException, IllegalArgumentException {
        if (readerState == null) {
            throw new IllegalArgumentException("readerState not permitted as null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("negative timeout not permitted");
        }
        Semaphore sync = new Semaphore(0);
        StatusExecutor executor = new StatusExecutor(timeout, sync, cardHandle, readerState);
        Waiter waiter = new Waiter(timeout, sync);
        executor.start();
        waiter.run();
        if (!executor.isSuccess()) {
            PCSCException ex = executor.getException();
            throw ex != null ? ex : new PCSCException("SCardStatus", "status timed out", -1L);
        }
    }

    @Override
    public final byte[] control(long cardHandle, int controlCode, byte[] sendBuffer, int responseBufferSize) throws PCSCException, IllegalArgumentException {
        if (responseBufferSize < 1) {
            throw new IllegalArgumentException("responseBufferSize must be positive");
        }
        byte[] outBuffer = new byte[responseBufferSize];
        int resultLength = PCSC.SCardControl(cardHandle, controlCode, sendBuffer, outBuffer);
        return ByteUtil.cutByteArray(outBuffer, resultLength);
    }

    @Override
    public final byte[] transmit(long cardHandle, Protocol protocol, byte[] sendBuffer, int responseBufferSize) throws PCSCException, IllegalArgumentException {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol not permitted as null");
        }
        if (sendBuffer == null || sendBuffer.length == 0) {
            throw new IllegalArgumentException("sendBufer not permitted as null or empty");
        }
        if (responseBufferSize < 1) {
            throw new IllegalArgumentException("responseBufferSize must be positive");
        }
        byte[] buffer = new byte[responseBufferSize];
        int resultLength = PCSC.SCardTransmit(cardHandle, protocol.getValue(), protocol.getProtocolData(), sendBuffer, buffer);
        return ByteUtil.cutByteArray(buffer, resultLength);
    }

    @Override
    public final void beginTransaction(long cardHandle) throws PCSCException {
        this.beginTransaction(cardHandle, 10000);
    }

    @Override
    public void beginTransaction(long cardHandle, int timeout) throws PCSCException, IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout not permitted as negative");
        }
        Semaphore sync = new Semaphore(0);
        BeginTransactionExecutor executor = new BeginTransactionExecutor(timeout, sync, cardHandle);
        Waiter waiter = new Waiter(timeout, sync);
        executor.start();
        waiter.run();
        if (!executor.isSuccess()) {
            PCSCException ex = executor.getException();
            throw ex != null ? ex : new PCSCException("SCardBeginTransaction", "beginTransaction timed out", -1L);
        }
    }

    @Override
    public void endTransaction(long cardHandle, int dispositionMode) throws PCSCException, IllegalArgumentException {
        if (dispositionMode != 3 && dispositionMode != 0 && dispositionMode != 1 && dispositionMode != 2) {
            throw new IllegalArgumentException("unknown disposition given");
        }
        PCSC.SCardEndTransaction(cardHandle, dispositionMode);
    }

    @Override
    public final void cancel(long contextHandle) throws PCSCException {
        PCSC.SCardCancel(contextHandle);
    }

    @Override
    public final byte[] getAttrib(long cardHandle, int attrID) throws PCSCException {
        return this.getAttrib(cardHandle, attrID, 10000);
    }

    @Override
    public final void setAttrib(long cardHandle, int attrID, byte[] attrValue) throws PCSCException, IllegalArgumentException {
        if (attrValue == null) {
            throw new IllegalArgumentException("new attribute value not permitted as null");
        }
        PCSC.SCardSetAttrib(cardHandle, attrID, attrValue);
    }

    static abstract class AbstractExecutor
    extends Thread {
        protected int timeout = 0;
        protected Semaphore sync = null;
        protected boolean success = false;
        protected PCSCException ex = null;

        public AbstractExecutor(int timeout, Semaphore sync) throws IllegalArgumentException {
            if (timeout < 0) {
                throw new IllegalArgumentException("negative timeout not permitted");
            }
            if (sync == null) {
                throw new IllegalArgumentException("semaphore not permitted as null");
            }
            this.timeout = timeout;
            this.sync = sync;
        }

        public final synchronized boolean isSuccess() {
            return this.success;
        }

        public final PCSCException getException() {
            return this.ex;
        }

        @Override
        public abstract void run();
    }

    static class Waiter
    extends Thread {
        private long timeout = 0L;
        private Semaphore sync = null;
        private boolean interrupted = false;
        private long elapsedTime = 0L;

        public Waiter(long timeout, Semaphore sync) throws IllegalArgumentException {
            if (timeout < 0L) {
                throw new IllegalArgumentException("negative timeout not permitted");
            }
            if (sync == null) {
                throw new IllegalArgumentException("semaphore not permitted as null");
            }
            this.timeout = (long)((double)timeout * 1.05);
            this.sync = sync;
        }

        @Override
        public void run() {
            boolean success = false;
            long startTime = System.currentTimeMillis();
            try {
                while (!success && this.elapsedTime < this.timeout) {
                    success = this.sync.tryAcquire(this.timeout - this.elapsedTime, TimeUnit.MILLISECONDS);
                    this.elapsedTime = System.currentTimeMillis() - startTime;
                }
            }
            catch (InterruptedException e) {
                this.interrupted = true;
                this.elapsedTime = System.currentTimeMillis() - startTime;
            }
        }

        @Override
        public boolean isInterrupted() {
            return this.interrupted;
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }

    private static class BeginTransactionExecutor
    extends AbstractExecutor {
        private long card = 0L;

        public BeginTransactionExecutor(int timeout, Semaphore sync, long card) {
            super(timeout, sync);
            this.card = card;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            try {
                PCSC.SCardBeginTransaction(this.card);
                BeginTransactionExecutor beginTransactionExecutor = this;
                synchronized (beginTransactionExecutor) {
                    long elapsed = System.currentTimeMillis() - startTime;
                    if (elapsed >= (long)this.timeout) {
                        try {
                            PCSC.SCardEndTransaction(this.card, 0);
                        }
                        catch (PCSCException pCSCException) {}
                    } else {
                        this.success = true;
                    }
                }
            }
            catch (PCSCException e) {
                this.ex = e;
            }
            this.sync.release();
        }
    }

    private static class StatusExecutor
    extends AbstractExecutor {
        private long card = 0L;
        private EnhancedPCSCReaderState readerState = null;

        public StatusExecutor(int timeout, Semaphore sync, long card, EnhancedPCSCReaderState state) throws IllegalArgumentException {
            super(timeout, sync);
            if (state == null) {
                throw new IllegalArgumentException("reader state not permitted as null");
            }
            this.card = card;
            this.readerState = state;
        }

        @Override
        public void run() {
            try {
                PCSC.SCardStatus(this.card, this.readerState);
                this.success = true;
            }
            catch (PCSCException e) {
                this.ex = e;
            }
            this.sync.release();
        }
    }

    private static class DisconnectExecutor
    extends AbstractExecutor {
        private long card = 0L;
        private int disposition = 0;

        public DisconnectExecutor(int timeout, Semaphore sync, long card, int disposition) throws IllegalArgumentException {
            super(timeout, sync);
            if (disposition != 3 && disposition != 0 && disposition != 1 && disposition != 2) {
                throw new IllegalArgumentException("unknown disposition given");
            }
            this.card = card;
            this.disposition = disposition;
        }

        @Override
        public void run() {
            try {
                PCSC.SCardDisconnect(this.card, this.disposition);
                this.success = true;
            }
            catch (PCSCException e) {
                this.ex = e;
            }
            this.sync.release();
        }
    }

    private static class ConnectExecutor
    extends AbstractExecutor {
        private long context = 0L;
        private String reader = null;
        private int shareMode = 0;
        private int protocol = 0;
        private long card = 0L;

        public ConnectExecutor(int timeout, Semaphore sync, long context, String reader, int shareMode, int protocol) throws IllegalArgumentException {
            super(timeout, sync);
            if (reader == null || reader.length() == 0) {
                throw new IllegalArgumentException("reader name not permitted as null or empty");
            }
            if (shareMode != 3 && shareMode != 1 && shareMode != 2) {
                throw new IllegalArgumentException("unknown shareMode given");
            }
            this.context = context;
            this.reader = reader;
            this.shareMode = shareMode;
            this.protocol = protocol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            try {
                long[] connResult = PCSC.SCardConnect(this.context, this.reader, this.shareMode, this.protocol);
                ConnectExecutor connectExecutor = this;
                synchronized (connectExecutor) {
                    long elapsed = System.currentTimeMillis() - startTime;
                    if (elapsed >= (long)this.timeout) {
                        try {
                            PCSC.SCardDisconnect(connResult[0], 0);
                        }
                        catch (PCSCException pCSCException) {}
                    } else {
                        this.protocol = (int)connResult[1];
                        this.card = connResult[0];
                        this.success = true;
                    }
                }
            }
            catch (PCSCException e) {
                this.ex = e;
            }
            this.sync.release();
        }

        public long getCard() {
            return this.card;
        }

        public int getProtocol() {
            return this.protocol;
        }
    }
}

