/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.common.TypeInstanceCountManager;
import de.bos_bremen.common.Util;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.common.system.VersionEnum;
import de.bos_bremen.java.JUno;
import de.bos_bremen.java.JUnoFactory;
import de.bos_bremen.java.JUnoFactoryAnnotation;
import de.bos_bremen.java.JUnoNotFoundException;
import de.bos_bremen.java.Support;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractJUnoFactoryImpl<T extends JUno<?>>
implements JUnoFactory<T> {
    private List<T> junoList = new ArrayList<T>();
    private SystemEnum system = null;
    private Class<T> typeClass;
    private List<T> deliveredImplementations = new ArrayList<T>();

    @Override
    public final SystemEnum getSystem() {
        return this.system;
    }

    public AbstractJUnoFactoryImpl(Class<T> typeClass, SystemEnum system) throws IllegalArgumentException {
        Class<?> c;
        JUnoFactoryAnnotation implementationAnnotation;
        if (typeClass == null) {
            throw new IllegalArgumentException("no type class defined");
        }
        this.typeClass = typeClass;
        this.system = system;
        if (this.system == null) {
            this.system = SystemEnum.getCurrentSystem();
        }
        if ((implementationAnnotation = Util.findAnnotation(c = this.getClass(), JUnoFactoryAnnotation.class)) == null) {
            throw new IllegalArgumentException("no implementation annotation found for factory: " + JUnoFactoryAnnotation.class.getName());
        }
        this.junoList = ListUtil.createNewInstanceList(typeClass, implementationAnnotation.value());
    }

    public final void addHandler(Class<? extends T> handlerClass) {
        if (handlerClass != null) {
            ListUtil.addNewInstance(this.junoList, handlerClass);
        }
    }

    @Override
    public final synchronized void releaseImplementation(T implementation) {
        if (this.deliveredImplementations.contains(implementation)) {
            this.deliveredImplementations.remove(implementation);
        }
    }

    @Override
    public final synchronized T getImplementation(int version) throws JUnoNotFoundException, IllegalArgumentException, IllegalStateException {
        Support bestSupport = Support.NOTHING;
        JUno result = null;
        if (version < 0) {
            throw new IllegalArgumentException("version expected as value greater 0");
        }
        if (version == 0) {
            throw new IllegalArgumentException("a real version has to be requested, 0 not permitted");
        }
        for (JUno juno : this.junoList) {
            Support support = juno.supports(this.system.ordinal(), version);
            if (support == Support.VERSION) {
                result = juno;
                if (!this.deliveredImplementations.contains(juno)) break;
                continue;
            }
            if (support.ordinal() <= bestSupport.ordinal()) continue;
            bestSupport = support;
        }
        if (result != null) {
            int instanceLimit = TypeInstanceCountManager.getManager().getInstanceLimit(this.typeClass);
            if (instanceLimit != 1 && this.deliveredImplementations.size() >= instanceLimit) {
                throw new IllegalStateException("limit of " + result.getClass().getSimpleName() + " instances reached");
            }
            if (instanceLimit != 1) {
                this.deliveredImplementations.add(result);
            }
            return (T)result;
        }
        int systemOrdinal = this.system.ordinal();
        String systemName = this.system.getName();
        if (bestSupport == Support.NOTHING) {
            throw new JUnoNotFoundException(systemOrdinal, systemName);
        }
        String versionName = VersionEnum.values()[version].getName();
        throw new JUnoNotFoundException(systemOrdinal, systemName, version, versionName);
    }

    @Override
    public synchronized void reset() {
        this.deliveredImplementations.clear();
    }
}

