/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.impl;

import de.bos_bremen.common.ListUtil;
import de.bos_bremen.java.JUno;
import de.bos_bremen.java.Support;
import de.bos_bremen.jni.NativeException;
import java.util.List;

public abstract class AbstractJUno<T extends NativeException>
implements JUno<T> {
    private List<Integer> supportedSystemList = null;
    private List<Integer> supportedVersionList = null;

    public AbstractJUno(List<Integer> supportedSystemList, List<Integer> supportedVersionList) throws IllegalArgumentException {
        if (supportedSystemList == null || supportedSystemList.size() == 0) {
            throw new IllegalArgumentException("list of supported systems must not be null or empty");
        }
        if (supportedVersionList == null || supportedVersionList.size() == 0) {
            throw new IllegalArgumentException("list of supported versions must not be null or empty");
        }
        if (supportedSystemList.contains(null)) {
            throw new IllegalArgumentException("null entry not permitted at list of supported systems");
        }
        if (supportedVersionList.contains(null)) {
            throw new IllegalArgumentException("null entry not permitted at list of supported versions");
        }
        for (Integer system : supportedSystemList) {
            if (system >= 0) continue;
            throw new IllegalArgumentException("entry not permitted at list of supported systems: " + system + " is less 0");
        }
        for (Integer version : supportedVersionList) {
            if (version >= 0) continue;
            throw new IllegalArgumentException("entry not permitted at list of supported versions: " + version + " is less 0");
        }
        this.supportedSystemList = ListUtil.createUnmodifableCopy(supportedSystemList);
        this.supportedVersionList = ListUtil.createUnmodifableCopy(supportedVersionList);
    }

    @Override
    public final Support supports(int system, int version) {
        Support result = Support.NOTHING;
        if (system > 0 && version > 0 && (this.supportedSystemList.contains(0) || this.supportedSystemList.contains(system))) {
            result = Support.SYSTEM;
            if (this.supportedVersionList.contains(0) || this.supportedVersionList.contains(version)) {
                result = Support.VERSION;
            }
        }
        return result;
    }
}

