/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.ctapi.impl;

import de.bos_bremen.java.ctapi.JCTAPI;
import de.bos_bremen.java.ctapi.JCTAPIConnection;
import de.bos_bremen.java.ctapi.JCTAPIConnectionManager;
import de.bos_bremen.java.impl.AbstractJUno;
import de.bos_bremen.jni.ctapi.CTAPI;
import de.bos_bremen.jni.ctapi.CTAPIException;
import java.util.List;

public abstract class AbstractJCTAPI
extends AbstractJUno<CTAPIException>
implements JCTAPI {
    private JCTAPIConnectionManager connectionManager = JCTAPIConnectionManager.getConnectionManager();
    protected static final int MODE_CONNECT = 0;
    protected static final int MODE_DISCONNECT = 1;
    protected static final int MODE_SEND = 2;

    public AbstractJCTAPI(List<Integer> supportedSystemList, List<Integer> supportedVersionList) throws IllegalArgumentException {
        super(supportedSystemList, supportedVersionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void disconnect(long libraryHandle, int terminalNo) throws IllegalArgumentException, IllegalStateException, CTAPIException {
        this.checkArgumentsLibraryHandleTerminalNo(libraryHandle, terminalNo);
        JCTAPIConnectionManager jCTAPIConnectionManager = this.connectionManager;
        synchronized (jCTAPIConnectionManager) {
            if (!this.isConnected(libraryHandle, terminalNo)) {
                throw new IllegalStateException("terminal not connected yet");
            }
            try {
                CTAPI.ctClose(libraryHandle, terminalNo);
            }
            catch (CTAPIException e) {
                throw this.mapThrowable(1, e);
            }
            JCTAPIConnection ii = new JCTAPIConnection(libraryHandle, terminalNo);
            this.connectionManager.removeConnection(ii);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] send(long libraryHandle, int terminalNo, int source, int destination, byte[] sendBuffer, Integer responseBufferSize) throws IllegalArgumentException, IllegalStateException, CTAPIException {
        this.checkArgumentsSend(libraryHandle, terminalNo, source, destination, sendBuffer, responseBufferSize);
        JCTAPIConnectionManager jCTAPIConnectionManager = this.connectionManager;
        synchronized (jCTAPIConnectionManager) {
            if (!this.isConnected(libraryHandle, terminalNo)) {
                throw new IllegalStateException("terminal not connected yet");
            }
            byte[] responseBuffer = new byte[responseBufferSize.intValue()];
            int responseLength = -1;
            try {
                responseLength = CTAPI.ctData(libraryHandle, terminalNo, source, destination, sendBuffer, responseBuffer);
            }
            catch (CTAPIException e) {
                throw this.mapThrowable(2, e);
            }
            byte[] result = new byte[responseLength];
            System.arraycopy(responseBuffer, 0, result, 0, responseLength);
            return result;
        }
    }

    private void checkArgumentsSend(long libraryHandle, int terminalNo, int source, int destination, byte[] sendBuffer, Integer responseBufferSize) {
        this.checkArgumentsLibraryHandleTerminalNo(libraryHandle, terminalNo);
        this.checkArgumentsSendSourceDestination(source, destination);
        this.checkArgumentsSendBuffer(sendBuffer, responseBufferSize);
    }

    private void checkArgumentsSendBuffer(byte[] sendBuffer, Integer responseBufferSize) {
        if (sendBuffer == null) {
            throw new IllegalArgumentException("send buffer not permitted as null");
        }
        if ((long)sendBuffer.length == 0L) {
            throw new IllegalArgumentException("send buffer not permitted as empty array");
        }
        if ((long)sendBuffer.length < 1L) {
            throw new IllegalArgumentException("send buffer not permitted, too small");
        }
        if ((long)sendBuffer.length >= MAXIMUM_INPUT_BUFFER) {
            throw new IllegalArgumentException("send buffer not permitted, too large");
        }
        if ((long)responseBufferSize.intValue() == 0L) {
            throw new IllegalArgumentException("response buffer not permitted as empty array");
        }
        if (responseBufferSize != null) {
            if ((long)responseBufferSize.intValue() < 1L) {
                throw new IllegalArgumentException("response buffer not permitted, too small");
            }
            if ((long)responseBufferSize.intValue() >= MAXIMUM_OUTPUT_BUFFER) {
                throw new IllegalArgumentException("response buffer not permitted, too large");
            }
        }
    }

    private void checkArgumentsSendSourceDestination(int source, int destination) {
        if (source < 0) {
            throw new IllegalArgumentException("illegal source (SAD): " + source);
        }
        if (destination < 0) {
            throw new IllegalArgumentException("illegal destination (DAD): " + destination);
        }
        switch (source) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal source (SAD): " + source);
            }
        }
        switch (destination) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal destination (DAD): " + destination);
            }
        }
    }

    private void checkArgumentsLibraryHandleTerminalNo(long libraryHandle, int terminalNo) {
        if (libraryHandle < 0L) {
            throw new IllegalArgumentException("illegal handle:" + libraryHandle);
        }
        if (terminalNo < 0) {
            throw new IllegalArgumentException("illegal terminal number: " + terminalNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized boolean isConnected(long libraryHandle, int terminalNo) {
        JCTAPIConnectionManager jCTAPIConnectionManager = this.connectionManager;
        synchronized (jCTAPIConnectionManager) {
            JCTAPIConnection ii = new JCTAPIConnection(libraryHandle, terminalNo);
            return this.connectionManager.existsConnection(ii);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void connect(long libraryHandle, int terminalNo, int port) throws IllegalArgumentException, IllegalStateException, CTAPIException {
        this.checkArgumentsConnect(libraryHandle, terminalNo, port);
        JCTAPIConnectionManager jCTAPIConnectionManager = this.connectionManager;
        synchronized (jCTAPIConnectionManager) {
            if (this.isConnected(libraryHandle, terminalNo)) {
                throw new IllegalStateException("terminal already connected, terminal number used before");
            }
            try {
                CTAPI.ctInit(libraryHandle, terminalNo, port);
            }
            catch (CTAPIException e) {
                if (e.getCode() == -1L) {
                    throw new IllegalStateException("connect with library '" + libraryHandle + "', terminalNo '" + terminalNo + "' and port '" + port + "' failed");
                }
                throw this.mapThrowable(0, e);
            }
            JCTAPIConnection ii = new JCTAPIConnection(libraryHandle, terminalNo);
            this.connectionManager.addConnection(ii);
        }
    }

    private void checkArgumentsConnect(long libraryHandle, int terminalNo, int port) {
        this.checkArgumentsLibraryHandleTerminalNo(libraryHandle, terminalNo);
        if (port < 0) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
    }

    @Override
    public CTAPIException mapThrowable(int mode, CTAPIException cause) {
        return cause;
    }
}

