/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.ctapi;

import de.bos_bremen.java.ctapi.JCTAPIConnectionManager;
import de.bos_bremen.jni.ctapi.CTAPI;
import de.bos_bremen.jni.ctapi.CTAPIException;
import de.bos_bremen.jni.ctapi.CTAPILibraryManager;

public final class JCTAPILibraryManager
implements CTAPILibraryManager {
    private static JCTAPILibraryManager SINGLETON = null;
    private CTAPILibraryManager libraryManager = CTAPI.getLibraryManager();

    public static synchronized JCTAPILibraryManager getLibraryManager() {
        if (SINGLETON == null) {
            SINGLETON = new JCTAPILibraryManager();
        }
        return SINGLETON;
    }

    private JCTAPILibraryManager() {
    }

    @Override
    public int getFreeLibraryCount() throws CTAPIException {
        return this.libraryManager.getFreeLibraryCount();
    }

    @Override
    public int getLibraryCount() throws CTAPIException {
        return this.libraryManager.getLibraryCount();
    }

    @Override
    public int getMaximumLibraryCount() throws CTAPIException {
        return this.libraryManager.getMaximumLibraryCount();
    }

    @Override
    public long loadLibrary(String library) throws IllegalArgumentException, CTAPIException {
        return this.libraryManager.loadLibrary(library);
    }

    @Override
    public void unloadLibrary(long libraryHandle) throws CTAPIException, IllegalStateException {
        if (JCTAPIConnectionManager.getConnectionManager().existsConnection(libraryHandle)) {
            throw new IllegalStateException("there are opened connections with CT-API library, library can not be unloaded");
        }
        this.libraryManager.unloadLibrary(libraryHandle);
    }

    @Override
    public String getLibraryName(long libraryHandle) throws IllegalArgumentException {
        return this.libraryManager.getLibraryName(libraryHandle);
    }
}

