/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java.ctapi;

import de.bos_bremen.java.ctapi.JCTAPIConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JCTAPIConnectionManager {
    private List<JCTAPIConnection> connectionList = new ArrayList<JCTAPIConnection>();
    private List<JCTAPIConnection> externalConnectionList = Collections.unmodifiableList(this.connectionList);
    private Map<Long, Integer> handleTerminalNoMap = new HashMap<Long, Integer>();
    private static JCTAPIConnectionManager SINGLETON = null;

    private JCTAPIConnectionManager() {
    }

    public static synchronized JCTAPIConnectionManager getConnectionManager() {
        if (SINGLETON == null) {
            SINGLETON = new JCTAPIConnectionManager();
        }
        return SINGLETON;
    }

    public synchronized void addConnection(JCTAPIConnection connection) {
        if (connection != null && this.connectionList != null && !this.connectionList.contains(connection)) {
            this.connectionList.add(connection);
            this.handleTerminalNoMap.put(connection.getLibraryHandle(), connection.getTerminalNo());
        }
    }

    public synchronized boolean existsConnection(JCTAPIConnection connection) {
        boolean result = false;
        if (connection != null && this.connectionList != null) {
            result = this.connectionList.contains(connection);
        }
        return result;
    }

    public List<JCTAPIConnection> getConnectionList() {
        return this.externalConnectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JCTAPIConnection> getConnectionList(long libraryHandle) {
        ArrayList<JCTAPIConnection> result = new ArrayList<JCTAPIConnection>();
        List<JCTAPIConnection> list = this.connectionList;
        synchronized (list) {
            result.addAll(this.connectionList);
        }
        ArrayList<JCTAPIConnection> tmp = new ArrayList<JCTAPIConnection>();
        for (JCTAPIConnection c : result) {
            if (c.getLibraryHandle() != libraryHandle) continue;
            tmp.add(c);
        }
        result.retainAll(tmp);
        return result;
    }

    public boolean existsConnection(long libraryHandle) {
        return !this.getConnectionList(libraryHandle).isEmpty();
    }

    public synchronized void removeConnection(JCTAPIConnection connection) {
        if (connection != null && this.connectionList != null && this.connectionList.contains(connection)) {
            this.connectionList.remove(connection);
            this.handleTerminalNoMap.remove(connection.getLibraryHandle());
        }
    }
}

