/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.java;

public class JUnoNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String NOT_SUPPORTED_MESSAGE = "not supported";
    private final int system;
    private final String systemName;
    private final int version;
    private final String versionName;

    public JUnoNotFoundException(int system, String systemName, int version, String versionName) throws IllegalArgumentException {
        super(versionName + " not supported(system: " + systemName + ")");
        JUnoNotFoundException.checkConstructorArgs("system", system, systemName);
        JUnoNotFoundException.checkConstructorArgs("version", version, versionName);
        this.system = system;
        this.systemName = systemName;
        this.version = version;
        this.versionName = versionName;
    }

    public JUnoNotFoundException(int system, String systemName) throws IllegalArgumentException {
        super(systemName + " not supported");
        JUnoNotFoundException.checkConstructorArgs("system", system, systemName);
        this.system = system;
        this.systemName = systemName;
        this.version = -1;
        this.versionName = "";
    }

    public final int getSystem() {
        return this.system;
    }

    public final String getSystemName() {
        return this.systemName;
    }

    public final int getVersion() {
        return this.version;
    }

    public final String getVersionName() {
        return this.versionName;
    }

    public static void checkConstructorArgs(String checkedInformation, int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(checkedInformation + " expected as value greater equals zero, but was: " + value);
        }
        if (name == null) {
            throw new IllegalArgumentException("name of " + checkedInformation + " not permitted as null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name of " + checkedInformation + " not permitted as empty String");
        }
    }
}

