/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.utils;

import de.bos_bremen.gov2.jca_provider.utils.HexFixedBCryptPropertiesKeyEncrypter;
import de.bos_bremen.gov2.jca_provider.utils.KeySecuredProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class MCardProperties
extends KeySecuredProperties {
    private static final String FILENAME_MCARD_PROPERTIES = "mcard.properties";
    private static MCardProperties instance;
    private static final Path PATH_MCARD_DIR;
    private static final Path PATH_MCARD_PROPERTIES;
    private static final long serialVersionUID = 1L;
    private transient boolean loading = false;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient boolean storeEnabled = true;

    private MCardProperties(Properties defaults, boolean encrypted) throws IOException {
        super(new HexFixedBCryptPropertiesKeyEncrypter(), defaults, encrypted);
        this.prepare();
        if (Objects.isNull(defaults)) {
            this.load();
        } else {
            this.store();
        }
    }

    public static MCardProperties getInstance() throws IOException {
        return MCardProperties.getInstance(null, false);
    }

    public static synchronized MCardProperties getInstance(Properties defaults, boolean encrypted) throws IOException {
        if (Objects.isNull(instance)) {
            instance = new MCardProperties(defaults, encrypted);
        }
        return instance;
    }

    static synchronized void reset() {
        instance = null;
    }

    public synchronized Path backup() throws IOException {
        Path backup;
        block13: {
            backup = PATH_MCARD_DIR.resolve("mcard.properties-bac-" + this.nowDateString());
            this.prepare();
            if (Files.size(PATH_MCARD_PROPERTIES) > 0L) {
                try (InputStream in = Files.newInputStream(PATH_MCARD_PROPERTIES, new OpenOption[0]);
                     OutputStream os = Files.newOutputStream(backup, new OpenOption[0]);){
                    in.transferTo(os);
                    break block13;
                }
            }
            backup = null;
        }
        return backup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean changeKey(Object oldKey, Object newKey) {
        boolean result = false;
        this.storeEnabled = false;
        try {
            result = super.changeKey(oldKey, newKey);
        }
        finally {
            this.storeEnabled = true;
        }
        if (result) {
            this.storeInt();
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        if (!super.isEmpty()) {
            super.clear();
            this.storeInt();
        }
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.storeOnChange(super.compute(key, remappingFunction));
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        boolean before = super.containsKey(key);
        Object result = super.computeIfAbsent(key, mappingFunction);
        if (!before && super.containsKey(key)) {
            this.storeInt();
        }
        return result;
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        boolean before = super.containsKey(key);
        Object result = super.computeIfPresent(key, remappingFunction);
        if (before) {
            this.storeOnChange(result);
        }
        return result;
    }

    @Override
    public synchronized boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        if (Files.exists(PATH_MCARD_PROPERTIES, LinkOption.NOFOLLOW_LINKS)) {
            super.clear();
            try (InputStream is = Files.newInputStream(PATH_MCARD_PROPERTIES, StandardOpenOption.READ);){
                this.storeEnabled = false;
                this.loading = true;
                super.load(is);
            }
            finally {
                this.storeEnabled = true;
                this.loading = false;
            }
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        int h1 = super.hashCode();
        Object result = super.put(key, value);
        int h2 = super.hashCode();
        if (h1 != h2 && this.storeEnabled) {
            this.storeInt();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        if (Objects.nonNull(t) && !t.isEmpty()) {
            long hashCodeBefore = this.hashCode();
            this.storeEnabled = false;
            try {
                super.putAll(t);
            }
            finally {
                this.storeEnabled = true;
            }
            long hashCodeAfter = this.hashCode();
            if (hashCodeBefore != hashCodeAfter) {
                this.storeInt();
            }
        }
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        return this.storeOnChange(super.putIfAbsent(key, value));
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.storeOnChange(super.remove(key));
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        boolean result = super.remove(key, value);
        if (result) {
            this.storeInt();
        }
        return result;
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        return this.storeOnChange(super.replace(key, value));
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        boolean result = super.replace(key, oldValue, newValue);
        if (result) {
            this.storeInt();
        }
        return result;
    }

    public synchronized Path restore(Path old) throws IOException {
        Path backup;
        if (Objects.nonNull(old) && Files.exists(old, new LinkOption[0])) {
            backup = this.backup();
            this.prepare();
            try (InputStream in = Files.newInputStream(old, new OpenOption[0]);
                 OutputStream os = Files.newOutputStream(PATH_MCARD_PROPERTIES, new OpenOption[0]);){
                in.transferTo(os);
            }
            try {
                this.load();
            }
            catch (IOException e) {
                Files.delete(PATH_MCARD_PROPERTIES);
                Files.move(backup, PATH_MCARD_PROPERTIES, new CopyOption[0]);
                backup = null;
            }
        } else {
            backup = null;
        }
        return backup;
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public synchronized Path store() throws IOException {
        Path backup;
        if (this.storeEnabled) {
            backup = this.backup();
            try (OutputStream os = Files.newOutputStream(PATH_MCARD_PROPERTIES, new OpenOption[0]);){
                super.store(os, "generated, remove complete lines only, do not modify key or values");
            }
            catch (IOException e) {
                Path p = this.restore(backup);
                Files.delete(p);
                Files.delete(backup);
                backup = null;
            }
        } else {
            backup = null;
        }
        return backup;
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        if (!this.loading) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public synchronized void store(Writer writer, String comments) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeToXML(OutputStream os, String comment, Charset charset) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void checkCreateMCardDirectory() throws IOException {
        if (Files.notExists(PATH_MCARD_DIR, new LinkOption[0])) {
            Files.createDirectories(PATH_MCARD_DIR, new FileAttribute[0]);
        }
    }

    private void checkCreateMCardProperties() throws IOException {
        if (Files.notExists(PATH_MCARD_PROPERTIES, LinkOption.NOFOLLOW_LINKS)) {
            Files.createFile(PATH_MCARD_PROPERTIES, new FileAttribute[0]);
        }
    }

    private String nowDateString() {
        return DateTimeFormatter.ofPattern("yyyyMMdd-kkmmss-SSS").format(LocalDateTime.now());
    }

    private void prepare() throws IOException {
        this.checkCreateMCardDirectory();
        this.checkCreateMCardProperties();
    }

    private void storeInt() {
        try {
            this.store();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private <T> T storeOnChange(T old) {
        if (Objects.nonNull(old)) {
            this.storeInt();
        }
        return old;
    }

    static {
        PATH_MCARD_DIR = Paths.get(System.getProperty("user.home"), ".governikus", "mcard");
        PATH_MCARD_PROPERTIES = PATH_MCARD_DIR.resolve(FILENAME_MCARD_PROPERTIES);
    }
}

