/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.utils;

import de.bos_bremen.common.io.StreamUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.gov2.jca_provider.utils.AutoMCardRestarter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MCardJniHelper {
    public static final Path DEFAULT_APPLICATION_PATH = Paths.get(System.getProperty("user.home"), ".governikus", "mcard");
    private static final Log LOG = LogFactory.getLog(MCardJniHelper.class);
    private static final String SYSTEM_PROPERTY_JAVA_LIBRARY_PATH = "java.library.path";

    private MCardJniHelper() {
    }

    public static void setupJavaLibraryPath(Path dir) {
        if (Objects.nonNull(dir) && Files.isDirectory(dir, new LinkOption[0])) {
            System.setProperty(SYSTEM_PROPERTY_JAVA_LIBRARY_PATH, dir.toAbsolutePath().toString());
        }
    }

    public static void unpackMCardDll(Path dir, boolean mcardAdditionalInitialization) {
        MCardJniHelper.createMCardJniLibraryTargetDirectory(dir);
        Optional<MCardJni> currentJni = MCardJni.getCurrent();
        if (currentJni.isPresent()) {
            MCardJni jni = currentJni.get();
            Path targetPath = dir.resolve(jni.getJniName());
            MCardJniHelper.unpackJniLibrary(jni, targetPath);
            if (jni.hasJniAlternativeName()) {
                targetPath = dir.resolve(jni.getJniAlternativeName());
                MCardJniHelper.unpackJniLibrary(jni, targetPath);
            }
        } else {
            LOG.error((Object)"current MCard JNI library not detected");
            throw new IllegalStateException("current MCard JNI library not detected");
        }
        if (mcardAdditionalInitialization) {
            MCardJniHelper.mcardAdditionalInitialization(dir);
        }
    }

    private static void unpackJniLibrary(MCardJni jni, Path targetPath) {
        if (Files.exists(targetPath, new LinkOption[0])) {
            LOG.info((Object)("MCard JNI library is present: " + jni.getJniName()));
        } else {
            Optional<String> jniClasspathEntry = jni.findJniClasspathEntry();
            if (jniClasspathEntry.isPresent()) {
                String jniClasspathEntryName = jniClasspathEntry.get();
                MCardJniHelper.unpackJniLibrary(jni, targetPath, jniClasspathEntryName);
            }
        }
    }

    private static void createMCardJniLibraryTargetDirectory(Path dir) {
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                LOG.info((Object)("created MCard JNI library directory: " + dir));
            }
            catch (IOException e) {
                LOG.error((Object)("failed to create required MCard JNI library directory: " + dir), (Throwable)e);
                throw new IllegalStateException("failed to create required MCard JNI library directory: " + dir);
            }
        }
    }

    private static void mcardAdditionalInitialization(Path dir) {
        MCardJniHelper.setupJavaLibraryPath(dir);
        new AutoMCardRestarter();
    }

    private static void unpackJniLibrary(MCardJni jni, Path targetPath, String jniClasspathEntryName) {
        block21: {
            try (ZipFile zf = new ZipFile(jniClasspathEntryName);){
                ZipEntry entry = zf.getEntry(jni.getJniName());
                if (Objects.nonNull(entry)) {
                    try (InputStream jniStream = zf.getInputStream(entry);
                         OutputStream jniOutputStream = Files.newOutputStream(targetPath, new OpenOption[0]);){
                        if (Objects.isNull(jniStream)) {
                            LOG.error((Object)"failed to open Card JNI library stream");
                            throw new IllegalStateException("fail to open MCard JNI library stream");
                        }
                        jniOutputStream.write(StreamUtil.read(jniStream));
                        LOG.info((Object)("MCard JNI library unpacked successfully: " + targetPath.toAbsolutePath()));
                        break block21;
                    }
                }
                LOG.error((Object)"MCard JNI library Zip entry not found");
                throw new IllegalStateException("MCard JNI library Zip entry not found");
            }
            catch (IOException e) {
                LOG.error((Object)("unpacking MCard JNI library failed: " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("unpacking MCard JNI library failed", e);
            }
        }
    }

    public static enum MCardJni {
        LINUX_JAVA32(SystemEnum.SystemGroup.LINUX, 32, "linux-x86.jar", "libjsb.so"),
        LINUX_JAVA64(SystemEnum.SystemGroup.LINUX, 64, "linux-x86_64.jar", "libjsb.so"),
        MACOS_JAVA(SystemEnum.SystemGroup.MACOS, null, "macos.jar", "libjsb.jnilib", "libjsb.dylib"),
        WINDOWS_JAVA32(SystemEnum.SystemGroup.WINDOWS, 32, "windows-x86.jar", "jsb.dll"),
        WINDOWS_JAVA64(SystemEnum.SystemGroup.WINDOWS, 64, "windows-x86_64.jar", "jsb.dll");

        public static final String PATTERN_PREFIX_MCARD_JNI_JAR = ".*mcard-jni-([0-9]{1,5}\\.){2}([0-9]{1,5})-";
        private static final String SYSTEM_PROPERTY_CLASSPATH = "java.class.path";
        private static final String SYSTEM_PROPERTY_CLASSPATH_SEPARATOR = "path.separator";
        private static final String SYSTEM_PROPTERY_SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
        private final String jarNamePatternSuffix;
        private final Integer javaArch;
        private String jniAlternativeName;
        private final String jniName;
        private final SystemEnum.SystemGroup systemGroup;

        private MCardJni(SystemEnum.SystemGroup systemGroup, Integer javaArch, String jarNamePatternSuffix, String jniName) {
            this(systemGroup, javaArch, jarNamePatternSuffix, jniName, null);
        }

        private MCardJni(SystemEnum.SystemGroup systemGroup, Integer javaArch, String jarNamePatternSuffix, String jniName, String jniAlternativeName) {
            this.systemGroup = systemGroup;
            this.javaArch = javaArch;
            this.jarNamePatternSuffix = jarNamePatternSuffix;
            this.jniName = jniName;
            this.jniAlternativeName = jniAlternativeName;
        }

        public static Optional<MCardJni> getCurrent() {
            return Arrays.asList(MCardJni.values()).stream().filter(m -> SystemEnum.getCurrentSystem().getGroup().equals((Object)m.getSystemGroup()) && (Objects.isNull(m.getJavaArch()) || Integer.valueOf(System.getProperty(SYSTEM_PROPTERY_SUN_ARCH_DATA_MODEL)).equals(m.getJavaArch()))).findAny();
        }

        public Optional<String> findJniClasspathEntry() {
            return Arrays.asList(System.getProperty(SYSTEM_PROPERTY_CLASSPATH).split(System.getProperty(SYSTEM_PROPERTY_CLASSPATH_SEPARATOR))).stream().filter(e -> Pattern.matches(PATTERN_PREFIX_MCARD_JNI_JAR + this.getJarNamePatternSuffix(), e)).findAny();
        }

        public String getJarNamePatternSuffix() {
            return this.jarNamePatternSuffix;
        }

        public Integer getJavaArch() {
            return this.javaArch;
        }

        public String getJniAlternativeName() {
            return this.jniAlternativeName;
        }

        public String getJniName() {
            return this.jniName;
        }

        public SystemEnum.SystemGroup getSystemGroup() {
            return this.systemGroup;
        }

        public boolean hasJniAlternativeName() {
            return Objects.nonNull(this.jniAlternativeName);
        }
    }
}

