/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.utils;

import de.bos_bremen.gov2.jca_provider.utils.PropertiesKeyEncrypter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;

public class KeySecuredProperties
extends Properties
implements PropertiesKeyEncrypter {
    private static final long serialVersionUID = 1L;
    private transient boolean encEnabled = true;
    private final PropertiesKeyEncrypter keyEncrypter;

    public KeySecuredProperties(PropertiesKeyEncrypter keyEncrypter) {
        this(keyEncrypter, null, false);
    }

    public KeySecuredProperties(PropertiesKeyEncrypter keyEncrypter, Properties defaults) {
        this(keyEncrypter, defaults, false);
    }

    public KeySecuredProperties(PropertiesKeyEncrypter keyEncrypter, Properties defaults, boolean encrypted) {
        PropertiesKeyEncrypter propertiesKeyEncrypter = this.keyEncrypter = Objects.nonNull(keyEncrypter) ? keyEncrypter : PropertiesKeyEncrypter.DEFAULT;
        if (Objects.nonNull(defaults) && !defaults.isEmpty()) {
            if (encrypted) {
                this.encEnabled = false;
            }
            this.putAll((Map<?, ?>)defaults);
            if (encrypted) {
                this.encEnabled = true;
            }
        }
    }

    public synchronized boolean changeKey(Object oldKey, Object newKey) {
        boolean result;
        if (this.isValidKey(newKey) && this.containsKey(oldKey) && !this.containsKey(newKey)) {
            Object oldValue = this.get(oldKey);
            this.put(newKey, oldValue);
            this.remove(oldKey);
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return super.compute(this.convertKey(key), remappingFunction);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        return super.computeIfAbsent(this.convertKey(key), mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return super.computeIfPresent(this.convertKey(key), remappingFunction);
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        return super.containsKey(this.keyEncrypter.encryptKey(key));
    }

    @Override
    public String encryptKey(byte[] key) {
        return this.keyEncrypter.encryptKey(key);
    }

    @Override
    public String encryptKey(Object key) {
        return this.keyEncrypter.encryptKey(key);
    }

    @Override
    public String encryptKey(String key) {
        return this.keyEncrypter.encryptKey(key);
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (Objects.isNull(obj)) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        KeySecuredProperties other = (KeySecuredProperties)obj;
        return this.keyEncrypter.equals(other.keyEncrypter);
    }

    @Override
    public synchronized Object get(Object key) {
        return super.get(this.convertKey(key));
    }

    public PropertiesKeyEncrypter getKeyEncrypter() {
        return this.keyEncrypter;
    }

    @Override
    public final Object getOrDefault(Object key, Object defaultValue) {
        return super.getOrDefault((Object)this.convertKey(key), defaultValue);
    }

    @Override
    public synchronized String getProperty(String key) {
        return (String)this.get(key);
    }

    @Override
    public synchronized String getProperty(String key, String defaultValue) {
        return super.getProperty(this.convertKey(key), defaultValue);
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyEncrypter == null ? 0 : this.keyEncrypter.hashCode());
        return result;
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        try {
            this.encEnabled = false;
            super.load(inStream);
        }
        finally {
            this.encEnabled = true;
        }
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        try {
            this.encEnabled = false;
            super.load(reader);
        }
        finally {
            this.encEnabled = true;
        }
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException {
        try {
            this.encEnabled = false;
            super.loadFromXML(in);
        }
        finally {
            this.encEnabled = true;
        }
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return super.merge(this.convertKey(key), value, remappingFunction);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return super.put(this.convertKey(key), value);
    }

    @Override
    public synchronized void putAll(Map<?, ?> m) {
        if (Objects.nonNull(m) && !m.isEmpty()) {
            m.entrySet().stream().forEach((? super T e) -> this.put(e.getKey(), e.getValue()));
        }
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        return super.putIfAbsent(this.convertKey(key), value);
    }

    @Override
    public synchronized Object remove(Object key) {
        return super.remove(this.convertKey(key));
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return super.remove(this.convertKey(key), value);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        return super.replace(this.convertKey(key), value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        return super.replace(this.convertKey(key), oldValue, newValue);
    }

    @Override
    public final synchronized void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public synchronized void store(OutputStream out, String comments) throws IOException {
        try {
            this.encEnabled = false;
            super.store(out, comments);
        }
        finally {
            this.encEnabled = true;
        }
    }

    @Override
    public synchronized void store(Writer writer, String comments) throws IOException {
        try {
            this.encEnabled = false;
            super.store(writer, comments);
        }
        finally {
            this.encEnabled = true;
        }
    }

    @Override
    public synchronized void storeToXML(OutputStream os, String comment) throws IOException {
        try {
            this.encEnabled = false;
            super.storeToXML(os, comment);
        }
        finally {
            this.encEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void storeToXML(OutputStream os, String comment, Charset charset) throws IOException {
        try {
            this.encEnabled = false;
            super.storeToXML(os, comment, charset);
        }
        finally {
            this.encEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        try {
            this.encEnabled = false;
            super.storeToXML(os, comment, encoding);
        }
        finally {
            this.encEnabled = true;
        }
    }

    private String convertKey(Object key) {
        return super.containsKey(key) || !this.encEnabled ? key.toString() : this.keyEncrypter.encryptKey(key);
    }

    private boolean isValidKey(Object key) {
        boolean result = Objects.nonNull(key);
        if (result && key instanceof byte[]) {
            result &= ((byte[])key).length > 0;
        } else if (result && key instanceof String) {
            result &= !((String)key).isBlank();
        }
        return result;
    }
}

