/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.utils;

import de.bos_bremen.gov2.jca_provider.ExtReloadListener;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreParameterInputStream;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ReloadListener;
import de.bos_bremen.gov2.jca_provider.Reloader;
import de.bos_bremen.gov2.jca_provider.ReloaderCallback;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import java.security.KeyStore;
import java.security.Security;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoMCardRestarter
implements TerminalListener,
ReloaderCallback,
ExtReloadListener {
    private static final Log LOG = LogFactory.getLog(AutoMCardRestarter.class);
    private static final long RESTART_DELAY = 1000L;
    private ExtReloadListener optionalExtReloadListener;
    private ReloadListener optionalReloadListener;
    private Reloader reloader;
    private int terminalCount = 0;

    public AutoMCardRestarter() {
        this(null, true);
    }

    public AutoMCardRestarter(ReloadListener optionalReloadListener, boolean startUseAsReloaderCallback) {
        this.optionalReloadListener = optionalReloadListener;
        if (optionalReloadListener instanceof ExtReloadListener) {
            this.optionalExtReloadListener = (ExtReloadListener)optionalReloadListener;
        }
        CardObjectRegistryImpl.getInstance().addTerminalListener(this);
        if (startUseAsReloaderCallback) {
            this.initialMCardStart();
        }
    }

    @Override
    public Reloader getReloader() {
        return this.reloader;
    }

    @Override
    public void keyStoreCleanedUp() {
        LOG.info((Object)"MCard KeyStore clean up");
        if (Objects.nonNull(this.optionalReloadListener)) {
            this.optionalReloadListener.keyStoreCleanedUp();
        }
    }

    @Override
    public void processEvent(TerminalEvent event) {
        switch (event.getType()) {
            case 1: {
                if (this.terminalCount <= 0) break;
                --this.terminalCount;
                if (this.terminalCount != 0) break;
                this.restart();
                break;
            }
            case 0: {
                ++this.terminalCount;
                break;
            }
        }
        LOG.info((Object)("terminals: " + this.terminalCount));
    }

    @Override
    public void reloadFinished() {
        LOG.info((Object)"MCard reloadFinished");
        if (Objects.nonNull(this.optionalReloadListener)) {
            this.optionalExtReloadListener.reloadFinished();
        }
    }

    @Override
    public void reloadStarted() {
        LOG.info((Object)"MCard restarted");
        if (Objects.nonNull(this.optionalReloadListener)) {
            this.optionalExtReloadListener.reloadStarted();
        }
    }

    @Override
    public void setReloader(Reloader reloader) {
        this.reloader = reloader;
    }

    private void initialMCardStart() {
        Security.addProvider(new OCFProvider());
        try {
            KeyStore keyStore = KeyStore.getInstance("OCF", "OCF");
            try (OCFKeyStoreParameterInputStream configurationStream = new OCFKeyStoreParameterInputStream();){
                configurationStream.setReloaderCallback(this);
                keyStore.load(configurationStream, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Runnable mcardRestartRunnable() {
        return () -> {
            try {
                Thread.sleep(1000L);
                this.getReloader().reload(this);
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
            LOG.info((Object)"MCard restarted");
        };
    }

    private void restart() {
        LOG.info((Object)"restarting MCard");
        SwingUtilities.invokeLater(this.mcardRestartRunnable());
    }
}

