/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.utils;

import de.bos_bremen.gov2.jca_provider.utils.Crypter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESCrypter
implements Crypter {
    public static final String ALGORITHM = "AES";
    private Cipher decipher;
    private Cipher encipher;
    private final SecretKey secretKey;

    public AESCrypter(byte[] key) throws InvalidKeyException {
        this(AESCrypter.newSecretKey(key, ALGORITHM));
    }

    public AESCrypter(SecretKey key) throws InvalidKeyException {
        if (Objects.isNull(key)) {
            throw new IllegalArgumentException();
        }
        this.secretKey = key;
        try {
            this.encipher = AESCrypter.newSecretCipher(ALGORITHM, 1, this.secretKey);
            this.decipher = AESCrypter.newSecretCipher(ALGORITHM, 2, this.secretKey);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            // empty catch block
        }
    }

    public static Cipher newSecretCipher(String transformation, int opmode, SecretKey key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher result = Cipher.getInstance(transformation);
        result.init(opmode, key);
        return result;
    }

    public static SecretKey newSecretKey(byte[] key, String algorithm) {
        return new SecretKeySpec(key, algorithm);
    }

    @Override
    public byte[] decrypt(byte[] encryptedData) throws IllegalBlockSizeException, BadPaddingException {
        this.check(encryptedData);
        return this.decipher.doFinal(encryptedData);
    }

    @Override
    public byte[] encrypt(byte[] data) throws IllegalBlockSizeException, BadPaddingException {
        this.check(data);
        return this.encipher.doFinal(data);
    }

    private void check(byte[] data) {
        if (Objects.isNull(data) || data.length == 0) {
            throw new IllegalArgumentException("invalid data");
        }
    }
}

