/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.service.impl.hsm;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.BOSHSMSimulatorService;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.EIDHSMService;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import java.lang.reflect.Method;

public class HSMServiceFactoryImpl
implements HSMServiceFactory {
    private static void init(int hsmType) throws HSMException {
        ServiceRegistry sr = ServiceRegistry.Util.getServiceRegistry();
        if (!sr.serviceExists(BOSHSMSimulatorService.class)) {
            BOSHSMSimulatorService bosService = BOSHSMSimulatorService.getInstance();
            sr.registerService(BOSHSMSimulatorService.class, bosService);
        }
        if (hsmType == 2) {
            if (!sr.serviceExists(EIDHSMService.class)) {
                try {
                    Class.forName("eID.EID");
                    EIDHSMService utimacoEID = EIDHSMService.getInstance();
                    sr.registerService(EIDHSMService.class, utimacoEID);
                }
                catch (Exception e) {
                    throw new HSMException(e);
                }
            }
            sr.registerService(HSMService.class, (HSMService)sr.getService(EIDHSMService.class));
        } else if (hsmType == 1) {
            sr.registerService(HSMService.class, (HSMService)sr.getService(BOSHSMSimulatorService.class));
        }
    }

    @Override
    public HSMService getHSMService(int hsmType) throws IllegalArgumentException, HSMException {
        if (hsmType != 1 && hsmType != 2) {
            throw new IllegalArgumentException("unknown type of HSM requested");
        }
        HSMServiceFactoryImpl.init(hsmType);
        return ServiceRegistry.Util.getServiceRegistry().getService(HSMService.class);
    }

    @Override
    public HSMService getHSMService() throws HSMException {
        ServiceRegistry sr = ServiceRegistry.Util.getServiceRegistry();
        if (!sr.serviceExists(HSMService.class)) {
            HSMServiceFactoryImpl.init(1);
        }
        return sr.getService(HSMService.class);
    }

    @Override
    public HSMService getHSMService(Class<? extends HSMService> serviceClass) throws HSMException {
        AssertUtil.notNull(serviceClass, "HSM service class");
        ServiceRegistry sr = ServiceRegistry.Util.getServiceRegistry();
        if (!sr.serviceExists(serviceClass)) {
            try {
                Method getInstance = serviceClass.getMethod("getInstance", new Class[0]);
                HSMService service = (HSMService)getInstance.invoke(null, new Object[0]);
                sr.registerService(serviceClass, service);
                sr.registerService(HSMService.class, service);
            }
            catch (Exception e) {
                throw new HSMException(e);
            }
        }
        return sr.getService(serviceClass);
    }
}

