/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.service.impl.hsm;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.cvc.ECCVCPath;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMUtimacoSimulatorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class HSMKeyTool {
    private static final int MODE_DELETE = 0;
    private static final int MODE_DIRECTORY = 1;
    private static final int MODE_FILES = 2;
    private static HSMUtimacoSimulatorService hsm = null;

    public static void main(String[] args) {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            HSMService tempHSM = ServiceRegistry.Util.getServiceRegistry().getService(HSMServiceFactory.class).getHSMService();
            if (!HSMUtimacoSimulatorService.class.isInstance(tempHSM)) {
                throw new InternalError("HSM not connected");
            }
            hsm = (HSMUtimacoSimulatorService)tempHSM;
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, "Connection to HSM could not be established: " + t.getMessage(), "Error", 0);
            System.exit(0);
        }
        while (true) {
            try {
                while (true) {
                    HSMKeyTool.showDialog();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void showDialog() throws UnsupportedOperationException, IllegalArgumentException, IOException, HSMException {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(4, 1));
        labelPanel.add(new JLabel("Private key: "));
        labelPanel.add(new JLabel("CVC containing public key: "));
        labelPanel.add(new JLabel("Directory containing collection of CVCs and private keys: "));
        labelPanel.add(new JLabel("Select keys to be removed: "));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridLayout(4, 1));
        final JTextField privKeyField = new JTextField(10);
        final ArrayList<File> privKeyFile = new ArrayList<File>(1);
        inputPanel.add(privKeyField);
        final JTextField certField = new JTextField();
        final ArrayList<File> certFile = new ArrayList<File>(1);
        inputPanel.add(certField);
        final JTextField dirField = new JTextField();
        final ArrayList<File> dirFile = new ArrayList<File>(1);
        inputPanel.add(dirField);
        JScrollPane scrollList = HSMKeyTool.updateAliases();
        inputPanel.add(scrollList);
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridLayout(4, 1));
        JButton selectPrivKey = new JButton("select");
        editPanel.add(selectPrivKey);
        selectPrivKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    privKeyFile.clear();
                    privKeyFile.add(chooser.getSelectedFile());
                    privKeyField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        JButton selectCert = new JButton("select");
        editPanel.add(selectCert);
        selectCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    certFile.clear();
                    certFile.add(chooser.getSelectedFile());
                    certField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        JButton selectDir = new JButton("select");
        editPanel.add(selectDir);
        selectDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                if (chooser.showOpenDialog(mainPanel) == 0) {
                    dirFile.clear();
                    dirFile.add(chooser.getSelectedFile());
                    dirField.setText(chooser.getSelectedFile().getPath());
                }
            }
        });
        mainPanel.add((Component)labelPanel, "West");
        mainPanel.add((Component)inputPanel, "Center");
        mainPanel.add((Component)editPanel, "East");
        while (true) {
            boolean ok = false;
            int mode = 0;
            int execute = JOptionPane.showOptionDialog(null, mainPanel, "HSM Key Tool", 2, 3, null, null, null);
            if (2 == execute) {
                System.exit(0);
            }
            if (0 == execute) {
                if (dirFile.size() == 1 && privKeyFile.isEmpty() && certFile.isEmpty()) {
                    ok = true;
                    mode = 1;
                } else if (dirFile.isEmpty() && privKeyFile.size() == 1 && certFile.size() == 1) {
                    ok = true;
                    mode = 2;
                } else if (dirFile.isEmpty() && privKeyFile.isEmpty() && certFile.isEmpty() && ((JList)scrollList.getViewport().getView()).getSelectedValues().length > 0) {
                    ok = true;
                } else {
                    JOptionPane.showMessageDialog(mainPanel, "Please make a correct selection", "Error", 0);
                }
                if (ok) {
                    int selected;
                    Object[] selectedAliases = ((JList)scrollList.getViewport().getView()).getSelectedValues();
                    if (selectedAliases != null && selectedAliases.length > 0 && (selected = JOptionPane.showConfirmDialog(null, "You have selected " + selectedAliases.length + " key(s) for deletion. Are you sure?", "Please confirm deletion", 2)) == 0) {
                        for (Object alias : selectedAliases) {
                            String aliasStr = (String)alias;
                            hsm.deleteKey(aliasStr);
                        }
                    }
                    if (mode == 1) {
                        HSMKeyTool.enterDirectory(dirField, dirFile);
                    } else if (mode == 2) {
                        HSMKeyTool.enterSinglePair(privKeyField, privKeyFile, certField, certFile);
                    }
                }
            }
            scrollList = HSMKeyTool.updateAliases();
            ((JPanel)mainPanel.getComponent(1)).remove(3);
            ((JPanel)mainPanel.getComponent(1)).add(scrollList);
        }
    }

    private static JScrollPane updateAliases() throws HSMException, IOException {
        List<String> aliasesList = hsm.getAliases();
        Collections.sort(aliasesList);
        JList<Object> aliasJList = new JList<Object>(aliasesList.toArray());
        aliasJList.setVisibleRowCount(2);
        return new JScrollPane(aliasJList);
    }

    private static void enterDirectory(JTextField dirField, List<File> dirFile) {
        AssertUtil.notNull(dirField, "text field for directory");
        AssertUtil.notNullOrEmpty(dirFile, "directory");
        File dir = dirFile.get(0);
        File[] certFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cvcert") || name.endsWith(".cvc") || name.endsWith(".cert");
            }
        });
        File[] keyFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".pkcs8");
            }
        });
        for (File cert : certFiles) {
            try {
                FileInputStream fis = new FileInputStream(cert);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = 0;
                byte[] buffer = new byte[200];
                do {
                    if ((i = fis.read(buffer)) == -1) continue;
                    baos.write(buffer, 0, i);
                } while (i != -1);
                byte[] certBytes = baos.toByteArray();
                ECCVCertificate cvc = new ECCVCertificate(certBytes);
                String chr = new String(cvc.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue());
                File keyFile = HSMKeyTool.searchKeyFile(keyFiles, chr);
                if (keyFile == null) continue;
                fis = new FileInputStream(keyFile);
                baos = new ByteArrayOutputStream();
                buffer = new byte[200];
                do {
                    if ((i = fis.read(buffer)) == -1) continue;
                    baos.write(buffer, 0, i);
                } while (i != -1);
                byte[] privKeyBytes = baos.toByteArray();
                HSMKeyTool.checkAndEnterKeys(privKeyBytes, cvc, chr);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        dirField.setText("");
        dirFile.clear();
    }

    private static File searchKeyFile(File[] files, String search) {
        AssertUtil.notNullOrEmpty(files, "file array");
        AssertUtil.notNullOrEmpty(search, "search string");
        for (File f : files) {
            if (!f.getName().contains(search)) continue;
            return f;
        }
        return null;
    }

    private static void checkAndEnterKeys(byte[] privKeyBytes, ECCVCertificate cvc, String chr) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException, IOException, HSMException {
        AssertUtil.notNullOrEmpty(privKeyBytes, "bytes of private key");
        AssertUtil.notNull(cvc, "CVC");
        AssertUtil.notNullOrEmpty(chr, "certificate holder reference");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privKeyBytes);
        PrivateKey privKey = null;
        try {
            privKey = KeyFactory.getInstance("EC", "BC").generatePrivate(keySpec);
            JCEECPrivateKey privECKey = (JCEECPrivateKey)privKey;
            ECParameterSpec paramSpec = privECKey.getParameters();
            byte[] pointBytes = cvc.getChildElementByPath(ECCVCPath.PUBLIC_KEY_PUBLIC_POINT_Y).getValue();
            ECPoint pt = paramSpec.getCurve().decodePoint(pointBytes);
            ECPublicKeySpec bSpec = new ECPublicKeySpec(pt, paramSpec);
            PublicKey pkey = KeyFactory.getInstance("EC", "BC").generatePublic((KeySpec)bSpec);
            pt = ((JCEECPublicKey)pkey).getQ();
            ECPoint pt2 = privECKey.getParameters().getG().multiply(privECKey.getD());
            if (!pt.equals(pt2)) {
                throw new IllegalArgumentException("given keys are not a key pair");
            }
        }
        catch (InvalidKeySpecException e) {
            privKey = KeyFactory.getInstance("RSA", "BC").generatePrivate(keySpec);
            JCERSAPrivateKey privRSAKey = (JCERSAPrivateKey)privKey;
            PublicKey publicKey = null;
            Signature sig = Signature.getInstance("RSA", "BC");
            byte[] data = "1234567890".getBytes();
            try {
                sig.initSign((PrivateKey)privRSAKey);
                sig.update(data);
                byte[] signed = sig.sign();
                sig.initVerify(publicKey);
                sig.update(data);
                if (!sig.verify(signed)) {
                    privKey = null;
                }
            }
            catch (Throwable t) {
                return;
            }
        }
        if (privKey != null) {
            hsm.addKey(privKey, chr);
        }
    }

    private static void enterSinglePair(JTextField privKeyField, List<File> privKeyFile, JTextField certField, List<File> certFile) {
        int i;
        ByteArrayOutputStream baos;
        FileInputStream fis;
        AssertUtil.notNull(privKeyField, "text field for private key file");
        AssertUtil.notNullOrEmpty(privKeyFile, "private key file");
        AssertUtil.notNull(certField, "text field for certificate file");
        AssertUtil.notNullOrEmpty(certFile, "certificate file");
        byte[] privKeyBytes = null;
        byte[] certBytes = null;
        try {
            fis = new FileInputStream(privKeyFile.get(0));
            baos = new ByteArrayOutputStream();
            i = 0;
            do {
                if ((i = fis.read()) == -1) continue;
                baos.write(i);
            } while (i != -1);
            privKeyBytes = baos.toByteArray();
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, "Reading private key file failed", "Error", 0);
            return;
        }
        try {
            fis = new FileInputStream(certFile.get(0));
            baos = new ByteArrayOutputStream();
            i = 0;
            do {
                if ((i = fis.read()) == -1) continue;
                baos.write(i);
            } while (i != -1);
            certBytes = baos.toByteArray();
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, "Reading certificate file failed", "Error", 0);
            return;
        }
        try {
            ECCVCertificate cert = new ECCVCertificate(certBytes);
            byte[] chrBytes = cert.getChildElementByPath(ECCVCPath.HOLDER_REFERENCE).getValue();
            String chr = new String(chrBytes);
            HSMKeyTool.checkAndEnterKeys(privKeyBytes, cert, chr);
            JOptionPane.showMessageDialog(null, "The keys have been entered into the HSM.", "Success", 1);
            privKeyFile.clear();
            privKeyField.setText("");
            certFile.clear();
            certField.setText("");
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(null, "Keys have not been entered into the HSM: " + t.getMessage(), "Error", 0);
        }
    }
}

