/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.service.impl.hsm;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMCredentials;

public class HSMConfiguration {
    public static final int DEFAULT_KEY_VALIDITY = 60;
    public static final boolean HSM_KEYS_EXPORTABLE = true;
    public static final boolean HSM_KEYS_NOT_EXPORTABLE = false;
    private String hsmIP = null;
    private String hsmKeyPrefix = "";
    private String hsmKeyEntity = null;
    private int hsmKeyValidity = 60;
    private boolean hsmKeysExportable = true;
    private HSMCredentials keyManager1 = null;
    private HSMCredentials keyManager2 = null;
    private HSMCredentials user1 = null;
    private HSMCredentials user2 = null;

    public HSMConfiguration(String hsmIP, String hsmKeyEntity, HSMCredentials keyManager1, HSMCredentials user1) throws IllegalArgumentException {
        this(hsmIP, null, hsmKeyEntity, 60, true, keyManager1, null, user1, null);
    }

    public HSMConfiguration(String hsmIP, String hsmKeyPrefix, String hsmKeyEntity, int hsmKeyValidity, HSMCredentials keyManager1, HSMCredentials user1) throws IllegalArgumentException {
        this(hsmIP, hsmKeyPrefix, hsmKeyEntity, hsmKeyValidity, true, keyManager1, null, user1, null);
    }

    public HSMConfiguration(String hsmIP, String hsmKeyPrefix, String hsmKeyEntity, int hsmKeyValidity, boolean hsmKeysExportable, HSMCredentials keyManager1, HSMCredentials user1) throws IllegalArgumentException {
        this(hsmIP, hsmKeyPrefix, hsmKeyEntity, hsmKeyValidity, hsmKeysExportable, keyManager1, null, user1, null);
    }

    public HSMConfiguration(String hsmIP, String hsmKeyEntity, HSMCredentials keyManager1, HSMCredentials keyManager2, HSMCredentials user1, HSMCredentials user2) throws IllegalArgumentException {
        this(hsmIP, null, hsmKeyEntity, 60, true, keyManager1, keyManager2, user1, user2);
    }

    public HSMConfiguration(String hsmIP, String hsmKeyPrefix, String hsmKeyEntity, int hsmKeyValidity, HSMCredentials keyManager1, HSMCredentials keyManager2, HSMCredentials user1, HSMCredentials user2) throws IllegalArgumentException {
        this(hsmIP, hsmKeyPrefix, hsmKeyEntity, hsmKeyValidity, true, keyManager1, keyManager2, user1, user2);
    }

    public HSMConfiguration(String hsmIP, String hsmKeyPrefix, String hsmKeyEntity, int hsmKeyValidity, boolean hsmKeysExportable, HSMCredentials keyManager1, HSMCredentials keyManager2, HSMCredentials user1, HSMCredentials user2) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(hsmIP, "HSM IP");
        AssertUtil.notNullOrEmpty(hsmKeyEntity, "key entity");
        AssertUtil.notNull(keyManager1, "first key manager credentials");
        AssertUtil.notNull(user1, "first user credentials");
        if (hsmKeyValidity < 1) {
            throw new IllegalArgumentException("key validity must be positive integer > 0");
        }
        this.hsmIP = hsmIP;
        this.hsmKeyPrefix = hsmKeyPrefix;
        this.hsmKeyEntity = hsmKeyEntity;
        this.hsmKeyValidity = hsmKeyValidity;
        this.hsmKeysExportable = hsmKeysExportable;
        this.keyManager1 = keyManager1;
        this.keyManager2 = keyManager2;
        this.user1 = user1;
        this.user2 = user2;
    }

    public String getHsmIP() {
        return this.hsmIP;
    }

    public String getHsmKeyPrefix() {
        return this.hsmKeyPrefix;
    }

    public String getHsmKeyEntity() {
        return this.hsmKeyEntity;
    }

    public int getHsmKeyValidity() {
        return this.hsmKeyValidity;
    }

    public HSMCredentials getKeyManager1() {
        return this.keyManager1;
    }

    public HSMCredentials getKeyManager2() {
        return this.keyManager2;
    }

    public HSMCredentials getUser1() {
        return this.user1;
    }

    public HSMCredentials getUser2() {
        return this.user2;
    }

    public boolean isHsmKeysExportable() {
        return this.hsmKeysExportable;
    }
}

