/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.service.impl.hsm;

import CryptoServerAPI.CryptoServerException;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.DigestUtil;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.BOSHSMSimulatorService;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMConfiguration;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMCredentials;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMException;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import eID.ECDSAPublicKey;
import eID.EID;
import eID.KeyAttributes;
import eID.MechParams;
import eID.RSAKeyComponents;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class EIDHSMService
implements HSMService {
    private HSMConfiguration config = null;
    private EID keyManagerSession = null;
    private EID userSession = null;
    private static EIDHSMService SINGLETON = null;

    private EIDHSMService() {
    }

    public static EIDHSMService getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new EIDHSMService();
        }
        return SINGLETON;
    }

    @Override
    public boolean containsKey(String alias) throws IllegalArgumentException, IOException, HSMException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        AssertUtil.notNullOrEmpty(alias, "alias");
        return this.getAliases().contains(alias);
    }

    @Override
    public void deleteKey(String alias) throws IllegalArgumentException, IOException, HSMException, IllegalStateException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        AssertUtil.notNullOrEmpty(alias, "alias");
        try {
            KeyAttributes ka = new KeyAttributes();
            ka.setName(this.config.getHsmKeyPrefix() + alias);
            ka.setEntity(this.config.getHsmKeyEntity());
            this.keyManagerSession.deleteKey(ka);
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
    }

    @Override
    public void deactivateKey(String alias) throws IllegalArgumentException, IOException, HSMException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        AssertUtil.notNullOrEmpty(alias, "alias");
        KeyAttributes ka = new KeyAttributes();
        ka.setName(this.config.getHsmKeyPrefix() + alias);
        ka.setEntity(this.config.getHsmKeyEntity());
        ka.setState(0);
        try {
            this.keyManagerSession.changeKeyState(ka);
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
    }

    @Override
    public KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec spec, String alias, boolean replace) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException, HSMException, InvalidAlgorithmParameterException, IllegalStateException {
        ECDSAPublicKey hsmKey;
        int algo;
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        AssertUtil.notNullOrEmpty(algorithm, "key algorithm");
        AssertUtil.notNull(spec, "algorithm parameters");
        AssertUtil.notNullOrEmpty(alias, "alias of new key");
        if (this.containsKey(alias)) {
            if (!replace) {
                throw new IllegalArgumentException("key with requested alias (" + alias + ") already existing, replacing not permitted");
            }
            this.deleteKey(alias);
        }
        if (algorithm.equals("EC") || algorithm.equals("ECDSA")) {
            algo = 4;
        } else if (algorithm.equals("RSA")) {
            algo = 3;
        } else {
            throw new IllegalArgumentException("unsupported algorithm requested");
        }
        PublicKey pk = null;
        try {
            KeyAttributes ka = new KeyAttributes();
            ka.setName(this.config.getHsmKeyPrefix() + alias);
            ka.setEntity(this.config.getHsmKeyEntity());
            ka.setAlgo(algo);
            ka.setDateExp(this.getExpDate());
            if (this.config.isHsmKeysExportable()) {
                ka.setExport(1);
            } else {
                ka.setExport(0);
            }
            if (algo == 4) {
                ECParameterSpec ecSpec = (ECParameterSpec)spec;
                ka.setECCurve(new X9ECParameters(ecSpec.getCurve(), new X9ECPoint(ecSpec.getG(), false), ecSpec.getN(), ecSpec.getH()).getEncoded());
            } else {
                RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)spec;
                ka.setSize(rsaSpec.getKeysize());
            }
            this.keyManagerSession.generateKey(ka);
            ka.setState(1);
            this.keyManagerSession.changeKeyState(ka);
            pk = this.keyManagerSession.exportPublicKey(ka);
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
        PublicKey pkConverted = null;
        if (algo == 4) {
            hsmKey = (ECDSAPublicKey)pk;
            ECPublicKeySpec keySpec = new ECPublicKeySpec(hsmKey.getW(), hsmKey.getParams());
            try {
                pkConverted = KeyFactory.getInstance("EC", "BC").generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new HSMException(e);
            }
        }
        hsmKey = (RSAKeyComponents)pk;
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(hsmKey.getModulus(), hsmKey.getPublicExponent());
        try {
            pkConverted = KeyFactory.getInstance("RSA", "BC").generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new HSMException(e);
        }
        return new KeyPair(pkConverted, null);
    }

    @Override
    public List<String> getAliases() throws HSMException, IOException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        List kaList = null;
        try {
            kaList = this.keyManagerSession.listKeys();
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
        if (kaList == null) {
            return null;
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        for (KeyAttributes ka : kaList) {
            if (ka.getAlgo() == 1) continue;
            String current = ka.getName();
            if (current.startsWith(this.config.getHsmKeyPrefix())) {
                current = current.replaceFirst(this.config.getHsmKeyPrefix(), "");
            }
            aliasList.add(current);
        }
        return aliasList;
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec(String alias) throws HSMException, IllegalArgumentException, IOException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        AssertUtil.notNullOrEmpty(alias, "alias");
        try {
            KeyAttributes ka = new KeyAttributes();
            ka.setName(this.config.getHsmKeyPrefix() + alias);
            ka.setEntity(this.config.getHsmKeyEntity());
            PublicKey pk = this.keyManagerSession.exportPublicKey(ka);
            if (ECDSAPublicKey.class.isInstance(pk)) {
                return ((ECDSAPublicKey)pk).getParams();
            }
            RSAKeyComponents rsaKey = (RSAKeyComponents)pk;
            return new RSAKeyGenParameterSpec(rsaKey.getModulus().bitLength(), rsaKey.getPublicExponent());
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
    }

    private void login(int sessionType, int loginType, String user, String secret, String filename) throws IllegalArgumentException, HSMException, IOException {
        EID session;
        AssertUtil.notNullOrEmpty(user, "user name");
        if (sessionType == 2) {
            session = this.keyManagerSession;
        } else if (sessionType == 3) {
            session = this.userSession;
        } else {
            throw new IllegalArgumentException("unknown session type requested");
        }
        if (loginType != 1 && loginType != 2) {
            throw new IllegalArgumentException("unknown login type");
        }
        if (loginType == 1 && (secret == null || secret.length() == 0)) {
            throw new IllegalArgumentException("password required when using HMAC login");
        }
        if (loginType == 2 && (filename == null || filename.length() == 0)) {
            throw new IllegalArgumentException("key file required when using RSA signature login");
        }
        try {
            if (loginType == 1) {
                session.prepareAuthenticationHMAC(user, secret);
            } else if (loginType == 2) {
                session.prepareAuthenticationRSASign(user, filename, secret);
            }
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
    }

    @Override
    public byte[] sign(String alias, OID sigAlgOID, byte[] data) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, IOException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeyException, SignatureException, InvalidKeySpecException, HSMException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        AssertUtil.notNullOrEmpty(alias, "alias of key");
        AssertUtil.notNullOrEmpty(data, "data to be signed");
        AssertUtil.notNull(sigAlgOID, "OID of signature algorithm");
        MessageDigest md = DigestUtil.getDigestByOID(sigAlgOID);
        byte[] digested = md.digest(data);
        try {
            KeyAttributes ka = new KeyAttributes();
            ka.setName(this.config.getHsmKeyPrefix() + alias);
            ka.setEntity(this.config.getHsmKeyEntity());
            return this.userSession.sign(ka, digested, new MechParams(0));
        }
        catch (CryptoServerException e) {
            if (e.getMessage().contains("B0880004")) {
                BOSHSMSimulatorService localService = ServiceRegistry.Util.getServiceRegistry().getService(BOSHSMSimulatorService.class);
                try {
                    return localService.sign(alias, sigAlgOID, data);
                }
                catch (Exception innerEx) {
                    throw new HSMException(e);
                }
            }
            throw new HSMException(e);
        }
    }

    private void startSession(int sessionType) throws IllegalArgumentException, IOException, HSMException {
        EID session;
        if (sessionType == 2) {
            session = this.keyManagerSession;
        } else if (sessionType == 3) {
            session = this.userSession;
        } else {
            throw new IllegalArgumentException("unknown session type requested");
        }
        try {
            session.getSessionKeyDH(2048);
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
        session.keepSessionAlive();
        session.setEndSessionOnShutdown(true);
    }

    private void loginSingle(int sessionType, String userName, String fileField, String password) throws IllegalArgumentException, HSMException, IOException {
        if (sessionType != 2 && sessionType != 3) {
            throw new IllegalArgumentException("unknown session type requested");
        }
        AssertUtil.notNullOrEmpty(userName, "user name");
        if (fileField == null || fileField.length() == 0) {
            AssertUtil.notNullOrEmpty(password, "password");
        }
        if (password == null || password.length() == 0) {
            AssertUtil.notNullOrEmpty(fileField, "name of key file");
        }
        if (fileField != null && !"".equals(fileField)) {
            this.login(sessionType, 2, userName, password == null || password.length() == 0 ? null : password, fileField);
        } else {
            this.login(sessionType, 1, userName, password, null);
        }
    }

    private String getExpDate() {
        Calendar c = Calendar.getInstance();
        c.add(5, this.config.getHsmKeyValidity());
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        return sdf.format(c.getTime());
    }

    @Override
    public void init(HSMConfiguration config) throws IllegalArgumentException, HSMException, IOException {
        AssertUtil.notNull(config, "configuration");
        this.config = config;
        try {
            this.keyManagerSession = new EID(this.config.getHsmIP());
            this.userSession = new EID(this.config.getHsmIP());
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
        HSMCredentials km1 = config.getKeyManager1();
        this.loginSingle(2, km1.getLoginName(), km1.getKeyFilePath(), km1.getPassword());
        HSMCredentials km2 = config.getKeyManager2();
        if (km2 != null) {
            this.loginSingle(2, km2.getLoginName(), km2.getKeyFilePath(), km2.getPassword());
        }
        this.startSession(2);
        HSMCredentials user1 = config.getUser1();
        this.loginSingle(3, user1.getLoginName(), user1.getKeyFilePath(), user1.getPassword());
        HSMCredentials user2 = config.getUser2();
        if (user2 != null) {
            this.loginSingle(3, user2.getLoginName(), user2.getKeyFilePath(), user2.getPassword());
        }
        this.startSession(3);
    }

    @Override
    public boolean isAlive() {
        if (this.config == null) {
            return false;
        }
        try {
            this.userSession.generateRandomBytes(1);
            this.getAliases();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void logout() throws HSMException, IOException, IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("HSM service not initialized");
        }
        this.config = null;
        try {
            this.keyManagerSession.endSession();
            this.keyManagerSession.logoff();
            this.userSession.endSession();
            this.userSession.logoff();
        }
        catch (CryptoServerException e) {
            throw new HSMException(e);
        }
    }
}

