/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.service.impl.hsm;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.ocf.cards.util.SignatureHandler;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMConfiguration;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMService;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.LocalCertAndKeyProvider;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.List;

public class BOSHSMSimulatorService
implements HSMService {
    private LocalCertAndKeyProvider lcakp = LocalCertAndKeyProvider.getInstance();
    private static BOSHSMSimulatorService SINGLETON = null;

    private BOSHSMSimulatorService() {
    }

    public static BOSHSMSimulatorService getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new BOSHSMSimulatorService();
        }
        return SINGLETON;
    }

    @Override
    public KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec spec, String alias, boolean replace) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, IllegalArgumentException, InvalidAlgorithmParameterException {
        AssertUtil.notNullOrEmpty(algorithm, "algorithm");
        AssertUtil.notNull(spec, "algorithm parameters");
        AssertUtil.notNullOrEmpty(alias, "alias");
        if (!replace && this.lcakp.getKeyByHolder(alias) != null) {
            throw new IllegalArgumentException("key with requested alias (" + alias + ") already existing, replacing not permitted");
        }
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm, "BC");
        kpg.initialize(spec);
        KeyPair kp = kpg.generateKeyPair();
        this.lcakp.addKey(alias, kp.getPrivate().getEncoded());
        return kp;
    }

    @Override
    public byte[] sign(String alias, OID sigAlgOID, byte[] data) throws IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, IOException, UnrecoverableKeyException, KeyStoreException, CertificateException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        AssertUtil.notNullOrEmpty(alias, "alias of key");
        AssertUtil.notNull(sigAlgOID, "OID for signature algorithm");
        AssertUtil.notNullOrEmpty(data, "data to be signed");
        byte[] keyBytes = this.lcakp.getKeyByHolder(alias);
        AssertUtil.notNullOrEmpty(keyBytes, "bytes of received key");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        PrivateKey privSignKey = null;
        try {
            privSignKey = KeyFactory.getInstance("EC", "BC").generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            privSignKey = KeyFactory.getInstance("RSA", "BC").generatePrivate(keySpec);
        }
        Signature signature = SignatureHandler.createSignature(sigAlgOID);
        signature.initSign(privSignKey);
        signature.update(data);
        return signature.sign();
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec(String alias) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, IllegalArgumentException {
        AssertUtil.notNullOrEmpty(alias, "alias of key");
        byte[] keyBytes = this.lcakp.getKeyByHolder(alias);
        AssertUtil.notNullOrEmpty(keyBytes, "bytes of received key");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("EC", "BC");
        try {
            PrivateKey privSignKey = kf.generatePrivate(keySpec);
            return kf.getKeySpec(privSignKey, ECPrivateKeySpec.class).getParams();
        }
        catch (InvalidKeySpecException e) {
            kf = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privSignKey = kf.generatePrivate(keySpec);
            RSAPrivateKeySpec spec = kf.getKeySpec(privSignKey, RSAPrivateKeySpec.class);
            return new RSAKeyGenParameterSpec(spec.getModulus().bitLength(), null);
        }
    }

    @Override
    public List<String> getAliases() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("there is no permanent key store connected");
    }

    @Override
    public void deleteKey(String alias) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("there is no permanent key store connected");
    }

    @Override
    public boolean containsKey(String alias) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("there is no permanent key store connected");
    }

    @Override
    public void deactivateKey(String alias) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("deactivating keys not supported");
    }

    @Override
    public void init(HSMConfiguration config) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("init not required");
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public void logout() {
        throw new UnsupportedOperationException("logout not required");
    }
}

