/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.service.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.service.Service;
import de.bos_bremen.gov2.jca_provider.service.ServiceRegistry;
import de.bos_bremen.gov2.jca_provider.service.hsm.HSMServiceFactory;
import de.bos_bremen.gov2.jca_provider.service.impl.hsm.HSMServiceFactoryImpl;
import java.util.HashMap;
import java.util.Map;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private Map<Class<? extends Service>, Service> serviceMap = new HashMap<Class<? extends Service>, Service>();

    public ServiceRegistryImpl() {
        this.serviceMap.put(HSMServiceFactory.class, new HSMServiceFactoryImpl());
    }

    @Override
    public <T extends Service> T getService(Class<T> serviceClass) throws IllegalArgumentException {
        AssertUtil.notNull(serviceClass, "service class");
        Service service = this.serviceMap.get(serviceClass);
        Service result = null;
        if (serviceClass.isInstance(service)) {
            result = (Service)serviceClass.cast(service);
        }
        return (T)result;
    }

    @Override
    public <T extends Service> void registerService(Class<T> serviceClass, T service) throws IllegalArgumentException {
        AssertUtil.notNull(serviceClass, "service class");
        AssertUtil.notNull(service, "service");
        this.serviceMap.put(serviceClass, service);
    }

    @Override
    public <T extends Service> T unregisterService(Class<T> serviceClass) throws IllegalArgumentException {
        return (T)((Service)serviceClass.cast(this.serviceMap.remove(serviceClass)));
    }

    @Override
    public <T extends Service> boolean serviceExists(Class<T> serviceClass) {
        return this.serviceMap.containsKey(serviceClass);
    }

    @Override
    public boolean isEmpty() {
        return this.serviceMap == null || this.serviceMap.isEmpty();
    }

    @Override
    public int size() {
        return this.serviceMap == null ? 0 : this.serviceMap.size();
    }
}

