/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.params;

import de.bos_bremen.gov2.jca_provider.params.AESCCMAlgorithmParameterSpi;
import de.bos_bremen.gov2.jca_provider.params.AESCFBAlgorithmParameterSpi;
import de.bos_bremen.gov2.jca_provider.params.AESGCMAlgorithmParameterSpi;
import de.bos_bremen.gov2.jca_provider.params.AESOFBAlgorithmParameterSpi;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;

public abstract class AbstractAlgorithmParameterSpi
extends AlgorithmParametersSpi {
    public static final String JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS = "AlgorithmParameters.";
    protected byte[] raw;
    protected AlgorithmParameterSpec spec;

    public static void addCMSEntries(Provider provider) {
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes128_CCM.getId(), AESCCMAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes128_GCM.getId(), AESGCMAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes128_OFB.getId(), AESOFBAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes128_CFB.getId(), AESCFBAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes192_CCM.getId(), AESCCMAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes192_GCM.getId(), AESGCMAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes192_OFB.getId(), AESOFBAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes192_CFB.getId(), AESCFBAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes256_CCM.getId(), AESCCMAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes256_GCM.getId(), AESGCMAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes256_OFB.getId(), AESOFBAlgorithmParameterSpi.class.getName());
        provider.put(JCE_PROVIDER_PREFIX_ENTRY_ALGORITHM_PARAMETERS + NISTObjectIdentifiers.id_aes256_CFB.getId(), AESCFBAlgorithmParameterSpi.class.getName());
    }

    public static ASN1OctetString checkConvertASN1OctetString(String blockMode, byte[] params) throws IOException {
        ASN1OctetString octetString = null;
        try {
            octetString = ASN1OctetString.getInstance((Object)params);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(blockMode + " - byte[]-array parameters are invalid, byte[]-array can not converted to ASN.1-OctetString: " + e.getMessage(), e);
        }
        return octetString;
    }

    public static ASN1Sequence checkConvertASN1Sequence(String blockMode, byte[] params) throws IOException {
        ASN1Sequence sequence = null;
        try {
            sequence = ASN1Sequence.getInstance((Object)params);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(blockMode + " - byte[]-array parameters are invalid, byte[]-array can not converted to ASN.1-Sequence: " + e.getMessage(), e);
        }
        return sequence;
    }

    @Override
    protected final byte[] engineGetEncoded() throws IOException {
        return this.raw;
    }

    @Override
    protected final byte[] engineGetEncoded(String format) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected final <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        return (T)((AlgorithmParameterSpec)paramSpec.cast(this.spec));
    }

    @Override
    protected final void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.spec = paramSpec;
    }

    @Override
    protected final void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected final String engineToString() {
        return super.toString() + "[" + this.spec.toString() + "]";
    }
}

