/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.params;

import de.bos_bremen.gov2.jca_provider.params.AbstractAlgorithmParameterSpi;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

public class AESGCMAlgorithmParameterSpi
extends AbstractAlgorithmParameterSpi {
    @Override
    protected void engineInit(byte[] params) throws IOException {
        ASN1Primitive seq2;
        byte[] iv;
        this.raw = params;
        ASN1Sequence sequence = AESGCMAlgorithmParameterSpi.checkConvertASN1Sequence("GCM", params);
        this.spec = null;
        int size = sequence.size();
        if (size != 2) {
            throw new IOException("GCM requires parameters with two elements: iv (byte[]) + mac length in bytes (int) - found: " + size);
        }
        ASN1Primitive seq1 = sequence.getObjectAt(0).toASN1Primitive();
        if (seq1 instanceof ASN1OctetString) {
            iv = ((ASN1OctetString)seq1).getOctets();
            seq2 = sequence.getObjectAt(1).toASN1Primitive();
            if (!(seq2 instanceof ASN1Integer)) {
                throw new IOException("GCM requires second parameter representing mac length in bytes (int), found: " + seq2.getClass().getName());
            }
        } else {
            throw new IOException("GCM requires first parameter representing iv (byte[]), found: " + seq1.getClass().getName());
        }
        int n = ((ASN1Integer)seq2).intPositiveValueExact();
        this.spec = new AEADParameterSpec(iv, n * 8);
    }
}

