/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.params;

import de.bos_bremen.gov2.jca_provider.params.AbstractAlgorithmParameterSpi;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

public class AESCCMAlgorithmParameterSpi
extends AbstractAlgorithmParameterSpi {
    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.raw = params;
        ASN1Sequence sequence = AESCCMAlgorithmParameterSpi.checkConvertASN1Sequence("CCM", params);
        this.spec = null;
        int size = sequence.size();
        if (size != 1) {
            throw new IOException("CCM requires parameters with one element: iv (byte[]) - found: " + size);
        }
        ASN1Primitive seq1 = sequence.getObjectAt(0).toASN1Primitive();
        if (!(seq1 instanceof ASN1OctetString)) {
            throw new IOException("CCM requires first parameter representing iv (byte[]), found: " + seq1.getClass().getName());
        }
        byte[] iv = ((ASN1OctetString)seq1).getOctets();
        this.spec = new AEADParameterSpec(iv, iv.length * 8);
    }
}

