/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.parts;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.EnumUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.PersistenceUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.net.URL;

public interface RegistryInfo<E> {
    public Class<E> getRegistryEntryClass() throws IllegalStateException;

    public RegistryMode getMode() throws IllegalStateException;

    public EntryHandler<E> getEntryHandler() throws IllegalStateException;

    public URL getPersistenceURL() throws IllegalStateException;

    public RegistryContent.Info getInfo();

    public boolean isLocked();

    public static class Util {
        private Util() {
        }

        public static <T> RegistryInfo<T> createRegistryInfo(final Object lock, final Class<T> registryEntryClass, final URL persistenceURL) throws IllegalArgumentException, IllegalStateException, IllegalAccessException {
            AssertUtil.notNull(registryEntryClass, "entry Class");
            AssertUtil.notNull(persistenceURL, "persistence URL");
            EntryHandler tmp2 = null;
            RegistryContent registryContent = PersistenceUtil.readRegistryContent(persistenceURL);
            final RegistryContent.Info info = registryContent.getInfo();
            try {
                EntryHandler tmp;
                tmp2 = tmp = (EntryHandler)Class.forName(info.getEntryHandlerClassName()).newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("handler not instantiated: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("handler not accessible: " + e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class of handler not found: " + e.getMessage(), e);
            }
            final EntryHandler handler = tmp2;
            final RegistryMode registryMode = EnumUtil.getEnumByName(RegistryMode.class, info.getMode());
            AssertUtil.notNull((Object)registryMode, "mode of registry");
            RegistryInfo result = new RegistryInfo<T>(){

                @Override
                public EntryHandler<T> getEntryHandler() throws IllegalStateException {
                    return handler;
                }

                @Override
                public RegistryContent.Info getInfo() {
                    return info;
                }

                @Override
                public RegistryMode getMode() throws IllegalStateException {
                    return registryMode;
                }

                @Override
                public URL getPersistenceURL() throws IllegalStateException {
                    return persistenceURL;
                }

                @Override
                public Class<T> getRegistryEntryClass() throws IllegalStateException {
                    return registryEntryClass;
                }

                @Override
                public boolean isLocked() {
                    return lock != null;
                }
            };
            if (result != null) {
                handler.init(lock, registryMode, result);
            }
            return result;
        }
    }
}

