/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts;

import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.SharedHolder;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.AbstractRegistryPersistence;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryChange;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryRequest;

public class RegistrySynchronousPersistence<E>
extends AbstractRegistryPersistence<E>
implements RegistryRequest<E>,
RegistryChange<E> {
    public RegistrySynchronousPersistence(SharedHolder<E> sharedHolder) {
        super(sharedHolder);
    }

    @Override
    public void store(Object lock) throws IllegalAccessException, IllegalStateException {
        throw new IllegalStateException("registry works synchronously");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Object lock) throws IllegalAccessException, IllegalStateException, RuntimeException {
        try {
            SharedHolder sharedHolder = this.sharedHolder;
            synchronized (sharedHolder) {
                this.sharedHolder.getLockedState().checkAccess(lock);
                if (this.sharedHolder.getContentChangedState().hasContentChanged()) {
                    this.sharedHolder.getCallback().load(this);
                }
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("destroyed");
        }
    }

    @Override
    protected void postProcess(Object lock) throws IllegalAccessException, IllegalStateException, RuntimeException {
        this.sharedHolder.toContentChangedState();
        this.sharedHolder.getRegistryState().checkOpened();
        this.sharedHolder.getLockedState().checkAccess(lock);
        this.sharedHolder.getCallback().store(this);
        this.sharedHolder.toContentUnchangedState();
    }
}

