/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.ObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryEvent;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryListener;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.impl.ObjectRegistryEventImpl;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.Destroy;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.LockedState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryListener;
import java.util.ArrayList;
import java.util.List;

public class RegistryListenerImpl<E>
implements RegistryListener<E>,
Destroy<E> {
    private LockedState lockedState = null;
    private List<ObjectRegistryListener<E>> listenerList = null;

    public RegistryListenerImpl(LockedState lockedState) throws IllegalArgumentException {
        AssertUtil.notNull(lockedState, "locked state");
        this.lockedState = lockedState;
        this.listenerList = new ArrayList<ObjectRegistryListener<E>>();
    }

    @Override
    public synchronized void addListener(Object lock, ObjectRegistryListener<E> listener) throws IllegalAccessException, IllegalStateException {
        this.lockedState.checkAccess(lock);
        if (listener != null && this.listenerList != null && !this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public synchronized boolean isListener(ObjectRegistryListener<E> listener) {
        return this.listenerList != null ? this.listenerList.contains(listener) : false;
    }

    @Override
    public synchronized void removeListener(Object lock, ObjectRegistryListener<E> listener) throws IllegalAccessException, IllegalStateException {
        this.lockedState.checkAccess(lock);
        if (listener != null && this.listenerList != null && this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
    }

    @Override
    public synchronized void destroy(ObjectRegistry<E> registry) {
        ObjectRegistryEventImpl<E> event = new ObjectRegistryEventImpl<E>(registry);
        this.notifyListener(event);
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryListenerImpl.this.listenerList.clear();
                RegistryListenerImpl.this.listenerList = null;
                RegistryListenerImpl.this.lockedState = null;
            }
        }).start();
    }

    public synchronized void notifyListener(ObjectRegistryEvent<E> event) {
        if (event != null && this.listenerList != null) {
            for (ObjectRegistryListener<E> listener : this.listenerList) {
                try {
                    listener.processEvent(event);
                }
                catch (Exception exception) {}
            }
        }
    }
}

