/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.ObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.Destroy;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.LockedState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.PersistenceMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.ObjectFactory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.net.URL;

public class RegistryInfoImpl<E>
implements RegistryInfo<E>,
Destroy<E> {
    private Class<E> registryEntryClass = null;
    private LockedState lockedState = null;
    private RegistryMode registryMode = null;
    private RegistryContent.Info info = null;
    private EntryHandler<E> handler = null;
    private URL persistenceURL = null;

    public RegistryInfoImpl(LockedState lockedState, RegistryInfo<E> registryInfo) throws IllegalArgumentException {
        this(lockedState, registryInfo.getRegistryEntryClass(), registryInfo.getMode(), registryInfo.getInfo(), registryInfo.getEntryHandler(), registryInfo.getPersistenceURL());
    }

    public RegistryInfoImpl(LockedState lockedState, Class<E> registryEntryClass, RegistryMode mode, RegistryContent.Info info, EntryHandler<E> handler, URL persistenceURL) throws IllegalArgumentException {
        AssertUtil.notNull(lockedState, "locked state");
        AssertUtil.notNull(registryEntryClass, "entry Class");
        AssertUtil.notNull((Object)mode, "mode of registry");
        AssertUtil.notNull(info, "info");
        AssertUtil.notNull(handler, "handler");
        if (PersistenceMode.MEMORY == mode.getPersistenceMode()) {
            AssertUtil.isNull(persistenceURL, "persistence URL");
        } else {
            AssertUtil.notNull(persistenceURL, "persistence URL");
        }
        this.registryEntryClass = registryEntryClass;
        this.lockedState = lockedState;
        this.registryMode = mode;
        RegistryContent.Info copyInfo = new ObjectFactory().createRegistryContentInfo();
        copyInfo.setName(info.getName());
        copyInfo.setHashAlgorithm(info.getHashAlgorithm());
        copyInfo.setMode(info.getMode());
        copyInfo.setEntryHandlerClassName(info.getEntryHandlerClassName());
        this.info = copyInfo;
        this.handler = handler;
        this.persistenceURL = persistenceURL;
    }

    @Override
    public EntryHandler<E> getEntryHandler() throws IllegalStateException {
        return this.handler;
    }

    @Override
    public RegistryContent.Info getInfo() {
        return this.info;
    }

    @Override
    public RegistryMode getMode() throws IllegalStateException {
        return this.registryMode;
    }

    @Override
    public URL getPersistenceURL() throws IllegalStateException {
        return this.persistenceURL;
    }

    @Override
    public Class<E> getRegistryEntryClass() throws IllegalStateException {
        return this.registryEntryClass;
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lockedState.isLocked();
    }

    @Override
    public synchronized void destroy(ObjectRegistry<E> registry) {
        this.registryEntryClass = null;
        this.lockedState = null;
        this.persistenceURL = null;
        this.registryMode = null;
        this.info = null;
        this.handler = null;
    }
}

