/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts;

import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryFilter;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryEvent;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryEventType;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.impl.ObjectRegistryEventImpl;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.SharedHolder;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryChange;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractRegistryPersistence<E>
implements RegistryRequest<E>,
RegistryChange<E> {
    protected SharedHolder<E> sharedHolder = null;

    protected AbstractRegistryPersistence(SharedHolder<E> sharedHolder) {
        this.sharedHolder = sharedHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(Object lock, E entry) throws IllegalAccessException, IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            EntryWrapper<E> oldWEntry = this.removeInt(lock, entry);
            this.doPostProcess(lock);
            ObjectRegistryEventImpl<E> event = null;
            if (oldWEntry == null) {
                return;
            }
            event = new ObjectRegistryEventImpl<E>(this.sharedHolder.getRegistry(), oldWEntry, false);
            try {
                this.sharedHolder.getListener().notifyListener(event);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("destroyed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAll(Object lock, List<E> entryList) throws IllegalAccessException, IllegalStateException {
        if (entryList == null || entryList.isEmpty()) {
            return;
        }
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            this.sharedHolder.getRegistryState().checkOpened();
            this.sharedHolder.getLockedState().checkAccess(lock);
            ArrayList<ObjectRegistryEventImpl<E>> eventList = new ArrayList<ObjectRegistryEventImpl<E>>();
            for (E e : entryList) {
                EntryWrapper<E> removedEntry;
                if (e == null || (removedEntry = this.removeInt(e)) == null) continue;
                eventList.add(new ObjectRegistryEventImpl<E>(this, removedEntry, false));
            }
            this.doPostProcess(lock);
            if (!eventList.isEmpty()) {
                for (ObjectRegistryEvent objectRegistryEvent : eventList) {
                    try {
                        this.sharedHolder.getListener().notifyListener(objectRegistryEvent);
                    }
                    catch (NullPointerException e) {
                        throw new IllegalStateException("destroyed");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void set(Object lock, int index, E newEntry) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            EntryWrapper<E> oldWE = this.sharedHolder.getWrapperList().get(index);
            this.change(lock, oldWE.getEntry(), newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E get(int index) throws IllegalStateException, IllegalArgumentException {
        EntryWrapper<E> wrapperEntry = null;
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperEntry = this.sharedHolder.getWrapperList().get(index);
        }
        return wrapperEntry != null ? (E)wrapperEntry.getEntry() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<E> get(EntryFilter<E> filter) throws IllegalStateException {
        if (filter == null) {
            return this.getEntryList();
        }
        List<EntryWrapper<E>> wrapperList = null;
        ArrayList<E> result = new ArrayList<E>();
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperList = this.sharedHolder.getWrapperList();
            for (EntryWrapper<E> entryWrapper : wrapperList) {
                if (!filter.accept(entryWrapper)) continue;
                result.add(entryWrapper.getEntry());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getByID(String id) throws IllegalStateException {
        EntryWrapper<E> wrapperEntry = null;
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperEntry = this.sharedHolder.getIdWrapperMap().get(id);
        }
        return wrapperEntry != null ? (E)wrapperEntry.getEntry() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E getByName(String name) throws IllegalStateException {
        EntryWrapper<E> wrapperEntry = null;
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperEntry = this.sharedHolder.getNameWrapperMap().get(name);
        }
        return wrapperEntry != null ? (E)wrapperEntry.getEntry() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<E> getEntryList() throws IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            List<Object> result = Arrays.asList(this.sharedHolder.getEntryWrapperMap().keySet().toArray());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getID(E entry) throws IllegalStateException {
        if (entry == null) {
            return null;
        }
        EntryWrapper<E> wrapperEntry = null;
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperEntry = this.sharedHolder.getEntryWrapperMap().get(entry);
        }
        return wrapperEntry != null ? wrapperEntry.getID() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> getIDs() throws IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return Arrays.asList(this.sharedHolder.getIdWrapperMap().keySet().toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getName(E entry) throws IllegalStateException {
        if (entry == null) {
            return null;
        }
        EntryWrapper<E> wrapperEntry = null;
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperEntry = this.sharedHolder.getEntryWrapperMap().get(entry);
        }
        return wrapperEntry != null ? wrapperEntry.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<String> getNameList() throws IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return Arrays.asList(this.sharedHolder.getNameWrapperMap().keySet().toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EntryWrapper<E> getWrapper(E entry) throws IllegalStateException {
        EntryWrapper<E> wrapperEntry = null;
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            wrapperEntry = this.sharedHolder.getEntryWrapperMap().get(entry);
        }
        return wrapperEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasContentChanged() {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return this.sharedHolder.getContentChangedState().hasContentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return this.sharedHolder.getWrapperList().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return this.sharedHolder.getWrapperList().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EntryWrapper<E> add(Object lock, E entry) throws IllegalAccessException, IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            EntryWrapper<E> newWEntry = this.addInt(lock, entry);
            this.doPostProcess(lock);
            ObjectRegistryEventImpl<E> event = null;
            if (newWEntry == null) {
                return null;
            }
            event = new ObjectRegistryEventImpl<E>(this.sharedHolder.getRegistry(), newWEntry, true);
            try {
                this.sharedHolder.getListener().notifyListener(event);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("destroyed");
            }
            return newWEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<EntryWrapper<E>> addAll(Object lock, List<E> entryList) throws IllegalAccessException, IllegalStateException {
        ArrayList<EntryWrapper<EntryWrapper<E>>> result = new ArrayList<EntryWrapper<EntryWrapper<E>>>();
        if (entryList == null || entryList.isEmpty()) {
            return result;
        }
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            this.sharedHolder.getRegistryState().checkOpened();
            this.sharedHolder.getLockedState().checkAccess(lock);
            ArrayList<ObjectRegistryEventImpl<E>> eventList = new ArrayList<ObjectRegistryEventImpl<E>>();
            for (E e : entryList) {
                if (e != null) {
                    EntryWrapper<E> addEntry = this.addInt(e);
                    if (addEntry != null) {
                        result.add(addEntry);
                        eventList.add(new ObjectRegistryEventImpl<E>(this, addEntry, true));
                        continue;
                    }
                    result.add(null);
                    continue;
                }
                result.add(null);
            }
            this.doPostProcess(lock);
            if (!eventList.isEmpty()) {
                for (ObjectRegistryEvent objectRegistryEvent : eventList) {
                    try {
                        this.sharedHolder.getListener().notifyListener(objectRegistryEvent);
                    }
                    catch (NullPointerException e) {
                        throw new IllegalStateException("destroyed");
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void change(Object lock, E oldEntry, E newEntry) throws IllegalAccessException, IllegalStateException {
        if (oldEntry == null && newEntry == null) {
            return;
        }
        if (oldEntry == null) {
            this.add(lock, newEntry);
        } else if (newEntry == null) {
            this.remove(lock, newEntry);
        } else {
            SharedHolder<E> sharedHolder = this.sharedHolder;
            synchronized (sharedHolder) {
                EntryWrapper<E> oldWEntry = this.removeInt(lock, oldEntry);
                EntryWrapper<E> newWEntry = this.addInt(lock, newEntry);
                ObjectRegistryEventImpl<E> event = null;
                if (oldWEntry != null && newWEntry != null) {
                    event = new ObjectRegistryEventImpl<E>(this.sharedHolder.getRegistry(), newWEntry, oldWEntry);
                } else if (oldWEntry == null || newWEntry == null) {
                    event = new ObjectRegistryEventImpl<E>(this.sharedHolder.getRegistry(), oldWEntry != null ? oldWEntry : newWEntry, oldWEntry == null);
                } else {
                    return;
                }
                this.doPostProcess(lock);
                this.sharedHolder.getListener().notifyListener(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void changeByID(Object lock, String id, E newEntry) throws IllegalAccessException, IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            EntryWrapper<E> oldWE = this.sharedHolder.getIdWrapperMap().get(id);
            this.change(lock, oldWE != null ? (E)oldWE.getEntry() : null, newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void changeByName(Object lock, String name, E newEntry) throws IllegalAccessException, IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            EntryWrapper<E> oldWE = this.sharedHolder.getNameWrapperMap().get(name);
            this.change(lock, oldWE != null ? (E)oldWE.getEntry() : null, newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(Object lock) throws IllegalAccessException, IllegalStateException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            this.sharedHolder.getRegistryState().checkOpened();
            this.sharedHolder.getLockedState().checkAccess(lock);
            this.sharedHolder.getEntryWrapperMap().clear();
            this.sharedHolder.getNameWrapperMap().clear();
            this.sharedHolder.getIdWrapperMap().clear();
            this.sharedHolder.getWrapperList().clear();
            this.doPostProcess(lock);
            ObjectRegistryEventImpl<E> event = new ObjectRegistryEventImpl<E>(ObjectRegistryEventType.CLEARED, this.sharedHolder.getRegistry());
            try {
                this.sharedHolder.getListener().notifyListener(event);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("destroyed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean contains(E entry) {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return this.sharedHolder.getEntryWrapperMap().containsKey(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsID(String id) {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return this.sharedHolder.getIdWrapperMap().containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsName(String name) {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            return this.sharedHolder.getNameWrapperMap().containsKey(name);
        }
    }

    protected abstract void postProcess(Object var1) throws IllegalAccessException, IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostProcess(Object lock) throws IllegalAccessException, IllegalStateException {
        try {
            SharedHolder<E> sharedHolder = this.sharedHolder;
            synchronized (sharedHolder) {
                this.postProcess(lock);
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntryWrapper<E> addInt(Object lock, E addEntry) throws IllegalAccessException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            this.sharedHolder.getRegistryState().checkOpened();
            this.sharedHolder.getLockedState().checkAccess(lock);
            EntryWrapper<E> wrapper = null;
            if (!this.sharedHolder.getEntryWrapperMap().containsKey(addEntry)) {
                wrapper = this.sharedHolder.getInfo().getEntryHandler().toWrapper(addEntry);
                if (!this.sharedHolder.getIdWrapperMap().containsKey(wrapper.getID()) && !this.sharedHolder.getNameWrapperMap().containsKey(wrapper.getName())) {
                    this.addInt(lock, wrapper);
                }
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addInt(Object lock, EntryWrapper<E> addEntry) throws IllegalAccessException {
        if (addEntry == null) {
            return;
        }
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            this.doAdd(addEntry);
        }
    }

    private final EntryWrapper<E> addInt(E addEntry) throws IllegalAccessException {
        EntryWrapper<E> wrapper = this.sharedHolder.getInfo().getEntryHandler().toWrapper(addEntry);
        this.addInt(wrapper);
        return wrapper;
    }

    private final void addInt(EntryWrapper<E> addEntry) throws IllegalAccessException {
        if (addEntry == null) {
            return;
        }
        this.doAdd(addEntry);
    }

    private final void doAdd(EntryWrapper<E> addEntry) {
        this.sharedHolder.getEntryWrapperMap().put(addEntry.getEntry(), addEntry);
        this.sharedHolder.getIdWrapperMap().put(addEntry.getID(), addEntry);
        this.sharedHolder.getNameWrapperMap().put(addEntry.getName(), addEntry);
        this.sharedHolder.getWrapperList().add(addEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EntryWrapper<E> removeInt(Object lock, E removeEntry) throws IllegalAccessException {
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            EntryWrapper<E> wrapper = this.sharedHolder.getEntryWrapperMap().get(removeEntry);
            this.removeInt(lock, wrapper);
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeInt(Object lock, EntryWrapper<E> removeEntry) throws IllegalAccessException {
        if (removeEntry == null) {
            return;
        }
        SharedHolder<E> sharedHolder = this.sharedHolder;
        synchronized (sharedHolder) {
            this.sharedHolder.getRegistryState().checkOpened();
            this.sharedHolder.getLockedState().checkAccess(lock);
            this.doRemove(removeEntry);
        }
    }

    private final EntryWrapper<E> removeInt(E removeEntry) throws IllegalAccessException {
        EntryWrapper<E> wrapper = this.sharedHolder.getEntryWrapperMap().get(removeEntry);
        this.removeInt(wrapper);
        return wrapper;
    }

    private final void removeInt(EntryWrapper<E> removeEntry) {
        if (removeEntry == null) {
            return;
        }
        this.doRemove(removeEntry);
    }

    private final void doRemove(EntryWrapper<E> removeEntry) {
        this.sharedHolder.getEntryWrapperMap().remove(removeEntry.getEntry());
        this.sharedHolder.getIdWrapperMap().remove(removeEntry.getID());
        this.sharedHolder.getNameWrapperMap().remove(removeEntry.getName());
        this.sharedHolder.getWrapperList().remove(removeEntry);
    }
}

