/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.gov2.jca_provider.ocf.registry.ObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.Destroy;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.PersistenceCallBack;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.AbstractRegistryState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.ClosedRegistryState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.ContentChangedState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.LockedState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.OpenedRegistryState;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.RegistryInfoImpl;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.RegistryListenerImpl;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryChange;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryRequest;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SharedHolder<E>
implements Destroy<E> {
    private Object lock = null;
    private boolean initiliazed = false;
    private ObjectRegistry<E> registry = null;
    private PersistenceCallBack<E> callback = null;
    private Map<E, EntryWrapper<E>> entryWrapperMap = null;
    private Map<String, EntryWrapper<E>> idWrapperMap = null;
    private Map<String, EntryWrapper<E>> nameWrapperMap = null;
    private List<EntryWrapper<E>> wrapperList = null;
    private RegistryRequest<E> request = null;
    private RegistryChange<E> change = null;
    private RegistryListenerImpl<E> listener = null;
    private LockedState lockedState = null;
    private AbstractRegistryState<E> openState = null;
    private AbstractRegistryState<E> closedState = null;
    private AbstractRegistryState<E> currentRegistryState = null;
    private ContentChangedState changedState = null;
    private ContentChangedState unchangedState = null;
    private ContentChangedState currentContentChangedState = null;
    private RegistryInfo<E> info = null;

    public synchronized void init(RegistryRequest<E> request, RegistryChange<E> change) throws IllegalStateException {
        if (this.initiliazed) {
            throw new IllegalStateException("already initialized");
        }
        this.request = request;
        this.change = change;
    }

    protected SharedHolder(Object lock, RegistryContent.Info info, URL persistenceURL, PersistenceCallBack<E> callback, ObjectRegistry<E> registry) throws IllegalArgumentException {
    }

    protected SharedHolder(Object lock, RegistryInfo<E> registryInfo, PersistenceCallBack<E> callback, ObjectRegistry<E> registry) throws IllegalArgumentException {
        this.lock = lock;
        this.lockedState = LockedState.Util.createLockedState(lock);
        RegistryListenerImpl tmp = new RegistryListenerImpl(this.lockedState);
        this.registry = registry;
        this.listener = tmp;
        this.callback = callback;
        this.openState = new OpenedRegistryState(this.lockedState, this);
        this.closedState = new ClosedRegistryState(this.lockedState, this);
        this.currentRegistryState = this.closedState;
        this.info = new RegistryInfoImpl<E>(this.lockedState, registryInfo);
        this.changedState = ContentChangedState.Util.createContentChangedState(true);
        this.currentContentChangedState = this.unchangedState = ContentChangedState.Util.createContentChangedState(false);
        this.wrapperList = new ArrayList<EntryWrapper<E>>();
        this.idWrapperMap = new LinkedHashMap<String, EntryWrapper<E>>();
        this.nameWrapperMap = new LinkedHashMap<String, EntryWrapper<E>>();
        this.entryWrapperMap = new LinkedHashMap<E, EntryWrapper<E>>();
    }

    @Override
    public synchronized void destroy(ObjectRegistry<E> registry) {
        if (this.listener != null) {
            this.listener.destroy(registry);
        }
        this.listener = null;
        this.lockedState = null;
        try {
            this.openState.destroy(this.lock);
            this.closedState.destroy(this.lock);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.openState = null;
        this.closedState = null;
        this.currentRegistryState = null;
        this.currentContentChangedState = null;
        this.entryWrapperMap.clear();
        this.entryWrapperMap = null;
        this.wrapperList.clear();
        this.wrapperList = null;
        this.idWrapperMap.clear();
        this.idWrapperMap = null;
        this.nameWrapperMap.clear();
        this.nameWrapperMap = null;
        this.callback = null;
        this.registry = null;
    }

    public ObjectRegistry<E> getRegistry() {
        return this.registry;
    }

    public RegistryListenerImpl<E> getListener() {
        return this.listener;
    }

    public Map<E, EntryWrapper<E>> getEntryWrapperMap() {
        return this.entryWrapperMap;
    }

    public Map<String, EntryWrapper<E>> getIdWrapperMap() {
        return this.idWrapperMap;
    }

    public AbstractRegistryState<E> getRegistryState() {
        return this.currentRegistryState;
    }

    public List<EntryWrapper<E>> getWrapperList() {
        return this.wrapperList;
    }

    public LockedState getLockedState() {
        return this.lockedState;
    }

    public RegistryInfo<E> getInfo() {
        return this.info;
    }

    public Map<String, EntryWrapper<E>> getNameWrapperMap() {
        return this.nameWrapperMap;
    }

    public ContentChangedState getContentChangedState() {
        return this.currentContentChangedState;
    }

    public RegistryChange<E> getChange() {
        return this.change;
    }

    public RegistryRequest<E> getRequest() {
        return this.request;
    }

    public void toContentChangedState() {
        this.currentContentChangedState = this.changedState;
    }

    public void toContentUnchangedState() {
        this.currentContentChangedState = this.unchangedState;
    }

    public void toRegistryOpenState() {
        this.currentRegistryState = this.openState;
    }

    public void toRegistryClosedState() {
        this.currentRegistryState = this.closedState;
    }

    public PersistenceCallBack<E> getCallback() {
        return this.callback;
    }
}

