/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.asn1.cvc.ECCVCertificate;
import de.bos_bremen.common.io.FileUtil;
import de.bos_bremen.gov2.jca_provider.ocf.cif.CardInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.ObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.BasicRegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.ObjectRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.cif.CardInfoHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.cvc.CVCHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.ObjectFactory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.net.MalformedURLException;
import java.net.URL;

public class RegistryManager {
    public static final String DEFAULT_REGISTRY_PERSISTENCE_MODE = RegistryMode.PERSISTENT_EXTERNAL_SYNCHRONOUS_ON_THE_FLY.name();
    public static final String DEFAULT_HASH_ALGORITHM = "SHA1";
    private static final String PERSISTENCE_URL_CVC_REGISTRY = "file://" + FileUtil.getUserDirectory().getAbsolutePath() + "/cvcRegistry.reg";
    private static final String PERSISTENCE_URL_CARD_INFO_REGISTRY = "file://" + FileUtil.getUserDirectory().getAbsolutePath() + "/cardInfoRegistry.reg";
    private static RegistryManager SINGLETON = null;
    private ObjectRegistry<CardInfo> cardInfoRegistry = null;
    private ObjectRegistry<ECCVCertificate> cvcRegistry = null;
    private Object managerLock = null;

    private RegistryManager(Object lock, URL cardInfoPersistenceURL, URL cvcPersistenceURL) throws IllegalArgumentException {
        try {
            this.managerLock = lock;
            cardInfoPersistenceURL = new URL(PERSISTENCE_URL_CARD_INFO_REGISTRY);
            cvcPersistenceURL = new URL(PERSISTENCE_URL_CVC_REGISTRY);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.cardInfoRegistry = this.createRegistry(lock, "CardInfoRegistry", CardInfo.class, new CardInfoHandler(), cardInfoPersistenceURL);
        this.cvcRegistry = this.createRegistry(lock, "CVCRegistry", ECCVCertificate.class, new CVCHandler(), cvcPersistenceURL);
    }

    private <E> ObjectRegistry<E> createRegistry(Object lock, String name, Class<E> entryClass, EntryHandler<E> entryHandler, URL persistenceURL) throws IllegalArgumentException {
        ObjectRegistryImpl<E> result = null;
        try {
            RegistryContent.Info info = BasicRegistryInfo.createInfo(name, DEFAULT_HASH_ALGORITHM, DEFAULT_REGISTRY_PERSISTENCE_MODE, entryHandler.getClass(), null, null);
            BasicRegistryInfo<E> registryInfo = new BasicRegistryInfo<E>(null, info, entryClass, entryHandler, persistenceURL);
            result = new ObjectRegistryImpl<E>(lock, registryInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    public static synchronized RegistryManager getInstance(Object lock, URL cardInfoPersistenceURL, URL cvcPersistenceURL) {
        if (SINGLETON == null) {
            SINGLETON = new RegistryManager(lock, cardInfoPersistenceURL, cvcPersistenceURL);
        }
        return SINGLETON;
    }

    public static RegistryContent.Info createInfo(String name, String hashAlgorithmName, String mode, Class<?> entryHandler) throws IllegalArgumentException {
        ObjectFactory objectFactory = new ObjectFactory();
        RegistryContent.Info info = objectFactory.createRegistryContentInfo();
        info.setName(name);
        info.setHashAlgorithm(hashAlgorithmName);
        info.setMode(mode);
        info.setEntryHandlerClassName(entryHandler.getName());
        return info;
    }

    public ObjectRegistry<CardInfo> getCardInfoRegistry() {
        return this.cardInfoRegistry;
    }

    public ObjectRegistry<ECCVCertificate> getCvcRegistry() {
        return this.cvcRegistry;
    }

    public boolean isDestroyed() {
        return ObjectUtil.isNull(SINGLETON);
    }

    public synchronized void destroy(Object lock) throws IllegalStateException, IllegalAccessException {
        if (ObjectUtil.isNull(SINGLETON)) {
            throw new IllegalStateException("Manager already destroyed");
        }
        if (ObjectUtil.notEquals(this.managerLock, lock)) {
            throw new IllegalAccessException("wrong lock for destroying manager used");
        }
        RegistryManager.SINGLETON.cardInfoRegistry = null;
        RegistryManager.SINGLETON.cvcRegistry = null;
        SINGLETON = null;
    }
}

