/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.ObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.PersistenceMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.ObjectFactory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class PersistenceUtil {
    private PersistenceUtil() {
    }

    public static RegistryContent.Info createInfo(String name, String hashAlgorithm, String mode) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(name, "name");
        AssertUtil.notNullOrEmpty(hashAlgorithm, "hash algorithm");
        AssertUtil.notNullOrEmpty(mode, "mode");
        RegistryContent.Info result = null;
        ObjectFactory objectFactory = new ObjectFactory();
        result = objectFactory.createRegistryContentInfo();
        result.setName(name);
        result.setHashAlgorithm(hashAlgorithm);
        result.setMode(mode);
        return result;
    }

    public static <E> RegistryContent.Entries.Entry toEntry(EntryWrapper<E> wrapper) {
        RegistryContent.Entries.Entry result = null;
        ObjectFactory objectFactory = new ObjectFactory();
        result = objectFactory.createRegistryContentEntriesEntry();
        result.setId(wrapper.getID());
        result.setName(wrapper.getName());
        result.setHash(wrapper.getHash());
        if (wrapper.getRegistryMode().getPersistenceMode() == PersistenceMode.PERSISTENT_INTERNAL) {
            result.setEncoded(wrapper.getBytes());
        }
        result.setProperties(PersistenceUtil.toProperties(wrapper.getProperties()));
        return result;
    }

    public static RegistryContent.Entries.Entry.Properties toProperties(Properties properties) {
        ObjectFactory objectFactory = new ObjectFactory();
        RegistryContent.Entries.Entry.Properties result = objectFactory.createRegistryContentEntriesEntryProperties();
        RegistryContent.Entries.Entry.Properties.Property tmp = null;
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                tmp = objectFactory.createRegistryContentEntriesEntryPropertiesProperty();
                tmp.setName(entry.getKey().toString());
                tmp.setValue(entry.getValue().toString());
                result.getProperty().add(tmp);
            }
        }
        return result;
    }

    public static Properties toProperties(RegistryContent.Entries.Entry.Properties properties) {
        Properties result = new Properties();
        if (!CollectionUtil.isNullOrEmpty(properties.getProperty())) {
            for (RegistryContent.Entries.Entry.Properties.Property property : properties.getProperty()) {
                result.setProperty(property.getName(), property.getValue());
            }
        }
        return result;
    }

    public static RegistryContent readRegistryContent(URL persistenceURL) throws RuntimeException {
        RegistryContent registryContent = null;
        InputStream is = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RegistryContent.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(ObjectRegistry.class.getResourceAsStream("registry.xsd")));
            unmarshaller.setSchema(schema);
            is = persistenceURL.openStream();
            registryContent = (RegistryContent)unmarshaller.unmarshal(is);
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException("loading registry content failed: " + e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return registryContent;
    }

    public static byte[] hash(byte[] bytes, String hashlgorithm) throws IllegalArgumentException {
        AssertUtil.notNullOrEmpty(hashlgorithm, "algorithm");
        byte[] result = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashlgorithm, "BC");
            result = messageDigest.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("hash algorithm not supported: " + hashlgorithm, e);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException("no JCA provider Bouncy Castle found", e);
        }
        return result;
    }
}

