/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.common.io.FileUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.ObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryFilter;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryListener;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.PersistenceCallBack;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.PersistenceUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.SharedHolder;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.WorkingRegistryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.AbstractRegistryPersistence;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.RegistryAsynchronousPersistence;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.RegistryMemory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.parts.RegistrySynchronousPersistence;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.CacheMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.PersistenceMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.SyncMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryChange;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.ObjectFactory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public final class ObjectRegistryImpl<E>
implements ObjectRegistry<E>,
PersistenceCallBack<E> {
    private ObjectRegistry<E> currentState = null;
    private SharedHolder<E> holder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectRegistryImpl(Object lock, RegistryInfo<E> registryInfo) throws IllegalArgumentException {
        this.holder = new SharedHolder<E>(lock, registryInfo, this, this);
        ObjectRegistryImpl.initHolder(registryInfo, this.holder);
        this.currentState = new WorkingRegistryImpl<E>(this.holder);
        if (PersistenceMode.MEMORY != registryInfo.getMode().getPersistenceMode()) {
            try {
                File pf = FileUtil.to(this.holder.getInfo().getPersistenceURL());
                if (pf.exists()) {
                    InputStream is = this.holder.getInfo().getPersistenceURL().openStream();
                    if (is != null) {
                        is.close();
                    }
                    this.holder.toContentChangedState();
                    this.load(this.holder.getChange());
                }
            }
            catch (IllegalStateException pf) {
            }
            catch (IOException e) {
                throw new IllegalArgumentException("persistence URL not readable");
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                this.holder.toContentUnchangedState();
            }
        }
    }

    private static <T> void initHolder(RegistryInfo<T> registryInfo, SharedHolder<T> holder) {
        AbstractRegistryPersistence change = null;
        AbstractRegistryPersistence request = null;
        if (PersistenceMode.MEMORY == registryInfo.getMode().getPersistenceMode()) {
            RegistryMemory<T> rm;
            change = rm = new RegistryMemory<T>(holder);
            request = rm;
        } else if (SyncMode.SYNCHRONOUS == registryInfo.getMode().getSyncMode()) {
            RegistrySynchronousPersistence<T> rsp = new RegistrySynchronousPersistence<T>(holder);
            change = rsp;
            request = rsp;
        } else if (SyncMode.ASYNCHRONOUS == registryInfo.getMode().getSyncMode()) {
            RegistryAsynchronousPersistence<T> rap = new RegistryAsynchronousPersistence<T>(holder);
            change = rap;
            request = rap;
        }
        holder.init(request, change);
    }

    @Override
    public void load(RegistryChange<E> caller) throws IllegalAccessException, RuntimeException {
        if (this.holder.getChange() != caller) {
            throw new IllegalAccessException("illegal access to internal used load method");
        }
        RegistryContent registryContent = PersistenceUtil.readRegistryContent(this.getPersistenceURL());
        if (registryContent != null) {
            this.holder.getWrapperList().clear();
            this.holder.getIdWrapperMap().clear();
            this.holder.getNameWrapperMap().clear();
            this.holder.getEntryWrapperMap().clear();
            for (RegistryContent.Entries.Entry entry : registryContent.getEntries().getEntry()) {
                byte[] entryBytes = null;
                File externalFile = null;
                URL externalURL = null;
                if (this.holder.getInfo().getMode().getPersistenceMode().isExternal()) {
                    externalFile = this.getExternalFile(entry.getId());
                    externalURL = FileUtil.to(externalFile);
                    if (this.holder.getInfo().getMode().getCacheMode() == CacheMode.CACHE) {
                        try {
                            entryBytes = FileUtil.readBytesOfFile(externalFile);
                        }
                        catch (FileNotFoundException e) {
                            throw new RuntimeException("external persistence loading failed");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("external persistence loading failed");
                        }
                    }
                }
                EntryWrapper<E> wrapper = null;
                try {
                    wrapper = this.holder.getInfo().getEntryHandler().toWrapper(entry, entryBytes, externalURL);
                    this.holder.getWrapperList().add(wrapper);
                    this.holder.getIdWrapperMap().put(wrapper.getID(), wrapper);
                    this.holder.getNameWrapperMap().put(wrapper.getName(), wrapper);
                    this.holder.getEntryWrapperMap().put(wrapper.getEntry(), wrapper);
                }
                catch (Exception e) {
                    throw new RuntimeException("handler can not initialize wrapper (handler and wrapper not implemented correctly)", e);
                }
            }
        }
    }

    @Override
    public void store(RegistryChange<E> caller) throws IllegalAccessException, RuntimeException {
        if (this.holder.getChange() != caller) {
            throw new IllegalAccessException("illegal access to internal used store method");
        }
        OutputStream os = null;
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            RegistryContent registryContent = objectFactory.createRegistryContent();
            RegistryContent.Entries entries = objectFactory.createRegistryContentEntries();
            registryContent.setEntries(entries);
            registryContent.setInfo(this.holder.getInfo().getInfo());
            for (EntryWrapper<E> wrapper : this.holder.getWrapperList()) {
                entries.getEntry().add(PersistenceUtil.toEntry(wrapper));
                if (!this.holder.getInfo().getMode().getPersistenceMode().isExternal()) continue;
                OutputStream fos = null;
                File f = null;
                try {
                    f = this.getExternalFile(wrapper.getID());
                    if (f.exists()) {
                        Files.delete(f.toPath());
                    }
                    if (f.exists()) {
                        throw new UnsupportedOperationException("external persistence failed: existing file can not be deleted");
                    }
                    fos = new FileOutputStream(f);
                    ((FileOutputStream)fos).write(wrapper.getBytes());
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (Exception e) {
                    try {
                        if (fos != null) {
                            fos.flush();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (fos != null) {
                            ((FileOutputStream)fos).close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (f != null) {
                        Files.delete(f.toPath());
                    }
                    throw new RuntimeException("external storing of byte[]-array failed for wrapper failed: " + e.getMessage(), e);
                }
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RegistryContent.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            Schema schema = schemaFactory.newSchema(new StreamSource(ObjectRegistry.class.getResourceAsStream("registry.xsd")));
            URL url = this.getPersistenceURL();
            marshaller.setSchema(schema);
            if (!"file".equals(url.getProtocol())) {
                throw new UnsupportedOperationException("only file protocol supported for persistence yet");
            }
            File f = new File(url.getFile());
            os = new FileOutputStream(f);
            marshaller.marshal((Object)registryContent, os);
        }
        catch (Exception e) {
            throw new RuntimeException("storing registry content failed: " + e.getMessage(), e);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException iOException) {}
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File getExternalFile(String name) {
        File pf = new File(this.holder.getInfo().getPersistenceURL().getFile());
        String registryPrefix = pf.getName();
        int idx = registryPrefix.lastIndexOf(".");
        if (idx >= 0) {
            registryPrefix = registryPrefix.substring(0, idx);
        }
        RegistryContent.Info.ExternalFileSettings externalFileSettings = this.holder.getInfo().getInfo().getExternalFileSettings();
        String prefix = "";
        Object suffix = "";
        if (externalFileSettings != null) {
            prefix = this.holder.getInfo().getInfo().getExternalFileSettings().getPrefix();
            suffix = "." + this.holder.getInfo().getInfo().getExternalFileSettings().getSuffix();
        }
        File f = new File(pf.getParentFile().getAbsolutePath() + "/" + prefix + registryPrefix + "_entry_" + name + (String)suffix);
        return f;
    }

    @Override
    public EntryWrapper<E> add(Object lock, E entry) throws IllegalAccessException, IllegalStateException {
        return this.currentState.add(lock, entry);
    }

    @Override
    public List<EntryWrapper<E>> addAll(Object lock, List<E> entryList) throws IllegalAccessException, IllegalStateException {
        return this.currentState.addAll(lock, entryList);
    }

    @Override
    public void addListener(Object lock, ObjectRegistryListener<E> listener) throws IllegalAccessException, IllegalStateException {
        this.currentState.addListener(lock, listener);
    }

    @Override
    public void change(Object lock, E oldEntry, E newEntry) throws IllegalAccessException, IllegalStateException {
        this.currentState.change(lock, oldEntry, newEntry);
    }

    @Override
    public void changeByID(Object lock, String id, E newEntry) throws IllegalAccessException, IllegalStateException {
        this.currentState.changeByID(lock, id, newEntry);
    }

    @Override
    public void changeByName(Object lock, String name, E newEntry) throws IllegalAccessException, IllegalStateException {
        this.currentState.changeByName(lock, name, newEntry);
    }

    @Override
    public void clear(Object lock) throws IllegalAccessException, IllegalStateException {
        this.currentState.clear(lock);
    }

    @Override
    public void close(Object lock) throws IllegalAccessException, IllegalStateException {
        this.currentState.close(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(Object lock) throws IllegalAccessException, IllegalStateException {
        ObjectRegistry<E> old = null;
        ObjectRegistryImpl objectRegistryImpl = this;
        synchronized (objectRegistryImpl) {
            if (!this.currentState.isDestroyed()) {
                this.holder.getLockedState().checkAccess(lock);
                old = this.currentState;
                this.currentState = ObjectRegistry.Util.createDestroyed(this.getRegistryEntryClass());
            } else {
                old = this.currentState;
            }
            old.destroy(lock);
        }
    }

    @Override
    public List<E> get(EntryFilter<E> filter) throws IllegalStateException {
        return this.currentState.get(filter);
    }

    @Override
    public E get(int index) throws IllegalStateException, IllegalArgumentException {
        return this.currentState.get(index);
    }

    @Override
    public E getByID(String id) throws IllegalStateException {
        return this.currentState.getByID(id);
    }

    @Override
    public E getByName(String name) throws IllegalStateException {
        return this.currentState.getByName(name);
    }

    @Override
    public EntryHandler<E> getEntryHandler() throws IllegalStateException {
        return this.currentState.getEntryHandler();
    }

    @Override
    public List<E> getEntryList() throws IllegalStateException {
        return this.currentState.getEntryList();
    }

    @Override
    public String getID(E entry) throws IllegalStateException {
        return this.currentState.getID(entry);
    }

    @Override
    public List<String> getIDs() throws IllegalStateException {
        return this.currentState.getIDs();
    }

    @Override
    public RegistryContent.Info getInfo() {
        return this.currentState.getInfo();
    }

    @Override
    public RegistryMode getMode() throws IllegalStateException {
        return this.currentState.getMode();
    }

    @Override
    public String getName(E entry) throws IllegalStateException {
        return this.currentState.getName(entry);
    }

    @Override
    public List<String> getNameList() throws IllegalStateException {
        return this.currentState.getNameList();
    }

    @Override
    public URL getPersistenceURL() throws IllegalStateException {
        return this.currentState.getPersistenceURL();
    }

    @Override
    public Class<E> getRegistryEntryClass() throws IllegalStateException {
        return this.currentState.getRegistryEntryClass();
    }

    @Override
    public EntryWrapper<E> getWrapper(E entry) throws IllegalStateException {
        return this.currentState.getWrapper(entry);
    }

    @Override
    public boolean hasContentChanged() {
        return this.currentState.hasContentChanged();
    }

    @Override
    public boolean isDestroyed() {
        return this.currentState.isDestroyed();
    }

    @Override
    public boolean isEmpty() {
        return this.currentState.isEmpty();
    }

    @Override
    public boolean isListener(ObjectRegistryListener<E> listener) {
        return this.currentState.isListener(listener);
    }

    @Override
    public boolean isLocked() {
        return this.currentState.isLocked();
    }

    @Override
    public boolean isOpened() {
        return this.currentState.isOpened();
    }

    @Override
    public void load(Object lock) throws IllegalAccessException, IllegalStateException {
        this.currentState.load(lock);
    }

    @Override
    public void open(Object lock) throws IllegalAccessException, IllegalStateException {
        this.currentState.open(lock);
    }

    @Override
    public void remove(Object lock, E entry) throws IllegalAccessException, IllegalStateException {
        this.currentState.remove(lock, entry);
    }

    @Override
    public void removeAll(Object lock, List<E> entryList) throws IllegalAccessException, IllegalStateException {
        this.currentState.removeAll(lock, entryList);
    }

    @Override
    public void removeListener(Object lock, ObjectRegistryListener<E> listener) throws IllegalAccessException, IllegalStateException {
        this.currentState.removeListener(lock, listener);
    }

    @Override
    public void set(Object lock, int index, E newEntry) throws IllegalAccessException, IllegalStateException, IllegalArgumentException {
        this.currentState.set(lock, index, newEntry);
    }

    @Override
    public int size() {
        return this.currentState.size();
    }

    @Override
    public void store(Object lock) throws IllegalAccessException, IllegalStateException {
        this.currentState.store(lock);
    }

    @Override
    public boolean contains(E entry) {
        return this.currentState.contains(entry);
    }

    @Override
    public boolean containsID(String id) {
        return this.currentState.containsID(id);
    }

    @Override
    public boolean containsName(String name) {
        return this.currentState.containsName(name);
    }
}

