/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.EnumUtil;
import de.bos_bremen.common.StringUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.ObjectFactory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.net.URL;

public class BasicRegistryInfo<T>
implements RegistryInfo<T> {
    private RegistryMode registryMode = null;
    private URL persistenceURL = null;
    private EntryHandler<T> handler = null;
    private Class<T> entryClass = null;
    private RegistryContent.Info info = null;

    public BasicRegistryInfo(Object lock, RegistryContent.Info info, Class<T> entryClass, EntryHandler<T> handler, URL persistenceURL) throws IllegalAccessException, IllegalArgumentException {
        AssertUtil.notNull(info, "info");
        AssertUtil.notNull(handler, "handler");
        AssertUtil.notNull(entryClass, "entry Class");
        this.info = info;
        this.registryMode = EnumUtil.getEnumByName(RegistryMode.class, info.getMode());
        this.persistenceURL = persistenceURL;
        this.handler = handler;
        this.entryClass = entryClass;
        handler.init(lock, this.registryMode, this);
    }

    @Override
    public EntryHandler<T> getEntryHandler() throws IllegalStateException {
        return this.handler;
    }

    @Override
    public RegistryContent.Info getInfo() {
        return this.info;
    }

    @Override
    public RegistryMode getMode() throws IllegalStateException {
        return this.registryMode;
    }

    @Override
    public URL getPersistenceURL() throws IllegalStateException {
        return this.persistenceURL;
    }

    @Override
    public Class<T> getRegistryEntryClass() throws IllegalStateException {
        return this.entryClass;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    public static RegistryContent.Info createInfo(String name, String hashAlgorithmName, String mode, Class<?> entryHandler, String prefix, String suffix) {
        AssertUtil.notNullOrEmpty(name, "name of registry");
        AssertUtil.notNullOrEmpty(hashAlgorithmName, "name of hash algorithm");
        AssertUtil.notNull(entryHandler, "entry handler Class");
        AssertUtil.notNullOrEmpty(mode, "registry mode");
        AssertUtil.notNull((Object)EnumUtil.getEnumByName(RegistryMode.class, mode), "mode must be valid mode of RegistryMode");
        ObjectFactory objectFactory = new ObjectFactory();
        RegistryContent.Info info = objectFactory.createRegistryContentInfo();
        info.setName(name);
        info.setHashAlgorithm(hashAlgorithmName);
        info.setMode(mode);
        info.setEntryHandlerClassName(entryHandler.getName());
        if (!StringUtil.isNullOrEmpty(prefix) || !StringUtil.isNullOrEmpty(suffix)) {
            RegistryContent.Info.ExternalFileSettings externalFileSettings = objectFactory.createRegistryContentInfoExternalFileSettings();
            if (!StringUtil.isNullOrEmpty(prefix)) {
                externalFileSettings.setPrefix(prefix);
            }
            if (!StringUtil.isNullOrEmpty(suffix)) {
                externalFileSettings.setSuffix(suffix);
            }
            info.setExternalFileSettings(externalFileSettings);
        }
        return info;
    }
}

