/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.io.FileUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.impl.PersistenceUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public abstract class AbstractEntryWrapper<E>
implements EntryWrapper<E> {
    protected E entryObject = null;
    protected RegistryContent.Entries.Entry entry = null;
    protected byte[] bytes = null;
    protected Properties properties = null;
    protected URL persistenceURL = null;
    protected RegistryInfo<E> info = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized byte[] getBytes() throws RuntimeException {
        byte[] encoded = null;
        try {
            if (this.info.getMode().getCacheMode().isOnTheFly()) {
                byte[] byArray = encoded = this.getEncoded();
                return byArray;
            }
            if (ArrayUtil.isNull(this.bytes)) {
                if (this.info.getMode().getPersistenceMode().isInternal() && !ArrayUtil.isNull(this.entry.getEncoded())) {
                    this.bytes = this.entry.getEncoded();
                } else if (this.info.getMode().getPersistenceMode().isExternal() && this.persistenceURL != null) {
                    File file = FileUtil.to(this.persistenceURL);
                    try {
                        this.bytes = FileUtil.readBytesOfFile(file);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException("not possible to find external persistence file at " + file.getAbsolutePath(), e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("not possible to read from external persistence file at " + file.getAbsolutePath() + ": " + e.getMessage(), e);
                    }
                } else {
                    this.bytes = this.getEncoded();
                    encoded = this.bytes;
                }
            }
            byte[] byArray = this.bytes;
            return byArray;
        }
        finally {
            if (ArrayUtil.isNullOrEmpty(this.entry.getHash())) {
                this.entry.setHash(PersistenceUtil.hash(encoded, this.getHashAlgorithm()));
            }
        }
    }

    public abstract byte[] getEncoded();

    public abstract E newEntryObject(byte[] var1);

    @Override
    public E getEntry() throws RuntimeException {
        if (this.entryObject == null) {
            this.entryObject = this.newEntryObject(this.getBytes());
        }
        return this.entryObject;
    }

    @Override
    public final byte[] getHash() {
        if (ArrayUtil.isNullOrEmpty(this.entry.getHash())) {
            this.getBytes();
        }
        return this.entry.getHash();
    }

    @Override
    public final String getHashAlgorithm() {
        return this.info.getInfo().getHashAlgorithm();
    }

    @Override
    public final String getID() {
        return this.entry.getId();
    }

    @Override
    public final String getName() {
        return this.entry.getName();
    }

    @Override
    public final synchronized Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    public abstract Properties createProperties();

    @Override
    public final RegistryMode getRegistryMode() {
        return this.info.getMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void init(Object lock, EntryHandler<E> entryHandler, RegistryInfo<E> registryInfo, E entryObject, RegistryContent.Entries.Entry entry, byte[] entryBytes, URL persistenceURL) throws IllegalAccessException, IllegalArgumentException {
        this.entryObject = entryObject;
        this.entry = entry;
        this.persistenceURL = persistenceURL;
        this.bytes = entryBytes;
        this.info = registryInfo;
        if (this.entryObject == null) {
            this.properties = PersistenceUtil.toProperties(entry.getProperties());
            if (entry.getProperties() != null) {
                this.properties = PersistenceUtil.toProperties(entry.getProperties());
            }
            if (!this.info.getMode().getPersistenceMode().isPersistent()) return;
            if (this.info.getMode().getPersistenceMode().isInternal()) {
                this.entryObject = this.newEntryObject(entry.getEncoded());
                return;
            } else {
                URL url = this.info.getPersistenceURL();
                String urlString = url.toString();
                try {
                    URL entryURL;
                    String registryPrefix = new File(this.info.getPersistenceURL().getFile()).getName();
                    int idx = registryPrefix.indexOf(".");
                    if (idx >= 0) {
                        registryPrefix = registryPrefix.substring(0, idx);
                    }
                    RegistryContent.Info.ExternalFileSettings externalFileSettings = this.info.getInfo().getExternalFileSettings();
                    String prefix = "";
                    Object suffix = "";
                    if (externalFileSettings != null) {
                        prefix = externalFileSettings.getPrefix();
                        suffix = "." + externalFileSettings.getSuffix();
                    }
                    if (!FileUtil.to(entryURL = new URL(urlString.substring(0, urlString.lastIndexOf("/")) + "/" + prefix + registryPrefix + "_entry_" + entry.getId() + (String)suffix)).exists()) return;
                    byte[] buffer = new byte[4096];
                    InputStream is = entryURL.openStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int r = 0;
                    while ((r = is.read(buffer)) > 0) {
                        baos.write(buffer, 0, r);
                    }
                    is.close();
                    baos.flush();
                    baos.close();
                    this.entryObject = this.newEntryObject(baos.toByteArray());
                    return;
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        } else {
            this.properties = this.createProperties();
            if (CollectionUtil.isNullOrEmpty(this.properties)) return;
            this.entry.setProperties(PersistenceUtil.toProperties(this.properties));
        }
    }
}

