/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ClassUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryHandler;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.modes.RegistryMode;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryInfo;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.ObjectFactory;
import de.bos_bremen.gov2.jca_provider.ocf.registry.xml.RegistryContent;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractEntryHandler<E>
implements EntryHandler<E> {
    private List<String> idList = null;
    private List<String> nameList = null;
    private Object lock = null;
    private RegistryMode registryMode = null;
    private RegistryInfo<E> info = null;
    private Class<? extends EntryWrapper<E>> entryWrapperClass = null;
    private boolean initialized = false;

    protected final EntryWrapper<E> newWrapper(Object lock) throws IllegalAccessException, IllegalStateException {
        EntryWrapper<E> result = null;
        if (ObjectUtil.notNull(lock)) {
            result = ClassUtil.newInstanceWithoutException(this.entryWrapperClass, new Class[]{Object.class}, new Object[]{lock});
        }
        if (ObjectUtil.isNull(result)) {
            result = ClassUtil.newInstanceWithoutException(this.entryWrapperClass, new Class[0], new Object[0]);
        }
        return result;
    }

    protected final EntryWrapper<E> newInitializedWrapper(Object lock, E entryObject, RegistryContent.Entries.Entry entry, byte[] entryBytes, URL persistenceURL) throws IllegalAccessException, IllegalStateException {
        EntryWrapper<E> result = null;
        try {
            result = this.newWrapper(lock);
            result.init(lock, this, this.info, entryObject, entry, entryBytes, persistenceURL);
        }
        catch (IllegalArgumentException e) {
            IllegalAccessException iae = new IllegalAccessException("initializing instance failed: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        return result;
    }

    public AbstractEntryHandler(Object lock, Class<? extends EntryWrapper<E>> entryWrapperClass) {
        this.lock = lock;
        this.entryWrapperClass = entryWrapperClass;
        this.idList = Collections.synchronizedList(new ArrayList());
        this.nameList = Collections.synchronizedList(new ArrayList());
    }

    public AbstractEntryHandler(Class<? extends EntryWrapper<E>> entryWrapperClass) {
        this(null, entryWrapperClass);
    }

    @Override
    public final synchronized void init(Object lock, RegistryMode registryMode, RegistryInfo<E> info) throws IllegalStateException, IllegalAccessException, IllegalArgumentException {
        if (this.initialized) {
            throw new IllegalStateException("handler already initialized");
        }
        AssertUtil.notNull((Object)registryMode, "registry mode");
        AssertUtil.notNull(info, "info");
        if (!ObjectUtil.isEqualsByReference(this.lock, lock)) {
            throw new IllegalAccessException("wrong lock used for initialization of handler");
        }
        this.registryMode = registryMode;
        this.info = info;
        this.initialized = true;
    }

    @Override
    public final EntryWrapper<E> toWrapper(E entry) {
        if (!this.initialized) {
            throw new IllegalStateException("handler not initialized");
        }
        RegistryContent.Entries.Entry xmlEntry = this.newEntry();
        return this.toWrapperInt(this.lock, this, this.info, this.registryMode, entry, xmlEntry, null, null, false);
    }

    protected RegistryContent.Entries.Entry newEntry() {
        ObjectFactory objectFactory = new ObjectFactory();
        RegistryContent.Entries.Entry entry = objectFactory.createRegistryContentEntriesEntry();
        entry.setId(this.nextID());
        entry.setName(this.nextName());
        if (this.registryMode.getPersistenceMode().isExternal()) {
            // empty if block
        }
        return entry;
    }

    @Override
    public final EntryWrapper<E> toWrapper(RegistryContent.Entries.Entry entry, byte[] entryBytes, URL persistenceURL) {
        if (!this.initialized) {
            throw new IllegalStateException("handler not initialized");
        }
        EntryWrapper<Object> result = this.toWrapperInt(this.lock, this, this.info, this.registryMode, null, entry, entryBytes, persistenceURL, true);
        this.idList.add(entry.getId());
        this.nameList.add(entry.getName());
        return result;
    }

    public abstract EntryWrapper<E> toWrapperInt(Object var1, EntryHandler<E> var2, RegistryInfo<E> var3, RegistryMode var4, E var5, RegistryContent.Entries.Entry var6, byte[] var7, URL var8, boolean var9);

    private String nextID() {
        String id = null;
        SecureRandom sr = new SecureRandom();
        while (id == null || this.idList.contains(id)) {
            id = "id" + sr.nextLong();
        }
        return id;
    }

    private String nextName() {
        String name = null;
        SecureRandom sr = new SecureRandom();
        while (name == null || this.nameList.contains(name)) {
            name = "name" + sr.nextLong();
        }
        return name;
    }
}

