/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.registry.event.impl;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.ocf.registry.entry.EntryWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryEvent;
import de.bos_bremen.gov2.jca_provider.ocf.registry.event.ObjectRegistryEventType;
import de.bos_bremen.gov2.jca_provider.ocf.registry.parts.RegistryChange;

public final class ObjectRegistryEventImpl<E>
implements ObjectRegistryEvent<E> {
    private ObjectRegistryEventType type = null;
    private RegistryChange<E> registry = null;
    private EntryWrapper<E> addedWrapper = null;
    private EntryWrapper<E> removedWrapper = null;

    @Override
    public EntryWrapper<E> getAddedWrapper() {
        return this.addedWrapper;
    }

    @Override
    public E getAddedEntry() {
        return this.addedWrapper != null ? (E)this.addedWrapper.getEntry() : null;
    }

    @Override
    public RegistryChange<E> getRegistry() {
        return this.registry;
    }

    @Override
    public EntryWrapper<E> getRemovedWrapper() {
        return this.removedWrapper;
    }

    @Override
    public E getRemovedEntry() {
        return this.removedWrapper != null ? (E)this.removedWrapper.getEntry() : null;
    }

    @Override
    public ObjectRegistryEventType getType() {
        return this.type;
    }

    public ObjectRegistryEventImpl(RegistryChange<E> registry) {
        this(ObjectRegistryEventType.DESTROYED, registry, null, null);
    }

    public ObjectRegistryEventImpl(ObjectRegistryEventType type, RegistryChange<E> registry) {
        this(type, registry, null, null);
    }

    private ObjectRegistryEventImpl(ObjectRegistryEventType type, RegistryChange<E> registry, EntryWrapper<E> addedWrapper, EntryWrapper<E> removedWrapper) throws IllegalArgumentException {
        AssertUtil.notNull((Object)type, "type");
        AssertUtil.notNull(registry, "registry");
        this.type = type;
        this.registry = registry;
        if (type.isAddedRequired()) {
            AssertUtil.notNull(addedWrapper, "added entry for " + this.type);
            this.addedWrapper = addedWrapper;
        } else {
            AssertUtil.isNull(addedWrapper, "added entry in case of " + type);
        }
        if (type.isRemovedRequired()) {
            AssertUtil.notNull(removedWrapper, "removed entry for " + this.type);
            this.removedWrapper = removedWrapper;
        } else {
            AssertUtil.isNull(removedWrapper, "removed entry in case of " + type);
        }
    }

    public ObjectRegistryEventImpl(RegistryChange<E> registry, EntryWrapper<E> entry, boolean added) throws IllegalArgumentException {
        this(added ? ObjectRegistryEventType.ADDED : ObjectRegistryEventType.REMOVED, registry, added ? entry : null, added ? null : entry);
    }

    public ObjectRegistryEventImpl(RegistryChange<E> registry, EntryWrapper<E> newEntry, EntryWrapper<E> oldEntry) throws IllegalArgumentException {
        this(ObjectRegistryEventType.CHANGED, registry, newEntry, oldEntry);
    }
}

