/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.map;

import de.bos_bremen.gov2.jca_provider.ocf.model.CollectionTypedHolderProxy;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedManagementStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.Util;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.AbstractKeyValueMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.ChangeStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.KeyStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.NamedMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.SearchStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.TypeMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TypedMap<T extends Typed & Disposeable>
extends AbstractKeyValueMap<Integer, int[], T>
implements KeyStrategy<Integer, int[], T>,
ChangeStrategy<Integer, T>,
SearchStrategy<Integer, T> {
    public static final Comparator<Integer> COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            int diff = o1 - o2;
            if (diff > 0) {
                return 1;
            }
            if (diff < 0) {
                return -1;
            }
            return 0;
        }
    };
    private TypedType.TypedTypeEnum typedTypeEnum = null;
    private NamedMap<Type> admittedTypeNameTypeMap = null;
    private TypeMap<Type> admittedTypeValueTypeMap = null;
    private TypedManagementStrategy<T> typedManagementStrategy = null;
    private final Object typeMapLock = new Object();
    private final Object entryLock = new Object();

    public TypedMap(TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass) {
        this(NO_LOCK, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, null);
    }

    public TypedMap(Object disposeLock, TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass) {
        this(disposeLock, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, null);
    }

    public TypedMap(TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass, T[] entries) {
        this(NO_LOCK, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, (Typed[])entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedMap(Object disposeLock, TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass, T[] entries) {
        super(disposeLock, Integer.class, Integer[].class, typeValueClass, typeValueArrayClass, null, COMPARATOR);
        if (disposeLock == null) {
            throw new IllegalArgumentException("null as lock at initialization time not admitted");
        }
        if (typeTypeEnum == null) {
            throw new IllegalArgumentException("null as TypedTypeEnum not admitted");
        }
        if (admittedTypesList == null || admittedTypesList.isEmpty()) {
            throw new IllegalArgumentException("null or empty list of admitted types not admitted");
        }
        if (!admittedTypesList.contains(typeTypeEnum.getUnknownType())) {
            throw new IllegalArgumentException("list of admitted types does not contain expected unknown type according to TypedTypeEnum");
        }
        this.typedTypeEnum = typeTypeEnum;
        Collection<Type> collection = admittedTypesList;
        synchronized (collection) {
            this.typedManagementStrategy = this.typedTypeEnum.createTypedManagementStrategy(admittedTypesList);
            this.admittedTypeNameTypeMap = new NamedMap<Type>(this.typeMapLock, Type.class, Type[].class);
            this.admittedTypeValueTypeMap = new TypeMap<Type>(this.typeMapLock, Type.class, Type[].class);
            for (Type tmp : admittedTypesList) {
                if (tmp.isLock(NO_LOCK)) {
                    tmp.changeLock(NO_LOCK, this.entryLock);
                }
                this.admittedTypeNameTypeMap.put(tmp);
                this.admittedTypeValueTypeMap.put(tmp);
                CollectionTypedHolderProxy<T> proxy = Util.getCollectionTypedHolderProxy(typeValueClass, this.entryLock);
                this.keyValueMap.put(tmp.getType(), proxy.getProxy());
            }
        }
        this.typedManagementStrategy.changeLock(NO_LOCK, this.typeMapLock);
        for (int i = 0; entries != null && i < entries.length; ++i) {
            if (entries[i] == null) continue;
            super.put(entries[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object object) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            if (super.getTypeValueClass().isInstance(object)) {
                this.remove((T)((Typed)super.getTypeValueClass().cast(object)));
            } else {
                Integer key = this.getKey(object);
                Collection collection = this.getCollectionByKey(key);
                for (Typed tmp : collection) {
                    this.remove((T)tmp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTypeName(String typeName) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return false;
            }
            if (typeName == null) {
                return false;
            }
            return this.admittedTypeNameTypeMap.containsKey(typeName);
        }
    }

    public boolean containsType(Type type) {
        return this.containsKey((Integer)type.getType());
    }

    @Override
    public boolean containsKey(int key) {
        return this.containsKey((Integer)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Integer key) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return false;
            }
            if (key == null) {
                return false;
            }
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(T value) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return false;
            }
            return this.getCollectionTypedHolderProxy(this.typedTypeEnum.getUnknownType()).getCollection().contains(value);
        }
    }

    private CollectionTypedHolderProxy<T> getCollectionTypedHolderProxy(Type type) {
        return this.getCollectionTypedHolderProxy(type.getType());
    }

    private CollectionTypedHolderProxy<T> getCollectionTypedHolderProxy(int typeValue) {
        return this.getCollectionTypedHolderProxy((Integer)typeValue);
    }

    private CollectionTypedHolderProxy<T> getCollectionTypedHolderProxy(Integer typeValue) {
        return Util.castProxy((Typed)super.getByKey(typeValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return 0;
            }
            return this.getCollectionTypedHolderProxy(this.typedTypeEnum.getUnknownType()).getCollection().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getByKey(Integer key) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            Collection collection = this.getCollectionByKey(key);
            Typed result = null;
            if (collection != null && !collection.isEmpty() && collection.size() > 0) {
                result = (Typed)collection.iterator().next();
            }
            return (T)result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return true;
            }
            return this.getCollectionTypedHolderProxy(this.typedTypeEnum.getUnknownType()).getCollection().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByType(Type type) {
        if (type == null) {
            return;
        }
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            Integer key = this.getKey((Object)type);
            Collection collection = this.getCollectionByKey(key);
            for (Typed tmp : collection) {
                this.remove((T)tmp);
                if (!((Disposeable)((Object)tmp)).isLock(this.entryLock)) continue;
                ((Disposeable)((Object)tmp)).changeLock(this.entryLock, NO_LOCK);
            }
        }
    }

    public void dump() {
        Thread.dumpStack();
        Iterator itKey = super.getKeyValueMap().keySet().iterator();
        Iterator itValue = super.getKeyValueMap().values().iterator();
        while (itKey.hasNext()) {
            Integer elemKey = (Integer)itKey.next();
            Typed elemValue = (Typed)itValue.next();
            System.out.println(elemKey + ": " + Util.castProxy(elemValue).getCollection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByTypeName(String typeName) {
        if (typeName == null) {
            return;
        }
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            int key = this.getTypeValueByTypeName(typeName);
            this.removeByKey(key);
        }
    }

    @Override
    public void removeByKey(int key) {
        this.removeByKey((Integer)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByKey(Integer key) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            if (key == null) {
                return;
            }
            Collection collection = this.getCollectionByKey(key);
            for (Typed tmp : collection) {
                this.remove((T)tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            for (Typed tmp : super.getKeyValueMap().values()) {
                CollectionTypedHolderProxy<Typed> p = Util.castProxy(tmp);
                if (p == null) continue;
                Collection<Typed> collection = p.getCollection();
                for (Typed tmpEntry : collection) {
                    if (!((Disposeable)((Object)tmpEntry)).isLock(this.entryLock)) continue;
                    ((Disposeable)((Object)tmpEntry)).changeLock(this.entryLock, NO_LOCK);
                }
                collection.clear();
            }
        }
    }

    @Override
    public boolean isKeyToValueOneToNRelation() {
        return true;
    }

    @Override
    public boolean isKeyToValueOneToOneRelation() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(T entry) {
        if (entry == null) {
            return;
        }
        T t = entry;
        synchronized (t) {
            super.remove(entry);
            if (((Disposeable)entry).isLock(this.entryLock)) {
                ((Disposeable)entry).changeLock(this.entryLock, NO_LOCK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T entry) {
        if (entry == null) {
            return;
        }
        T t = entry;
        synchronized (t) {
            boolean success = false;
            try {
                if (entry != null && ((Disposeable)entry).isLock(NO_LOCK)) {
                    ((Disposeable)entry).changeLock(NO_LOCK, this.entryLock);
                }
                super.put(entry);
                success = true;
            }
            finally {
                if (!success && ((Disposeable)entry).isLock(this.entryLock)) {
                    ((Disposeable)entry).changeLock(this.entryLock, NO_LOCK);
                }
            }
        }
    }

    public int[] convert(Integer[] keyArray) {
        int[] result = new int[keyArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = keyArray[i];
        }
        return result;
    }

    @Override
    public Integer getKey(Object object) {
        Integer result = (Integer)super.getKey(object);
        if (result == null) {
            if (Integer.class.isInstance(object)) {
                result = (Integer)object;
            } else if (Type.class.isInstance(object)) {
                result = ((Type)object).getType();
            } else if (Typed.class.isInstance(object)) {
                result = ((Typed)object).getType().getType();
            } else if (String.class.isInstance(object)) {
                try {
                    result = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public Integer getKey(T entry) {
        if (entry == null) {
            return null;
        }
        return entry.getType().getType();
    }

    @Override
    protected ChangeStrategy<Integer, T> getChangeStrategy() {
        return this;
    }

    @Override
    protected KeyStrategy<Integer, int[], T> getKeyStrategy() {
        return this;
    }

    @Override
    protected SearchStrategy<Integer, T> getSearchStrategy() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Map<Integer, T> valueMap, Integer key) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.typedManagementStrategy.get(valueMap, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> getCollection(Map<Integer, T> valueMap, Integer key) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.typedManagementStrategy.getCollection(valueMap, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Map<Integer, T> valueMap, Integer key, T value) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            this.typedManagementStrategy.put(valueMap, key, value, this.admittedTypeNameTypeMap, this.admittedTypeValueTypeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Map<Integer, T> valueMap, Integer key, T value) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return;
            }
            this.typedManagementStrategy.remove(valueMap, key, value, this.admittedTypeNameTypeMap, this.admittedTypeValueTypeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> typeNameSet() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.admittedTypeNameTypeMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] typeNameArray() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return (String[])this.admittedTypeNameTypeMap.keyArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] typeNameAlternativeArray() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return (String[])this.admittedTypeNameTypeMap.keyAlternativeArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> typeValueSet() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.admittedTypeValueTypeMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] typeValueArray() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return (Integer[])this.admittedTypeValueTypeMap.keyArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Type> typeCollection() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.admittedTypeValueTypeMap.values();
        }
    }

    public Type[] typeArray() {
        return this.typeCollection().toArray(new Type[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] typeValueAlternativeArray() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return (int[])this.admittedTypeValueTypeMap.keyAlternativeArray();
        }
    }

    @Override
    public T getByKey(int key) {
        return this.getByKey((Integer)key);
    }

    @Override
    public Collection<T> getCollectionByKey(int key) {
        return this.getCollectionByKey(Integer.valueOf(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByType(Type type) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.getByKey(type.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByType(Type type) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.getCollectionByKey(type.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByTypeName(String typeName) {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            if (super.isDisposed()) {
                return null;
            }
            if (typeName == null) {
                return null;
            }
            return this.typedManagementStrategy.get(this.unmodifiableKeyValueMap, this.getTypeValueByTypeName(typeName));
        }
    }

    private int getTypeValueByTypeName(String typeName) {
        if (typeName.indexOf(",") < 0) {
            return ((Type)this.admittedTypeNameTypeMap.getByKey(typeName)).getType();
        }
        String[] typeNames = typeName.split(",");
        int result = 0;
        for (int i = 0; i < typeNames.length; ++i) {
            result += ((Type)this.admittedTypeNameTypeMap.getByKey(typeNames[i])).getType();
        }
        return result;
    }

    public Collection<T> getCollectionByTypeName(String typeName) {
        if (super.isDisposed()) {
            return null;
        }
        return this.typedManagementStrategy.getCollection(this.unmodifiableKeyValueMap, this.getTypeValueByTypeName(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        TypedMap typedMap = this;
        synchronized (typedMap) {
            for (Integer tmp : this.admittedTypeValueTypeMap.keySet()) {
                CollectionTypedHolderProxy<T> collectionHolder;
                CollectionTypedHolderProxy<T> collectionTypedHolderProxy = collectionHolder = this.getCollectionTypedHolderProxy(tmp);
                synchronized (collectionTypedHolderProxy) {
                    if (0 == tmp) {
                        for (Typed entry : collectionHolder.getCollection()) {
                            super.unlock(entry);
                            if (((Disposeable)((Object)entry)).isLock(NO_LOCK)) {
                                ((Disposeable)((Object)entry)).dispose(NO_LOCK);
                                continue;
                            }
                            if (!((Disposeable)((Object)entry)).isLock(this.entryLock)) continue;
                            ((Disposeable)((Object)entry)).dispose(this.entryLock);
                        }
                    }
                    if (collectionHolder.isLock(NO_LOCK)) {
                        collectionHolder.dispose(NO_LOCK);
                    } else if (collectionHolder.isLock(this.entryLock)) {
                        collectionHolder.dispose(this.entryLock);
                    }
                }
            }
            this.typedTypeEnum = null;
            this.typedManagementStrategy.dispose(this.typeMapLock);
            this.admittedTypeNameTypeMap.dispose(this.typeMapLock);
            this.admittedTypeValueTypeMap.dispose(this.typeMapLock);
            this.typedManagementStrategy = null;
            this.admittedTypeNameTypeMap = null;
            this.admittedTypeValueTypeMap = null;
            return super.disposeInt();
        }
    }

    public TypedType.TypedTypeEnum getTypedType() {
        return this.typedTypeEnum;
    }

    @Override
    public Collection<T> values() {
        return super.getCollectionByKey(this.typedTypeEnum.getUnknownType().getType());
    }
}

