/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.map;

import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeRule;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TypeImpl
extends AbstractDisposeableObject
implements Type {
    private TypedType.TypedTypeEnum kind = null;
    private String name = null;
    private int type = 0;
    private List<List<Class<?>>> typeInterfaceList = Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE;
    private Set<TypeRule> typeRuleSet = null;
    private int hashCode = 0;

    public TypeImpl(String name, int type) {
        this(NO_LOCK, TypedType.TypedTypeEnum.NATURAL, name, type);
    }

    public TypeImpl(TypedType.TypedTypeEnum kind, String name, int type) {
        this(NO_LOCK, kind, name, type);
    }

    public TypeImpl(Object lock, TypedType.TypedTypeEnum kind, String name, int type) {
        this(lock, kind, name, type, Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE);
    }

    public TypeImpl(String name, int type, Class<?>[] typeInterfaces) {
        this(NO_LOCK, TypedType.TypedTypeEnum.NATURAL, name, type, typeInterfaces);
    }

    public TypeImpl(TypedType.TypedTypeEnum kind, String name, int type, Class<?>[] typeInterfaces) {
        this(NO_LOCK, kind, name, type, typeInterfaces);
    }

    public TypeImpl(Object lock, TypedType.TypedTypeEnum kind, String name, int type, Class<?>[] typeInterfaces) {
        this(lock, kind, name, type, Type.Util.createDoubleListFromArray(typeInterfaces));
    }

    public TypeImpl(String name, int type, List<List<Class<?>>> typeInterfaceList) {
        this(NO_LOCK, TypedType.TypedTypeEnum.NATURAL, name, type, typeInterfaceList);
    }

    public TypeImpl(TypedType.TypedTypeEnum kind, String name, int type, List<List<Class<?>>> typeInterfaceList) {
        this(NO_LOCK, kind, name, type, typeInterfaceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeImpl(Object lock, TypedType.TypedTypeEnum kind, String name, int type, List<List<Class<?>>> typeInterfaceList) {
        super(lock);
        this.kind = kind;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("illegal name");
        }
        this.name = name;
        if (type < 0) {
            throw new IllegalArgumentException("illegal type, lowest value is value of unknown type, defined as constant");
        }
        this.type = type;
        if (typeInterfaceList == null || typeInterfaceList.size() == 0 || typeInterfaceList.isEmpty()) {
            this.typeInterfaceList = Type.Util.NO_TYPE_INTERFACES_LIST_DOUBLE;
        } else {
            List<List<Class<?>>> list = typeInterfaceList;
            synchronized (list) {
                for (int i = 0; i < typeInterfaceList.size(); ++i) {
                    if (typeInterfaceList.get(i) != null) continue;
                    throw new IllegalArgumentException("null as list of type interfaces not admitted");
                }
                this.typeInterfaceList = new ArrayList();
                this.typeInterfaceList.addAll(typeInterfaceList);
                this.typeInterfaceList = Collections.unmodifiableList(this.typeInterfaceList);
            }
        }
        this.kind = kind;
        this.hashCode = Type.Util.hashCode(this);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public TypedType.TypedTypeEnum getTypedType() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initName(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        TypeImpl typeImpl = this;
        synchronized (typeImpl) {
            this.type = 0;
            this.name = null;
            this.kind = null;
            this.typeInterfaceList = null;
            this.typeRuleSet = null;
            return true;
        }
    }

    public String toString() {
        return "Type('" + this.name + "', " + this.type + ", " + this.kind.getName() + ")";
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (Type.class.isInstance(anotherObject)) {
            boolean result;
            Type t = (Type)anotherObject;
            boolean bl = result = this.name.equals(t.getName()) && this.type == t.getType() && this.kind == t.getTypedType() && this.getTypeInterfaceList().size() == t.getTypeInterfaceList().size();
            if (result) {
                for (int i = 0; i < this.typeInterfaceList.size() && (result &= Arrays.equals(this.typeInterfaceList.get(i).toArray(new Class[0]), t.getTypeInterfaceList().get(i).toArray(new Class[0]))); ++i) {
                }
            }
            return result;
        }
        return false;
    }

    @Override
    public List<List<Class<?>>> getTypeInterfaceList() {
        return this.typeInterfaceList;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Set<TypeRule> getTypeRuleSet() {
        return this.typeRuleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTypeRuleSet(Object lock, Set<TypeRule> typeRuleSet) {
        TypeImpl typeImpl = this;
        synchronized (typeImpl) {
            if (this.typeRuleSet != null) {
                return;
            }
            if (super.isDisposed()) {
                return;
            }
            if (super.isLock(lock)) {
                if (typeRuleSet == null || typeRuleSet == TypeConstants.NO_TYPE_RULE_SET || typeRuleSet.isEmpty()) {
                    this.typeRuleSet = TypeConstants.NO_TYPE_RULE_SET;
                } else {
                    Set<TypeRule> set = typeRuleSet;
                    synchronized (set) {
                        this.typeRuleSet = new LinkedHashSet<TypeRule>();
                        this.typeRuleSet.addAll(typeRuleSet);
                        this.typeRuleSet = Collections.unmodifiableSet(this.typeRuleSet);
                    }
                }
            }
        }
    }
}

