/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.map;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractNamedIDTypedObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.NamedConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.NamedIDTypedMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.IDMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.NamedMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.TypedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NamedIDTypedMapImpl<T extends Named & ID & Disposeable>
extends AbstractNamedIDTypedObject<T>
implements ID,
Named,
Typed,
NamedIDTypedMap<T> {
    protected static final Type[] EMPTY_ARRAY_TYPE = TypeConstants.EMPTY_ARRAY_TYPE;
    private final Collection<T> emptyCollectionTyped = Collections.unmodifiableCollection(new ArrayList());
    private final Map<Long, T> emptyMapId = Collections.unmodifiableMap(new HashMap());
    private final Map<String, T> emptyMapName = Collections.unmodifiableMap(new HashMap());
    private final Map<Integer, T> emptyMapType = Collections.unmodifiableMap(new HashMap());
    private Object mapLock = new Object();
    private IDMap<T> idMap = null;
    private NamedMap<T> namedMap = null;
    private TypedMap<T> typedMap = null;
    private Class<T> typeValueClass = null;
    private Class<T[]> typeValueArrayClass = null;

    public NamedIDTypedMapImpl(TypedType.TypedTypeEnum typeTypeEnum, String name, long id, Type type, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass) {
        this(NO_LOCK, name, id, type, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, null);
    }

    public NamedIDTypedMapImpl(Object disposeLock, String name, long id, Type type, TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass) {
        this(disposeLock, name, id, type, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, null);
    }

    public NamedIDTypedMapImpl(String name, long id, Type type, TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass, T[] entries) {
        this(NO_LOCK, name, id, type, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, (Named[])entries);
    }

    public NamedIDTypedMapImpl(Object disposeLock, String name, long id, Type type, TypedType.TypedTypeEnum typeTypeEnum, Collection<Type> admittedTypesList, Class<T> typeValueClass, Class<T[]> typeValueArrayClass, T[] entries) {
        super(disposeLock, name, id, type, null);
        this.typeValueClass = typeValueClass;
        this.typeValueArrayClass = typeValueArrayClass;
        this.idMap = new IDMap(this.mapLock, typeValueClass, typeValueArrayClass, entries);
        this.namedMap = new NamedMap(this.mapLock, typeValueClass, typeValueArrayClass, entries);
        this.typedMap = new TypedMap(this.mapLock, typeTypeEnum, admittedTypesList, typeValueClass, typeValueArrayClass, entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            boolean result = this.idMap.dispose(this.mapLock) && this.namedMap.dispose(this.mapLock) && this.typedMap.dispose(this.mapLock);
            this.idMap = null;
            this.namedMap = null;
            this.typedMap = null;
            this.mapLock = null;
            this.typeValueClass = null;
            this.typeValueArrayClass = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
        }
        namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            this.idMap.clear();
            this.namedMap.clear();
            this.typedMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return 0;
            }
        }
        namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            return this.idMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return true;
            }
        }
        namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            return this.idMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Object object) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            Named result = (Named)this.idMap.get(object);
            if (result == null) {
                result = (Named)this.namedMap.get(object);
            }
            if (result == null) {
                result = (Named)this.typedMap.get(object);
            }
            return (T)result;
        }
    }

    public Collection<T> getCollection(Object object) {
        Collection result = this.idMap.getCollection(object);
        if (result == null || result.isEmpty()) {
            result = this.namedMap.getCollection(object);
        }
        if (result == null || result.isEmpty()) {
            result = this.typedMap.getCollection(object);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByID(Long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.idMap.getCollectionByKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByID(long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.idMap.getCollectionByKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByName(String name) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.namedMap.getCollectionByKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByType(Integer type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.typedMap.getCollectionByKey(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByType(int type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.typedMap.getCollectionByKey(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByType(Type type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.typedMap.getCollectionByType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByTypeName(String typeName) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.typedMap.getCollectionByTypeName(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getByID(Long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.idMap.getByKey(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getByID(long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.idMap.getByKey(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getByName(String name) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.namedMap.getByKey(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByType(Integer type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.typedMap.getByKey(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByType(int type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.typedMap.getByKey(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByType(Type type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.typedMap.getByType(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByTypeName(String typeName) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Named)this.typedMap.getByTypeName(typeName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object object) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            this.put((T)((Named)this.typeValueClass.cast(object)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T entry) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            boolean successID = false;
            boolean successNamed = false;
            boolean success = false;
            try {
                this.idMap.put(entry);
                successID = true;
                this.namedMap.put(entry);
                successNamed = true;
                this.typedMap.put(entry);
                success = true;
            }
            finally {
                if (!success) {
                    if (successID) {
                        this.idMap.remove(entry);
                    }
                    if (successNamed) {
                        this.namedMap.remove(entry);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object object) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection<T> collection = this.getCollection(object);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(T entry) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            boolean successID = false;
            boolean successNamed = false;
            boolean success = false;
            try {
                this.idMap.remove(entry);
                successID = true;
                this.namedMap.remove(entry);
                successNamed = true;
                this.typedMap.remove(entry);
                success = true;
            }
            finally {
                if (!success) {
                    if (successID) {
                        this.idMap.put(entry);
                    }
                    if (successNamed) {
                        this.namedMap.put(entry);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByID(Long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection collection = this.idMap.getCollectionByKey(id);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByID(long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection<T> collection = this.idMap.getCollectionByKey(id);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByName(String name) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection collection = this.namedMap.getCollectionByKey(name);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByType(Integer type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection collection = this.typedMap.getCollectionByKey(type);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByType(int type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection<T> collection = this.typedMap.getCollectionByKey(type);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByType(Type type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return;
            }
            Collection<T> collection = this.typedMap.getCollectionByType(type);
            this.removeCollection(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> idSet() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return EMPTY_SET_ID;
            }
            return this.idMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long[] idArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return EMPTY_ARRAY_ID;
            }
            return (Long[])this.idMap.keyArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] idAlternativeArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return EMPTY_ALTERNATIVE_ARRAY_ID;
            }
            return (long[])this.idMap.keyAlternativeArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> nameSet() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return NamedConstants.EMPTY_SET_NAME;
            }
            return this.namedMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] nameArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return NamedConstants.EMPTY_ARRAY_NAME;
            }
            return (String[])this.namedMap.keyArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] nameAlternativeArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return NamedConstants.EMPTY_ALTERNATIVE_ARRAY_NAME;
            }
            return (String[])this.namedMap.keyAlternativeArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> typeValueSet() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return TypedConstants.EMPTY_SET_TYPE_VALUE;
            }
        }
        return this.typedMap.typeValueSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] typeValueArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return TypedConstants.EMPTY_ARRAY_TYPE_VALUE;
            }
        }
        return this.typedMap.typeValueArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] typeValueAlternativeArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return TypedConstants.EMPTY_ALTERNATIVE_ARRAY_TYPE_VALUE;
            }
        }
        return this.typedMap.typeValueAlternativeArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Type> typeCollection() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return TypedConstants.EMPTY_COLLECTION_TYPE;
            }
            return this.typedMap.typeCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type[] typeArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return EMPTY_ARRAY_TYPE;
            }
            return this.typedMap.typeArray();
        }
    }

    private void removeCollection(Collection<T> collection) {
        if (collection != null && !collection.isEmpty()) {
            for (Named entry : collection) {
                this.remove((T)entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.idMap.contains(object) || this.namedMap.contains(object) || this.typedMap.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsID(Long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.idMap.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsID(long id) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.idMap.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsName(String name) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.namedMap.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsType(Integer type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.typedMap.containsKey(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsType(int type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.typedMap.containsKey(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsType(Type type) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.typedMap.containsType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTypeName(String typeName) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.typedMap.containsTypeName(typeName);
        }
    }

    public boolean contains(T value) {
        return this.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(T value) {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return this.idMap.contains(value);
        }
    }

    public Class<T> getTypeValueClass() {
        return this.typeValueClass;
    }

    public Class<T[]> getTypeValueArrayClass() {
        return this.typeValueArrayClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, T> getIDMap() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyMapId;
            }
            return this.idMap.getKeyValueMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, T> getNamedMap() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyMapName;
            }
            return this.namedMap.getKeyValueMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, T> getTypedMap() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyMapType;
            }
            return this.typedMap.getKeyValueMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T[] valueArray() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return (Named[])ArrayUtil.getEmptyArray(this.typeValueClass, this.typeValueArrayClass);
            }
            return (Named[])this.typedMap.valueArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> values() {
        NamedIDTypedMapImpl namedIDTypedMapImpl = this;
        synchronized (namedIDTypedMapImpl) {
            if (super.isDisposed()) {
                return this.emptyCollectionTyped;
            }
            return this.typedMap.values();
        }
    }
}

