/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.map;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.ChangeStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.KeyStrategy;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.SearchStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractKeyValueMap<S, R, T extends Disposeable>
extends AbstractDisposeableObject {
    private static final Log LOG = LogFactory.getLog(AbstractKeyValueMap.class);
    public static final boolean KEY_TO_VALUE_IS_ONE_TO_ONE_RELATION = true;
    public static final boolean KEY_TO_VALUE_IS_ONE_TO_N_RELATION = false;
    public static final boolean DEFAULT_KEY_TO_VALUE_RELATION = true;
    protected Map<S, T> keyValueMap = null;
    protected Map<S, T> unmodifiableKeyValueMap = null;
    private KeyStrategy<S, R, T> keyStrategy = null;
    private ChangeStrategy<S, T> changeStrategy = null;
    private SearchStrategy<S, T> searchStrategy = null;
    private Class<S> typeKeyClass = null;
    private Class<S[]> typeKeyArrayClass = null;
    private Class<T> typeValueClass = null;
    private Class<T[]> typeValueArrayClass = null;
    private Object entryLock = new Object();

    protected AbstractKeyValueMap(Object disposeLock, Class<S> typeKeyClass, Class<S[]> typeKeyArrayClass, Class<T> typeValueClass, Class<T[]> typeValueArrayClass, T[] entries) {
        this(disposeLock, typeKeyClass, typeKeyArrayClass, typeValueClass, typeValueArrayClass, (Disposeable[])entries, null);
    }

    protected AbstractKeyValueMap(Object disposeLock, Class<S> typeKeyClass, Class<S[]> typeKeyArrayClass, Class<T> typeValueClass, Class<T[]> typeValueArrayClass, T[] entries, Comparator<S> comparator) {
        super(disposeLock);
        if (typeKeyClass == null) {
            throw new IllegalArgumentException("null as key class not admitted");
        }
        if (typeKeyArrayClass == null) {
            throw new IllegalArgumentException("null as key array class not admitted");
        }
        if (typeValueClass == null) {
            throw new IllegalArgumentException("null as value class not admitted");
        }
        if (typeValueArrayClass == null) {
            throw new IllegalArgumentException("null as value array class not admitted");
        }
        this.keyValueMap = this.createMap(comparator);
        this.unmodifiableKeyValueMap = Collections.unmodifiableMap(this.keyValueMap);
        this.typeKeyClass = typeKeyClass;
        this.typeKeyArrayClass = typeKeyArrayClass;
        this.typeValueClass = typeValueClass;
        this.typeValueArrayClass = typeValueArrayClass;
        this.keyStrategy = this.getKeyStrategy();
        this.changeStrategy = this.getChangeStrategy();
        this.searchStrategy = this.getSearchStrategy();
        for (int i = 0; entries != null && i < entries.length; ++i) {
            this.put(entries[i]);
        }
    }

    protected abstract KeyStrategy<S, R, T> getKeyStrategy();

    protected abstract ChangeStrategy<S, T> getChangeStrategy();

    protected abstract SearchStrategy<S, T> getSearchStrategy();

    protected Map<S, T> createMap(Comparator<S> comparator) {
        if (comparator == null) {
            new HashMap();
        }
        return new TreeMap(comparator);
    }

    public static <L, M, N extends Disposeable> AbstractKeyValueMap<L, M, N> castIDMap(Class<L> typeKeyClass, Class<L> typePrimitiveKeyClass, Class<L> typeValueClass, AbstractKeyValueMap<?, ?, ?> idMap) {
        return idMap;
    }

    @Override
    protected boolean disposeInt() {
        for (Disposeable tmp : this.keyValueMap.values()) {
            if (tmp.isLock(NO_LOCK)) {
                tmp.dispose(NO_LOCK);
                continue;
            }
            if (!tmp.isLock(this.entryLock)) continue;
            tmp.dispose(this.entryLock);
        }
        this.keyValueMap.clear();
        this.keyValueMap = null;
        this.unmodifiableKeyValueMap = null;
        this.typeKeyClass = null;
        this.typeKeyArrayClass = null;
        this.typeValueClass = null;
        this.typeValueArrayClass = null;
        this.keyStrategy = null;
        this.changeStrategy = null;
        this.searchStrategy = null;
        this.entryLock = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<S> keySet() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.unmodifiableKeyValueMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S[] keyArray() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.keySet().toArray(ArrayUtil.getEmptyArray(this.typeKeyClass, this.typeKeyArrayClass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R keyAlternativeArray() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.keyStrategy.convert(this.keyArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> values() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.unmodifiableKeyValueMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] valueArray() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.values().toArray((Disposeable[])ArrayUtil.getEmptyArray(this.typeValueClass, this.typeValueArrayClass));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Object object) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.typeValueClass.isInstance(object) && this.containsValue((Disposeable)this.typeValueClass.cast(object))) {
                return (T)((Disposeable)this.typeValueClass.cast(object));
            }
            return this.getByKey(this.keyStrategy.getKey(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getByKey(S key) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return (T)((Disposeable)this.unmodifiableKeyValueMap.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollectionByKey(S key) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.searchStrategy.getCollection(this.unmodifiableKeyValueMap, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getCollection(Object object) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            return this.searchStrategy.getCollection(this.unmodifiableKeyValueMap, this.keyStrategy.getKey(object));
        }
    }

    public void removeByKey(S key) {
        this.remove(this.getByKey(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return;
            }
            if (this.typeValueClass.isInstance(object)) {
                this.put((T)((Disposeable)this.typeValueClass.cast(object)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T entry) {
        if (entry == null) {
            return;
        }
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return;
            }
            T t = entry;
            synchronized (t) {
                if (this.isKeyToValueOneToOneRelation() && this.containsKey(this.keyStrategy.getKey(entry))) {
                    if (!this.getByKey(this.getKey(entry)).equals(entry)) {
                        LOG.debug((Object)("failed adding entry: " + entry));
                        throw new IllegalArgumentException("entry already exists, to put another entry with same key, old entry is to removed first");
                    }
                    return;
                }
                this.changeStrategy.put(this.keyValueMap, this.keyStrategy.getKey(entry), entry);
                this.lock(entry);
            }
        }
    }

    public void remove(Object object) {
        this.remove(this.get(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T entry) {
        if (entry == null) {
            return;
        }
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            T t = entry;
            synchronized (t) {
                if (super.isDisposed()) {
                    return;
                }
                this.changeStrategy.remove(this.keyValueMap, this.keyStrategy.getKey(entry), entry);
                this.unlock(entry);
            }
        }
    }

    protected void unlock(T value) {
        if (value.isLock(this.entryLock)) {
            value.changeLock(this.entryLock, NO_LOCK);
        }
    }

    protected void lock(T entry) {
        if (entry.isLock(NO_LOCK)) {
            entry.changeLock(NO_LOCK, this.entryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            for (Disposeable tmp : this.keyValueMap.values()) {
                this.unlock(tmp);
            }
            this.keyValueMap.clear();
        }
    }

    public Map<S, T> getKeyValueMap() {
        return this.unmodifiableKeyValueMap;
    }

    public void remove(Map<S, T> valueMap, S key, T value) {
        valueMap.remove(key);
    }

    public void put(Map<S, T> valueMap, S key, T value) {
        if (key == null || value == null) {
            return;
        }
        valueMap.put(key, value);
    }

    public T get(Map<S, T> valueMap, S key) {
        return (T)((Disposeable)valueMap.get(key));
    }

    public Collection<T> getCollection(Map<S, T> valueMap, S key) {
        ArrayList<Disposeable> result = new ArrayList<Disposeable>();
        Disposeable value = (Disposeable)valueMap.get(key);
        if (value != null) {
            result.add(value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return true;
            }
            return this.unmodifiableKeyValueMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return 0;
            }
            return this.unmodifiableKeyValueMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            Collection<T> collection = this.getCollection(object);
            return collection != null && !collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(S key) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return false;
            }
            return this.unmodifiableKeyValueMap.containsKey(key);
        }
    }

    public boolean contains(T value) {
        return this.containsValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(T value) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return false;
            }
            return this.unmodifiableKeyValueMap.containsValue(value);
        }
    }

    public boolean isKeyToValueOneToNRelation() {
        return false;
    }

    public boolean isKeyToValueOneToOneRelation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getKey(Object object) {
        AbstractKeyValueMap abstractKeyValueMap = this;
        synchronized (abstractKeyValueMap) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.typeKeyClass.isInstance(object)) {
                return this.typeKeyClass.cast(object);
            }
            return null;
        }
    }

    public Class<S> getTypeKeyClass() {
        return this.typeKeyClass;
    }

    public Class<S[]> getTypeKeyArrayClass() {
        return this.typeKeyArrayClass;
    }

    public Class<T> getTypeValueClass() {
        return this.typeValueClass;
    }

    public Class<T[]> getTypeValueArrayClass() {
        return this.typeValueArrayClass;
    }
}

