/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeRuleInfo;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import java.util.Collections;
import java.util.Set;

public class TypeRuleInfoImpl
implements TypeRuleInfo {
    private TypedType.TypedTypeEnum typedType = null;
    private Set<Type> typeSet = null;
    private int type = -1;

    public TypeRuleInfoImpl(TypedType.TypedTypeEnum typedType, Set<Type> typeSet, int type) throws IllegalArgumentException {
        if (typedType == null) {
            throw new IllegalArgumentException("TypedType expected");
        }
        if (typeSet == null) {
            throw new IllegalArgumentException("set of types expected");
        }
        if (typeSet.isEmpty()) {
            throw new IllegalArgumentException("set of types not expected to be empty");
        }
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("unknown type, please constant declared at TypeRule");
        }
        this.typedType = typedType;
        this.typeSet = Collections.unmodifiableSet(typeSet);
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public Set<Type> getTypeSet() {
        return this.typeSet;
    }

    @Override
    public TypedType.TypedTypeEnum getTypedType() {
        return this.typedType;
    }

    public String toString() {
        String typeRule = "";
        switch (this.type) {
            case 0: {
                typeRule = "RULE_TYPE_AND";
                break;
            }
            case 1: {
                typeRule = "RULE_TYPE_OR_ONE_OR_MORE_OF_TYPE_SET";
                break;
            }
            case 2: {
                typeRule = "RULE_TYPE_OR_ONLY_ONE_OF_TYPE_SET";
            }
        }
        return "TypeRuleInfo(" + this.typedType + ", " + this.typeSet + ", " + typeRule + ")";
    }
}

