/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.NamedConstants;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeRule;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypeRuleInfo;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import java.util.Set;

public class TypeRuleImpl
extends AbstractDisposeableObject
implements TypeRule {
    private TypeRuleInfo indicatorInfo = null;
    private TypeRuleInfo dependencyInfo = null;
    private int errorType = -1;
    private long id = -1L;
    private String name = NamedConstants.NO_NAME;
    private String description = "";

    public TypeRuleImpl(TypeRuleInfo indicatorInfo, TypeRuleInfo dependencyInfo, int errorType) throws IllegalArgumentException {
        this(Disposeable.NO_LOCK, NamedConstants.NO_NAME, -1L, indicatorInfo, dependencyInfo, errorType);
    }

    public TypeRuleImpl(Object lock, String name, long id, TypeRuleInfo indicatorInfo, TypeRuleInfo dependencyInfo, int errorType) throws IllegalArgumentException {
        super(lock);
        if (indicatorInfo == null) {
            throw new IllegalArgumentException("information about indicator expected");
        }
        if (dependencyInfo == null) {
            throw new IllegalArgumentException("information about dependencies expected");
        }
        if (indicatorInfo.getTypedType() != dependencyInfo.getTypedType()) {
            throw new IllegalArgumentException("information about indicator and dependencies does not share same TypedTypeEnum as expected");
        }
        if (errorType != 1 && errorType != 2) {
            throw new IllegalArgumentException("unknown error type, use one of the defined constants declared at TypeRule");
        }
        this.indicatorInfo = indicatorInfo;
        this.dependencyInfo = dependencyInfo;
        this.errorType = errorType;
        this.name = name;
        this.id = id;
    }

    @Override
    public Set<Type> getDependencySet() {
        return this.dependencyInfo.getTypeSet();
    }

    @Override
    public int getErrorType() {
        return this.errorType;
    }

    @Override
    public Set<Type> getIndicatorSet() {
        return this.indicatorInfo.getTypeSet();
    }

    @Override
    public int getDependencyType() {
        return this.dependencyInfo.getType();
    }

    @Override
    public TypedType.TypedTypeEnum getTypedType() {
        return this.indicatorInfo.getTypedType();
    }

    @Override
    public boolean isResponsibleFor(Typed typed) {
        if (typed == null) {
            return false;
        }
        return this.isResponsibleFor(typed.getType());
    }

    @Override
    public boolean isResponsibleFor(Type type) {
        Set<Type> typeSet = TypeRule.Util.getTypeSet(this.getTypedType(), type);
        return TypeRule.Util.isSatisfied(this.indicatorInfo, typeSet);
    }

    @Override
    public boolean isSatisfiedBy(Typed typed) throws IllegalArgumentException {
        if (typed == null) {
            return true;
        }
        return this.isSatisfiedBy(typed.getType());
    }

    @Override
    public boolean isSatisfiedBy(Type type) throws IllegalArgumentException {
        boolean result = false;
        if (!this.isResponsibleFor(type)) {
            result = true;
        } else {
            Set<Type> typeSet = TypeRule.Util.getTypeSet(this.getTypedType(), type);
            result = TypeRule.Util.isSatisfied(this.dependencyInfo, typeSet);
            if (!result) {
                String msg = "illegal type:\ntype " + type + "\ndoes not satisfy rule\n" + this.toString();
                if (this.errorType == 1) {
                    throw new IllegalArgumentException(msg);
                }
                System.out.println(msg);
            }
        }
        return result;
    }

    @Override
    public int getIndicatorType() {
        return this.indicatorInfo.getType();
    }

    @Override
    public TypeRuleInfo getDependencyInfo() {
        return this.dependencyInfo;
    }

    @Override
    public TypeRuleInfo getIndicatorInfo() {
        return this.indicatorInfo;
    }

    public String toString() {
        return "TypeRule:\n - TypedType:" + this.getTypedType() + "\n - Indicator: " + this.indicatorInfo + "\n -> \n - Dependency: " + this.dependencyInfo + "\n - ErrorType: " + (this.errorType == 1 ? "ERROR_TYPE_ERROR" : "ERROR_TYPE_WARNING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        TypeRuleImpl typeRuleImpl = this;
        synchronized (typeRuleImpl) {
            this.indicatorInfo = null;
            this.dependencyInfo = null;
            this.errorType = -1;
            this.name = NamedConstants.NO_NAME;
            this.id = -1L;
            this.description = "";
            return true;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initName(String name) {
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public void initID(long id) {
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

