/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.common.Filter;
import de.bos_bremen.common.FilterUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractNamedIDTypedObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.Typed;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.IFDTerminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.IFDTerminalFactoryImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.NamedIDMapImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.SlotCardWrapper;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.VerifiedAPDUInterface;

public class TerminalImpl
extends AbstractNamedIDTypedObject<CardTerminal>
implements Terminal,
ID,
Typed,
Disposeable {
    private NamedIDMapImpl<SlotCardWrapper> slotCardMap = null;
    private boolean hasPinPad = false;
    private boolean hasDisplay = false;
    private Object disposeMapLock = new Object();
    private IFDTerminal ifdTerminal = null;

    public TerminalImpl(Object disposeLock, CardTerminal cardTerminal, long id, Type type) {
        super(cardTerminal.getName() + "-ID-" + id, id, type, cardTerminal);
        if (cardTerminal == null) {
            throw new IllegalArgumentException("terminal expected");
        }
        this.ifdTerminal = IFDTerminalFactoryImpl.getInstance().createIFDTerminal(cardTerminal);
        this.slotCardMap = new NamedIDMapImpl<SlotCardWrapper>(this.disposeMapLock, SlotCardWrapper.class, SlotCardWrapper[].class);
    }

    @Override
    public Card getCard(int slotID) {
        return this.slotCardMap.getByID(slotID);
    }

    public void addCard(Card card) {
        this.slotCardMap.put(new SlotCardWrapper(card.getSlotID(), card));
    }

    public void removeCard(Card card) {
        this.slotCardMap.removeByID(card.getSlotID());
    }

    @Override
    public Card[] getCards() {
        SlotCardWrapper[] cardWrapper = this.slotCardMap.values().toArray(new SlotCardWrapper[0]);
        Card[] cards = new Card[cardWrapper.length];
        for (int i = 0; i < cards.length; ++i) {
            cards[i] = cardWrapper[i].getCard();
        }
        return cards;
    }

    @Override
    public Card[] getCards(Filter<Card> filter) {
        Card[] cards = this.getCards();
        return FilterUtil.filter(filter, cards).toArray(new Card[0]);
    }

    @Override
    public int getSlots() {
        return ((CardTerminal)super.getInnerObject()).getSlots();
    }

    @Override
    public boolean isCardPresent(int slotID) {
        try {
            return ((CardTerminal)super.getInnerObject()).isCardPresent(slotID);
        }
        catch (CardTerminalException e) {
            return false;
        }
    }

    @Override
    public boolean isKeyPadAvailable() {
        boolean result = VerifiedAPDUInterface.class.isInstance(super.getInnerObject());
        if (PCSCCardTerminal.class.isInstance(super.getInnerObject())) {
            result = this.hasPinPad;
        }
        return result;
    }

    @Override
    public boolean isDisplayAvailable() {
        boolean result = VerifiedAPDUInterface.class.isInstance(super.getInnerObject());
        if (PCSCCardTerminal.class.isInstance(super.getInnerObject())) {
            result = this.hasDisplay;
        }
        return result;
    }

    @Override
    public CardTerminal getCardTerminal() {
        return (CardTerminal)super.getInnerObject();
    }

    @Override
    protected boolean disposeInt() {
        boolean mapDispose = this.slotCardMap.dispose(this.disposeMapLock);
        this.slotCardMap = null;
        return mapDispose;
    }

    @Override
    public String toString(String indent) {
        return super.toString();
    }

    @Override
    public IFDTerminal getIFDTerminal() {
        return this.ifdTerminal;
    }
}

