/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.Disposeable;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.NamedIDTypedMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class NamedIDMapImpl<T extends Named & ID>
extends AbstractDisposeableObject
implements Disposeable,
NamedIDTypedMap<T> {
    private Map<Long, T> idMap = null;
    private Map<String, T> nameMap = null;
    private Map<Long, T> idImmutableMap = null;
    private Map<String, T> nameImmutableMap = null;
    private Class<T> typeClass = null;
    private Class<T[]> typeArrayClass = null;
    private Object entryLock = new Object();

    public NamedIDMapImpl(Class<T> typeClass, Class<T[]> typeArrayClass) {
        this(NO_LOCK, null, typeClass, typeArrayClass);
    }

    public NamedIDMapImpl(T[] entries, Class<T> typeClass, Class<T[]> typeArrayClass) {
        this(NO_LOCK, (Named[])entries, typeClass, typeArrayClass);
    }

    public NamedIDMapImpl(Object disposeLock, Class<T> typeClass, Class<T[]> typeArrayClass) {
        this(disposeLock, null, typeClass, typeArrayClass);
    }

    public NamedIDMapImpl(Object disposeLock, T[] entries, Class<T> typeClass, Class<T[]> typeArrayClass) {
        super(disposeLock);
        this.idMap = new LinkedHashMap<Long, T>();
        this.nameMap = new LinkedHashMap<String, T>();
        this.idImmutableMap = Collections.unmodifiableMap(this.idMap);
        this.nameImmutableMap = Collections.unmodifiableMap(this.nameMap);
        for (int i = 0; entries != null && i < entries.length; ++i) {
            this.put(entries[i]);
            if (!((Disposeable)entries[i]).isLock(NO_LOCK)) continue;
            try {
                ((Disposeable)entries[i]).changeLock(NO_LOCK, this.entryLock);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.typeClass = typeClass;
        this.typeArrayClass = typeArrayClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        NamedIDMapImpl namedIDMapImpl = this;
        synchronized (namedIDMapImpl) {
            if (this.idMap != null) {
                this.idMap.clear();
            }
            if (this.nameMap != null) {
                this.nameMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T entry) {
        if (entry == null) {
            return;
        }
        NamedIDMapImpl namedIDMapImpl = this;
        synchronized (namedIDMapImpl) {
            T t = entry;
            synchronized (t) {
                if (((Disposeable)entry).isLock(NO_LOCK)) {
                    ((Disposeable)entry).changeLock(NO_LOCK, this.entryLock);
                }
                if (!this.idMap.containsKey(((ID)entry).getID()) && !this.nameMap.containsKey(entry.getName())) {
                    this.idMap.put(((ID)entry).getID(), entry);
                    this.nameMap.put(entry.getName(), entry);
                } else {
                    if (this.idMap.get(((ID)entry).getID()) == entry && this.nameMap.get(entry.getName()) == entry) {
                        return;
                    }
                    if (this.idMap.containsKey(((ID)entry).getID())) {
                        throw new IllegalArgumentException("another entry with same id already exists");
                    }
                    if (this.nameMap.containsKey(entry.getName())) {
                        throw new IllegalArgumentException("another entry with same name already exists");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(T entry) {
        if (entry == null) {
            return;
        }
        NamedIDMapImpl namedIDMapImpl = this;
        synchronized (namedIDMapImpl) {
            T t = entry;
            synchronized (t) {
                this.idMap.remove(((ID)entry).getID());
                this.nameMap.remove(entry.getName());
                if (((Disposeable)entry).isLock(this.entryLock)) {
                    ((Disposeable)entry).changeLock(this.entryLock, NO_LOCK);
                }
            }
        }
    }

    @Override
    public Map<Long, T> getIDMap() {
        return this.idImmutableMap;
    }

    @Override
    public Map<String, T> getNamedMap() {
        return this.nameImmutableMap;
    }

    @Override
    public T get(Object key) {
        if (String.class.isInstance(key)) {
            return this.getByName((String)key);
        }
        if (Long.class.isInstance(key)) {
            return this.getByID((Long)key);
        }
        return null;
    }

    @Override
    public T getByName(String name) {
        return (T)((Named)this.nameMap.get(name));
    }

    @Override
    public T getByID(long id) {
        return (T)((Named)this.idMap.get(id));
    }

    @Override
    public void removeByID(long id) {
        this.remove(this.getByID(id));
    }

    @Override
    public void removeByName(String name) {
        this.remove(this.getByName(name));
    }

    @Override
    public Set<Long> idSet() {
        return this.idMap.keySet();
    }

    @Override
    public Set<String> nameSet() {
        return this.nameMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.idMap.values();
    }

    @Override
    public Long[] idArray() {
        return this.idMap.keySet().toArray(new Long[0]);
    }

    @Override
    public long[] idAlternativeArray() {
        Long[] ids = this.idArray();
        long[] result = new long[ids.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ids[i];
        }
        return result;
    }

    @Override
    public String[] nameArray() {
        return this.nameMap.keySet().toArray(new String[0]);
    }

    @Override
    public T[] valueArray() {
        return this.idMap.values().toArray((Named[])ArrayUtil.getArray(this.typeClass, this.typeArrayClass, 0));
    }

    public String toString() {
        return this.idMap.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disposeInt() throws IllegalStateException {
        NamedIDMapImpl namedIDMapImpl = this;
        synchronized (namedIDMapImpl) {
            for (Named tmp : this.idMap.values()) {
                if (((Disposeable)((Object)tmp)).isLock(NO_LOCK)) {
                    ((Disposeable)((Object)tmp)).dispose(NO_LOCK);
                    continue;
                }
                if (!((Disposeable)((Object)tmp)).isLock(this.entryLock)) continue;
                ((Disposeable)((Object)tmp)).dispose(this.entryLock);
            }
            this.clear();
            this.nameMap = null;
            this.idMap = null;
            this.idImmutableMap = null;
            this.nameImmutableMap = null;
            return true;
        }
    }

    @Override
    public T getByID(Long id) {
        return (T)((Named)this.idMap.get(id));
    }

    @Override
    public void removeByID(Long id) {
        this.remove(this.getByID(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        NamedIDMapImpl namedIDMapImpl = this;
        synchronized (namedIDMapImpl) {
            if (super.isDisposed()) {
                return true;
            }
            if (this.idMap != null) {
                return this.idMap.isEmpty();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        NamedIDMapImpl namedIDMapImpl = this;
        synchronized (namedIDMapImpl) {
            if (super.isDisposed()) {
                return 0;
            }
            if (this.idMap != null) {
                return this.idMap.size();
            }
            return 0;
        }
    }
}

