/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongConfirmedNewPinException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSAccessor;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractCardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;

public class CardPinImpl
extends AbstractCardObject<FileEntry, DIDInfoType>
implements CardPin {
    private boolean useCardPinForAccessEnabled = false;
    private boolean changeSupported = true;
    private boolean changeEnabled = true;
    private boolean initSupported = true;
    private boolean initEnabled = true;
    private boolean unblockSupported = true;
    private boolean unblockEnabled = true;
    private boolean setSupported = true;
    private boolean setEnabled = true;
    private boolean verifySupported = true;
    private boolean verifyEnabled = true;
    private OCFCertificateInfo[] infos = null;
    private CardKey[] keys = null;
    private long[] keyIDs = null;
    private static final byte NO_PINID = -1;
    private byte pinID = (byte)-1;

    public CardPinImpl(String name, long id, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, CardPin.CardPinTypeEnum.PIN.getType(), innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardPinImpl(Object lock, String name, long id, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(lock, name, id, CardPin.CardPinTypeEnum.PIN.getType(), innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardPinImpl(String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardPinImpl(Object disposeLock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(disposeLock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry, -127, -1L);
    }

    public CardPinImpl(Object disposeLock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry, byte pinID, long keyID) {
        this(disposeLock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry, pinID, new long[]{keyID});
    }

    public CardPinImpl(Object disposeLock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry, byte pinID, long[] keyIDs) {
        super(disposeLock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
        this.pinID = pinID;
        this.keyIDs = keyIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFCertificateInfo[] getInfos() {
        CardPinImpl cardPinImpl = this;
        synchronized (cardPinImpl) {
            CardKey[] keys;
            if (super.isDisposed()) {
                return null;
            }
            if (this.infos == null && (keys = this.getKeys()) != null) {
                this.infos = new OCFCertificateInfo[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] == null) continue;
                    this.infos[i] = keys[i].getInfo();
                }
            }
            return this.infos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardKey[] getKeys() {
        CardPinImpl cardPinImpl = this;
        synchronized (cardPinImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.keys == null && this.keyIDs != null) {
                this.keys = new CardKey[this.keyIDs.length];
                for (int i = 0; i < this.keyIDs.length; ++i) {
                    this.keys[i] = super.getCard().getKeyByID(this.keyIDs[i], 1);
                }
            }
            return this.keys;
        }
    }

    @Override
    public PinEncoder getEncoder() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return null;
        }
        PinEncoder encoder = cs.getPinEncoder(this.getInfo());
        return encoder;
    }

    @Override
    public int getMaximumLength() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return -1;
        }
        return cs.getMaxPINLength(this.getInfo());
    }

    private OCFCertificateInfo getInfo() {
        OCFCertificateInfo result = null;
        if (this.infos != null) {
            for (int i = 0; i < this.infos.length; ++i) {
                if (this.infos[i] == null || this.infos[i].getX509Certificate() == null) continue;
                result = this.infos[i];
                break;
            }
        }
        return result;
    }

    @Override
    public int getMinimumLength() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return -1;
        }
        return cs.getMinPINLength(this.getInfo());
    }

    @Override
    public Byte getPadByte() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return (byte)-1;
        }
        byte b = cs.getPasswordBlockFiller(this.getInfo());
        return b != 0 ? Byte.valueOf(b) : null;
    }

    @Override
    public int getPinType() {
        return super.getTypeValue();
    }

    @Override
    public int getPaddingLength() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return 0;
        }
        return cs.getPasswordBlockLength(this.getInfo());
    }

    @Override
    public boolean isPadded() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        int pbl = cs.getPasswordBlockLength(this.getInfo());
        return pbl != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        CardPinImpl cardPinImpl = this;
        synchronized (cardPinImpl) {
            if (super.isDisposed()) {
                return false;
            }
            this.pinID = (byte)-1;
            this.infos = null;
            this.keys = null;
            this.keyIDs = null;
            return true;
        }
    }

    @Override
    public byte getPinID() {
        return this.pinID;
    }

    @Override
    public boolean reset() {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        cs.reset();
        return true;
    }

    @Override
    public boolean unblock(char[] _challenge, char[] _newPIN) {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean verify(char[] _pin) throws ResponseCodeException, WrongPinException, RetryCounterExpiredException, NotYetInitializedException, CardTerminalException, OperationCancelledException {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        cs.verifyPassword(this.getInfo(), _pin);
        return true;
    }

    @Override
    public int getRetries() throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        GovCS cs = this.getCS();
        if (cs == null) {
            return -1;
        }
        if (this.useCardPinForAccessEnabled) {
            return cs.getRetryCount(this);
        }
        return cs.getRetryCount(this.getInfo());
    }

    @Override
    public boolean isInitialized() throws CardTerminalException, ResponseCodeException {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        if (this.useCardPinForAccessEnabled) {
            return cs.isInitialized(this);
        }
        return cs.isKeyInitialized(this.infos[0]);
    }

    @Override
    public boolean isInitialized(CardChannel channel) throws CardTerminalException, ResponseCodeException, InvalidCardChannelException, RetryCounterExpiredException {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        if (this.useCardPinForAccessEnabled) {
            return new GovCSAccessor(cs).isInitialized(channel, this);
        }
        return new GovCSAccessor(cs).isKeyInitialized(channel, this.infos[0]);
    }

    @Override
    public boolean change(char[] _pin, char[] _newPIN) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, OperationCancelledException, PinDeactivatedException {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        return cs.changePassword(this.infos != null ? this.infos[0] : null, _pin, _newPIN) == 36864;
    }

    private GovCS getCS() {
        GovCS cs = super.getCardService();
        if (this.infos == null) {
            this.getInfos();
        }
        if (this.infos == null || this.infos.length == 0) {
            // empty if block
        }
        return cs;
    }

    @Override
    public boolean init(char[] _pin, char[] _newPIN) throws WrongPinException, RetryCounterExpiredException, ResponseCodeException, WrongConfirmedNewPinException, NotYetInitializedException, OperationCancelledException, PinDeactivatedException {
        GovCS cs = this.getCS();
        if (cs == null) {
            return false;
        }
        return cs.initPassword(this.getInfo(), _pin, _newPIN) == 36864;
    }

    @Override
    public boolean isInitSupported() {
        return this.initSupported;
    }

    public void setInitSupported(boolean initSupported) {
        this.initSupported = initSupported;
    }

    @Override
    public boolean isInitEnabled() {
        return this.initEnabled;
    }

    public void setInitEnabled(boolean initEnabled) {
        this.initEnabled = initEnabled;
    }

    @Override
    public boolean isUnblockSupported() {
        return this.unblockSupported;
    }

    public void setUnblockSupported(boolean unblockSupported) {
        this.unblockSupported = unblockSupported;
    }

    @Override
    public boolean isUnblockEnabled() {
        return this.unblockEnabled;
    }

    public void setUnblockEnabled(boolean unblockEnabled) {
        this.unblockEnabled = unblockEnabled;
    }

    @Override
    public boolean isSetSupported() {
        return this.setSupported;
    }

    public void setSetSupported(boolean setSupported) {
        this.setSupported = setSupported;
    }

    @Override
    public boolean isSetEnabled() {
        return this.setEnabled;
    }

    public void setSetEnabled(boolean setEnabled) {
        this.setEnabled = setEnabled;
    }

    @Override
    public boolean isVerifySupported() {
        return this.verifySupported;
    }

    public void setVerifySupported(boolean verifySupported) {
        this.verifySupported = verifySupported;
    }

    @Override
    public boolean isVerifyEnabled() {
        return this.verifyEnabled;
    }

    public void setVerifyEnabled(boolean verifyEnabled) {
        this.verifyEnabled = verifyEnabled;
    }

    @Override
    public boolean useCardPinForAccess() {
        return this.useCardPinForAccessEnabled;
    }

    @Override
    public boolean isChangeEnabled() {
        return this.changeEnabled;
    }

    public void setChangeEnabled(boolean changeEnabled) {
        this.changeEnabled = changeEnabled;
    }

    @Override
    public boolean isChangeSupported() {
        return this.changeSupported;
    }

    @Override
    public void setUseCardPinForAccessEnabled(boolean useCardPinForAccessEnabled) {
        this.useCardPinForAccessEnabled = useCardPinForAccessEnabled;
    }

    @Override
    public void disableAllPinFunctions() {
        this.initSupported = false;
        this.initEnabled = false;
        this.verifySupported = false;
        this.verifyEnabled = false;
        this.changeSupported = false;
        this.changeEnabled = false;
        this.setSupported = false;
        this.setEnabled = false;
        this.unblockSupported = false;
        this.unblockEnabled = false;
    }

    @Override
    public int getRetries(CardChannel channel) throws InvalidCardChannelException, CardTerminalException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, PinDeactivatedException {
        if (this.useCardPinForAccessEnabled) {
            return new GovCSAccessor(this.getCS()).getRetryCount(channel, this);
        }
        return new GovCSAccessor(this.getCS()).getRetryCount(channel, this.getInfo());
    }
}

