/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.EqualsUtil;
import de.bos_bremen.common.Filter;
import de.bos_bremen.common.FilterUtil;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Terminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalFU;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.TypedType;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardEventImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.NamedIDTypedMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.SlotCardWrapper;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.TerminalEventImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.TerminalImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.NamedIDTypedMapImpl;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CardObjectRegistryImpl
implements CardObjectRegistry {
    private static final Log LOG = LogFactory.getLog(CardObjectRegistryImpl.class);
    private volatile int cardid = 0;
    private NamedIDTypedMap<Card> cardMap = null;
    private NamedIDTypedMap<Terminal> terminalMap = null;
    private Map<CardTerminal, Terminal> ocfMappingTerminalMap = null;
    private Map<SmartCard, Card> ocfMappingCardMap = null;
    private Object disposeMapLock = new Object();
    private final List<CardListener> cardListeners;
    private final List<TerminalListener> terminalListeners;
    private static volatile long terminalID = 0L;

    private CardObjectRegistryImpl() {
        this.cardMap = new NamedIDTypedMapImpl<Card>(this.disposeMapLock, "CardMap", 1L, TypedType.TypedTypeEnum.NATURAL.getUnknownType(), TypedType.TypedTypeEnum.NATURAL, Card.CardTypeEnum.TYPES, Card.class, Card[].class);
        this.terminalMap = new NamedIDTypedMapImpl<Terminal>(this.disposeMapLock, "TerminalMap", 1L, TypedType.TypedTypeEnum.BIT.getUnknownType(), TypedType.TypedTypeEnum.BIT, Terminal.TerminalDriverTypeEnum.TYPES, Terminal.class, Terminal[].class);
        this.ocfMappingTerminalMap = new LinkedHashMap<CardTerminal, Terminal>();
        this.ocfMappingCardMap = new LinkedHashMap<SmartCard, Card>();
        this.cardListeners = new ArrayList<CardListener>();
        this.terminalListeners = new ArrayList<TerminalListener>();
    }

    public void start(CardTerminalManager terminalManager) {
        Enumeration<CardTerminal> terminals = CardTerminalRegistry.getRegistry().getCardTerminals();
        while (terminals.hasMoreElements()) {
            this.addTerminal(terminals.nextElement());
        }
    }

    public void addTerminal(CardTerminal terminal) {
        if (this.getTerminal(terminal) != null) {
            return;
        }
        Type type = null;
        if (JPCSCCardTerminal.class.isInstance(terminal)) {
            type = Terminal.TerminalDriverTypeEnum.PCSC20.getType();
        }
        if (type == null) {
            type = Terminal.TerminalDriverTypeEnum.UNKNOWN.getType();
        }
        TerminalImpl tmpTerminal = new TerminalImpl(this.disposeMapLock, terminal, terminalID++, type);
        this.terminalMap.put(tmpTerminal);
        this.ocfMappingTerminalMap.put(terminal, tmpTerminal);
        this.notifyTerminalListener(terminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCard(CardTerminalManager manager, CardTerminalEvent ctEvent, SmartCard smartCard, GovCS cs) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            NamedIDTypedMap<Terminal> namedIDTypedMap = this.terminalMap;
            synchronized (namedIDTypedMap) {
                NamedIDTypedMap<Card> namedIDTypedMap2 = this.cardMap;
                synchronized (namedIDTypedMap2) {
                    Card card = cs.createCard(ctEvent);
                    if (card != null) {
                        ((TerminalImpl)card.getTerminal()).addCard(card);
                        this.cardMap.put(card);
                        this.ocfMappingCardMap.put(smartCard, card);
                        OCFCertificateInfo[] infos = card.getAllCertificates();
                        for (int i = 0; i < infos.length; ++i) {
                            infos[i].init();
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(cs + " has created no card: fix it - CardObjectRegistryImpl"));
                    }
                }
            }
        }
    }

    public void notifyCardListenerUnknownCard() {
        this.notifyListeners(CardEventImpl.UNKNOWN_CARD_INSERTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCardListener(SmartCard smartCard) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            NamedIDTypedMap<Terminal> namedIDTypedMap = this.terminalMap;
            synchronized (namedIDTypedMap) {
                NamedIDTypedMap<Card> namedIDTypedMap2 = this.cardMap;
                synchronized (namedIDTypedMap2) {
                    Card card = this.ocfMappingCardMap.get(smartCard);
                    if (card != null) {
                        this.notifyListeners(card, 0);
                    }
                }
            }
        }
    }

    public void notifyTerminalListenerUnknownTerminal() {
        this.notifyListeners(TerminalEventImpl.UNKNOWN_TERMINAL_CONNECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTerminalListener(CardTerminal cardTerminal) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            NamedIDTypedMap<Terminal> namedIDTypedMap = this.terminalMap;
            synchronized (namedIDTypedMap) {
                Map<CardTerminal, Terminal> map = this.ocfMappingTerminalMap;
                synchronized (map) {
                    Terminal terminal = this.ocfMappingTerminalMap.get(cardTerminal);
                    if (terminal != null) {
                        this.notifyListeners(terminal, 0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCard(CardTerminalEvent ctEvent) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            NamedIDTypedMap<Terminal> namedIDTypedMap = this.terminalMap;
            synchronized (namedIDTypedMap) {
                Terminal terminal = this.getTerminal(ctEvent.getCardTerminal());
                if (terminal != null) {
                    NamedIDTypedMap<Card> namedIDTypedMap2 = this.cardMap;
                    synchronized (namedIDTypedMap2) {
                        Card card = this.getCardByTerminalAndSlotID(terminal.getID(), ctEvent.getSlotID());
                        if (card != null) {
                            this.notifyListeners(card, 1);
                            ((TerminalImpl)card.getTerminal()).removeCard(card);
                            this.cardMap.remove(card);
                            this.ocfMappingCardMap.remove(card.getSmartCard());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTerminal(CardTerminal cardTerminal) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            NamedIDTypedMap<Terminal> namedIDTypedMap = this.terminalMap;
            synchronized (namedIDTypedMap) {
                Terminal terminal = this.getTerminal(cardTerminal);
                if (terminal != null) {
                    this.notifyListeners(terminal, 1);
                    this.terminalMap.remove(terminal);
                    this.ocfMappingTerminalMap.remove(cardTerminal);
                }
            }
        }
    }

    public void shutdown(CardTerminalManager terminalManager) {
        Card[] cards = (Card[])this.cardMap.valueArray();
        for (int i = 0; i < cards.length; ++i) {
        }
        Terminal[] terminals = (Terminal[])this.terminalMap.valueArray();
        for (int i = 0; i < terminals.length; ++i) {
            try {
                terminals[i].dispose(this.disposeMapLock);
                continue;
            }
            catch (Exception e) {
                LOG.debug((Object)("failed disposing map: " + e.getMessage()));
            }
        }
        this.cardMap.clear();
        this.terminalMap.clear();
        this.ocfMappingTerminalMap.clear();
        this.ocfMappingCardMap.clear();
    }

    public static CardObjectRegistry getInstance() {
        return SINGLETON_HOLDER.SINGLETON;
    }

    @Override
    public Card getCardByID(long id) {
        return this.cardMap.getByID(id);
    }

    @Override
    public Card getCardByName(String name) {
        return this.cardMap.getByName(name);
    }

    public Card getCardByTerminalAndSlotID(long terminalID, int slotID) {
        Card card = this.getTerminalByID(terminalID).getCard(slotID);
        return !SlotCardWrapper.class.isInstance(card) ? card : card.getCard();
    }

    @Override
    public Card[] getCards() {
        return this.cardMap.values().toArray(new Card[0]);
    }

    @Override
    public <T extends CardObject<?>> T[] getObjects(Filter<T> filter) {
        List<CardObject> listObjects = this.getObjectList(filter);
        CardObject[] array = (CardObject[])ArrayUtil.getEmptyArray(filter.getFilterClass());
        if (CollectionUtil.isNullOrEmpty(listObjects)) {
            return array;
        }
        return listObjects.toArray(array);
    }

    @Override
    public <T extends CardObject<?>> List<T> getObjectList(Filter<T> filter) {
        List collection = new ArrayList();
        if (filter == null) {
            return null;
        }
        if (EqualsUtil.equals(filter.getFilterClass(), Card.class)) {
            collection = (List)CollectionUtil.cast(filter.getFilterClass(), this.cardMap.values());
        } else if (EqualsUtil.equals(filter.getFilterClass(), Terminal.class)) {
            collection = (List)CollectionUtil.cast(filter.getFilterClass(), this.terminalMap.values());
        }
        return FilterUtil.filter(filter, collection);
    }

    @Override
    public Terminal getTerminalByID(long id) {
        return this.terminalMap.getByID(id);
    }

    @Override
    public Terminal getTerminalByName(String name) {
        return this.terminalMap.getByName(name);
    }

    @Override
    public Terminal[] getTerminals() {
        return this.terminalMap.values().toArray(new Terminal[0]);
    }

    @Override
    public Card getCard(SmartCard smartCard) {
        return this.ocfMappingCardMap.get(smartCard);
    }

    @Override
    public Terminal getTerminal(CardTerminal cardTerminal) {
        return this.ocfMappingTerminalMap.get(cardTerminal);
    }

    @Override
    public Card getCardByID(Long id) {
        return this.cardMap.getByID(id);
    }

    @Override
    public Card getCardByTerminalAndSlotID(Terminal terminal, int slotID) {
        return terminal.getCard(slotID);
    }

    @Override
    public Card getCardByTerminalIDAndSlotID(long terminalID, int slotID) {
        return this.getTerminalByID(terminalID).getCard(slotID);
    }

    @Override
    public Card getCardByTerminalIDAndSlotID(Long terminalID, int slotID) {
        return this.getTerminalByID(terminalID).getCard(slotID);
    }

    @Override
    public Card getCardByTerminalSlot(TerminalFU terminalFU) {
        return null;
    }

    @Override
    public Terminal getTerminalByID(Long id) {
        return this.terminalMap.getByID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCardListener(CardListener listener) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.cardListeners != null && !this.cardListeners.contains(listener)) {
                this.cardListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCardListener(CardListener listener) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.cardListeners != null && this.cardListeners.contains(listener)) {
                this.cardListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTerminalListener(TerminalListener listener) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.terminalListeners != null && !this.terminalListeners.contains(listener)) {
                this.terminalListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTerminalListener(TerminalListener listener) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.terminalListeners != null && this.terminalListeners.contains(listener)) {
                this.terminalListeners.remove(listener);
            }
        }
    }

    private void notifyListeners(Card card, int type) {
        this.notifyListeners(new CardEventImpl(card, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(CardEvent event) {
        if (event == null) {
            return;
        }
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.cardListeners != null) {
                for (CardListener listener : this.cardListeners) {
                    if (listener == null) continue;
                    try {
                        listener.processEvent(event);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("card listener failed to process event: " + e.getMessage()));
                    }
                }
            }
        }
    }

    private void notifyListeners(Terminal terminal, int type) {
        this.notifyListeners(new TerminalEventImpl(terminal, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(TerminalEvent event) {
        if (event == null) {
            return;
        }
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.terminalListeners != null) {
                for (TerminalListener listener : this.terminalListeners) {
                    if (listener == null) continue;
                    try {
                        listener.processEvent(event);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("terminal listener failed to process event: " + e.getMessage()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createEventForPresentCards(CardListener listener) {
        CardObjectRegistryImpl cardObjectRegistryImpl = this;
        synchronized (cardObjectRegistryImpl) {
            if (this.cardMap != null && !this.cardMap.isEmpty()) {
                for (Card card : this.cardMap.values()) {
                    this.notifyListeners(new CardEventImpl(card, 0));
                }
            }
        }
    }

    @Override
    public synchronized int createNewCardID() {
        return this.cardid++;
    }

    @Override
    public synchronized void removeAllCardListener() {
        if (this.cardListeners != null) {
            this.cardListeners.clear();
        }
    }

    @Override
    public synchronized void removeAllTerminalListener() {
        if (this.terminalListeners != null) {
            this.terminalListeners.clear();
        }
    }

    private static class SINGLETON_HOLDER {
        private static final CardObjectRegistryImpl SINGLETON = new CardObjectRegistryImpl();

        private SINGLETON_HOLDER() {
        }
    }
}

