/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.EqualsUtil;
import de.bos_bremen.common.Filter;
import de.bos_bremen.common.FilterUtil;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractDisposeableObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.ID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Named;
import de.bos_bremen.gov2.jca_provider.ocf.model.Util;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.NamedIDTypedMap;
import de.bos_bremen.gov2.jca_provider.ocf.model.map.NamedIDTypedMapImpl;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CardObjectManagerImpl
extends AbstractDisposeableObject
implements CardObjectManager {
    private NamedIDTypedMap<CardApplication> applicationMap = null;
    private NamedIDTypedMap<CardPin> pinMap = null;
    private NamedIDTypedMap<CardFile> fileMap = null;
    private NamedIDTypedMap<CardKey> keyMap = null;
    private Object disposeMapLock = new Object();
    private long id = -1L;

    public CardObjectManagerImpl(long id) {
        this(id, new CardApplication[0], new CardPin[0], new CardFile[0], new CardKey[0]);
    }

    public CardObjectManagerImpl(long id, CardApplication[] applications, CardPin[] pins, CardFile[] files, CardKey[] keys) {
        this(NO_LOCK, id, applications, pins, files, keys);
    }

    public CardObjectManagerImpl(Object disposeLock, long id, CardApplication[] applications, CardPin[] pins, CardFile[] files, CardKey[] keys) {
        super(disposeLock);
        this.id = id;
        this.applicationMap = new NamedIDTypedMapImpl(this.disposeMapLock, "applications-" + String.valueOf(id), id, null, CardApplication.TYPE_KIND, CardApplication.CardApplicationTypeEnum.TYPES, CardApplication.class, CardApplication[].class, (Named[])applications);
        this.pinMap = new NamedIDTypedMapImpl(this.disposeMapLock, "pins-" + String.valueOf(id), id, null, CardPin.TYPE_KIND, CardPin.CardPinTypeEnum.TYPES, CardPin.class, CardPin[].class, (Named[])pins);
        this.fileMap = new NamedIDTypedMapImpl(this.disposeMapLock, "files-" + String.valueOf(id), id, null, CardFile.TYPE_KIND, CardFile.CardFileTypeEnum.TYPES, CardFile.class, CardFile[].class, (Named[])files);
        this.keyMap = new NamedIDTypedMapImpl(this.disposeMapLock, "keys-" + String.valueOf(id), id, null, CardKey.TYPE_KIND, CardKey.CardKeyTypeEnum.TYPES, CardKey.class, CardKey[].class, (Named[])keys);
    }

    private <S extends Named & ID> NamedIDTypedMap<S> getMapByClass(Class<S> clazz) {
        if (EqualsUtil.equals(clazz, CardApplication.class) || CardApplication.class.isAssignableFrom(clazz)) {
            return Util.castNamedIDMap(clazz, this.applicationMap);
        }
        if (EqualsUtil.equals(clazz, CardPin.class) || CardPin.class.isAssignableFrom(clazz)) {
            return Util.castNamedIDMap(clazz, this.pinMap);
        }
        if (EqualsUtil.equals(clazz, CardFile.class) || CardFile.class.isAssignableFrom(clazz)) {
            return Util.castNamedIDMap(clazz, this.fileMap);
        }
        if (EqualsUtil.equals(clazz, CardKey.class) || CardKey.class.isAssignableFrom(clazz)) {
            return Util.castNamedIDMap(clazz, this.keyMap);
        }
        return null;
    }

    private static <S extends Named & ID> S[] getArrayByClass(Class<S> clazz, Collection<S> valueCollection) {
        if (EqualsUtil.equals(clazz, CardObject.class)) {
            return valueCollection.toArray(new CardObject[0]);
        }
        if (EqualsUtil.equals(clazz, CardApplication.class)) {
            return valueCollection.toArray(new CardApplication[0]);
        }
        if (EqualsUtil.equals(clazz, CardPin.class)) {
            return valueCollection.toArray(new CardPin[0]);
        }
        if (EqualsUtil.equals(clazz, CardFile.class)) {
            return valueCollection.toArray(new CardFile[0]);
        }
        if (EqualsUtil.equals(clazz, CardKey.class)) {
            return valueCollection.toArray(new CardKey[0]);
        }
        return null;
    }

    @Override
    public <T extends CardObject> void put(Class<T> clazz, T cardObject) {
        if (cardObject.getParentApplicationID() != this.id) {
            throw new IllegalArgumentException("ID of parent application at CardObject does not match epxected of manager");
        }
        this.getMapByClass(clazz).put(cardObject);
    }

    @Override
    public void putApplication(CardApplication application) {
        this.put(CardApplication.class, application);
    }

    @Override
    public void putPin(CardPin pin) {
        this.put(CardPin.class, pin);
    }

    @Override
    public void putFile(CardFile file) {
        this.put(CardFile.class, file);
    }

    @Override
    public void putKey(CardKey key) {
        this.put(CardKey.class, key);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public boolean disposeInt() throws IllegalStateException {
        if (this.applicationMap != null) {
            this.applicationMap.dispose(this.disposeMapLock);
            this.applicationMap.clear();
            this.applicationMap = null;
        }
        if (this.pinMap != null) {
            this.pinMap.dispose(this.disposeMapLock);
            this.pinMap.clear();
            this.pinMap = null;
        }
        if (this.fileMap != null) {
            this.fileMap.dispose(this.disposeMapLock);
            this.fileMap.clear();
            this.fileMap = null;
        }
        if (this.keyMap != null) {
            this.keyMap.dispose(this.disposeMapLock);
            this.keyMap.clear();
            this.keyMap = null;
        }
        this.disposeMapLock = NO_LOCK;
        this.id = -1L;
        return true;
    }

    @Override
    public CardObject get(Object key, int scope) {
        CardObject<CardApplicationType> result = null;
        result = this.get(CardApplication.class, key, scope);
        if (result == null) {
            result = this.get(CardPin.class, key, scope);
        }
        if (result == null) {
            result = this.get(CardFile.class, key, scope);
        }
        if (result == null) {
            result = this.get(CardKey.class, key, scope);
        }
        return result;
    }

    @Override
    public <T extends CardObject> T get(Class<T> clazz, Object key, int scope) {
        if (Long.class.isInstance(key)) {
            return this.getByID(clazz, (Long)key, scope);
        }
        if (String.class.isInstance(key)) {
            return this.getByName(clazz, (String)key, scope);
        }
        return null;
    }

    @Override
    public CardApplication getApplication(Object key, int scope) {
        return this.get(CardApplication.class, key, scope);
    }

    @Override
    public CardApplication getApplicationByID(long id, int scope) {
        return this.getByID(CardApplication.class, id, scope);
    }

    @Override
    public CardApplication getApplicationByName(String name, int scope) {
        return this.getByName(CardApplication.class, name, scope);
    }

    @Override
    public Collection<CardApplication> getApplicationCollection(int scope) {
        return this.getObjectCollection(CardApplication.class, scope);
    }

    @Override
    public Collection<CardApplication> getApplicationCollection(Filter<CardApplication> filter, int scope) {
        return this.getObjectCollection(CardApplication.class, filter, scope);
    }

    @Override
    public Map<Long, CardApplication> getApplicationIDMap(int scope) {
        return this.getIDMap(CardApplication.class, scope);
    }

    @Override
    public Set<Long> getApplicationIDSet(int scope) {
        return this.getIDSet(CardApplication.class, scope);
    }

    @Override
    public long[] getApplicationIDs(int scope) {
        return this.getIDs(CardApplication.class, scope);
    }

    @Override
    public Long[] getApplicationIDsLong(int scope) {
        return this.getIDsLong(CardApplication.class, scope);
    }

    @Override
    public Map<String, CardApplication> getApplicationNameMap(int scope) {
        return this.getNameMap(CardApplication.class, scope);
    }

    @Override
    public Set<String> getApplicationNameSet(int scope) {
        return this.getNameSet(CardApplication.class, scope);
    }

    @Override
    public String[] getApplicationNames(int scope) {
        return this.getNames(CardApplication.class, scope);
    }

    @Override
    public CardApplication[] getApplications(int scope) {
        return this.getApplicationCollection(scope).toArray(new CardApplication[0]);
    }

    @Override
    public CardApplication[] getApplications(Filter<CardApplication> filter, int scope) {
        return (CardApplication[])this.getObjects(CardApplication.class, filter, scope);
    }

    @Override
    public CardObject getByID(long id, int scope) {
        CardObject<CardApplicationType> result = null;
        result = this.getByID(CardApplication.class, id, scope);
        if (result == null) {
            result = this.getByID(CardPin.class, id, scope);
        }
        if (result == null) {
            result = this.getByID(CardFile.class, id, scope);
        }
        if (result == null) {
            result = this.getByID(CardKey.class, id, scope);
        }
        return result;
    }

    @Override
    public <T extends CardObject> T getByID(Class<T> clazz, long id, int scope) {
        if (super.isDisposed()) {
            return null;
        }
        if (clazz == CardObject.class) {
            CardObject co = this.getByID(id, scope);
            return (T)((CardObject)clazz.cast(co));
        }
        CardObject<Object> result = null;
        switch (scope) {
            case 0: {
                result = (CardObject)this.getMapByClass(clazz).getByID(id);
                break;
            }
            case 1: {
                CardApplication cardApplication;
                result = (CardObject)this.getMapByClass(clazz).getByID(id);
                if (result != null) break;
                Collection<CardApplication> applicationCollection = this.getApplicationCollection(0);
                Iterator<CardApplication> iterator = applicationCollection.iterator();
                while (iterator.hasNext() && (result = (cardApplication = iterator.next()).getByID(clazz, id, 1)) == null) {
                }
                break;
            }
        }
        return (T)result;
    }

    @Override
    public CardObject getByName(String name, int scope) {
        CardObject<CardApplicationType> result = null;
        result = this.getByName(CardApplication.class, name, scope);
        if (result == null) {
            result = this.getByName(CardPin.class, name, scope);
        }
        if (result == null) {
            result = this.getByName(CardFile.class, name, scope);
        }
        if (result == null) {
            result = this.getByName(CardKey.class, name, scope);
        }
        return result;
    }

    @Override
    public <T extends CardObject> T getByName(Class<T> clazz, String name, int scope) {
        if (super.isDisposed()) {
            return null;
        }
        if (clazz == CardObject.class) {
            CardObject co = this.getByName(name, scope);
            return (T)((CardObject)clazz.cast(co));
        }
        CardObject<Object> result = null;
        switch (scope) {
            case 0: {
                result = (CardObject)this.getMapByClass(clazz).getByName(name);
                break;
            }
            case 1: {
                CardApplication cardApplication;
                result = (CardObject)this.getMapByClass(clazz).getByName(name);
                if (result != null) break;
                Collection<CardApplication> applicationCollection = this.getApplicationCollection(0);
                Iterator<CardApplication> iterator = applicationCollection.iterator();
                while (iterator.hasNext() && (result = (cardApplication = iterator.next()).getByName(clazz, name, scope)) == null) {
                }
                break;
            }
        }
        return (T)result;
    }

    @Override
    public CardFile getFile(Object key, int scope) {
        return this.get(CardFile.class, key, scope);
    }

    @Override
    public CardFile getFileByID(long id, int scope) {
        return this.getByID(CardFile.class, id, scope);
    }

    @Override
    public CardFile getFileByName(String name, int scope) {
        return this.getByName(CardFile.class, name, scope);
    }

    @Override
    public Collection<CardFile> getFileCollection(int scope) {
        return this.getObjectCollection(CardFile.class, scope);
    }

    @Override
    public Collection<CardFile> getFileCollection(Filter<CardFile> filter, int scope) {
        return this.getObjectCollection(CardFile.class, filter, scope);
    }

    @Override
    public Map<Long, CardFile> getFileIDMap(int scope) {
        return this.getIDMap(CardFile.class, scope);
    }

    @Override
    public Set<Long> getFileIDSet(int scope) {
        return this.getIDSet(CardFile.class, scope);
    }

    @Override
    public long[] getFileIDs(int scope) {
        return this.getIDs(CardFile.class, scope);
    }

    @Override
    public Long[] getFileIDsLong(int scope) {
        return this.getIDsLong(CardFile.class, scope);
    }

    @Override
    public Map<String, CardFile> getFileNameMap(int scope) {
        return this.getNameMap(CardFile.class, scope);
    }

    @Override
    public Set<String> getFileNameSet(int scope) {
        return this.getNameSet(CardFile.class, scope);
    }

    @Override
    public String[] getFileNames(int scope) {
        return this.getNames(CardFile.class, scope);
    }

    @Override
    public CardFile[] getFiles(int scope) {
        return this.getFileCollection(scope).toArray(new CardFile[0]);
    }

    @Override
    public CardFile[] getFiles(Filter<CardFile> filter, int scope) {
        return (CardFile[])this.getObjects(CardFile.class, filter, scope);
    }

    @Override
    public Map<Long, CardObject> getIDMap(int scope) {
        HashMap<Long, CardObject> resultMap = new HashMap<Long, CardObject>();
        resultMap.putAll(this.getIDMap(CardApplication.class, scope));
        resultMap.putAll(this.getIDMap(CardPin.class, scope));
        resultMap.putAll(this.getIDMap(CardFile.class, scope));
        resultMap.putAll(this.getIDMap(CardKey.class, scope));
        return resultMap;
    }

    @Override
    public <T extends CardObject> Map<Long, T> getIDMap(Class<T> clazz, int scope) {
        if (super.isDisposed()) {
            return new HashMap();
        }
        if (clazz == CardObject.class) {
            return CollectionUtil.cast(Long.class, clazz, this.getIDMap(scope));
        }
        Map<Long, T> result = null;
        switch (scope) {
            case 0: {
                result = this.getMapByClass(clazz).getIDMap();
                break;
            }
            case 1: {
                result = new HashMap<Long, T>(this.getMapByClass(clazz).getIDMap());
                Collection<CardApplication> applicationCollection = this.getApplicationCollection(0);
                for (CardApplication cardApplication : applicationCollection) {
                    result.putAll(cardApplication.getIDMap(clazz, 1));
                }
                break;
            }
        }
        return result;
    }

    @Override
    public Set<Long> getIDSet(int scope) {
        return this.getIDMap(scope).keySet();
    }

    @Override
    public <T extends CardObject> Set<Long> getIDSet(Class<T> clazz, int scope) {
        return this.getIDMap(clazz, scope).keySet();
    }

    @Override
    public long[] getIDs(int scope) {
        return CardObjectManagerImpl.toPrimitiveLongArray(this.getIDsLong(scope));
    }

    @Override
    public <T extends CardObject> long[] getIDs(Class<T> clazz, int scope) {
        return CardObjectManagerImpl.toPrimitiveLongArray(this.getIDsLong(clazz, scope));
    }

    @Override
    public Long[] getIDsLong(int scope) {
        return this.getIDMap(scope).keySet().toArray(new Long[0]);
    }

    @Override
    public <T extends CardObject> Long[] getIDsLong(Class<T> clazz, int scope) {
        Set<Long> result = null;
        switch (scope) {
            case 0: {
                result = this.getIDMap(clazz, scope).keySet();
                break;
            }
            case 1: {
                result = new HashSet<Long>(this.getIDMap(clazz, scope).keySet());
                Collection<CardApplication> applicationCollection = this.getApplicationCollection(0);
                for (CardApplication cardApplication : applicationCollection) {
                    result.addAll(cardApplication.getIDMap(clazz, 1).keySet());
                }
                break;
            }
        }
        return result.toArray(new Long[0]);
    }

    @Override
    public CardKey getKey(Object key, int scope) {
        return this.get(CardKey.class, key, scope);
    }

    @Override
    public CardKey getKeyByID(long id, int scope) {
        return this.getByID(CardKey.class, id, scope);
    }

    @Override
    public CardKey getKeyByName(String name, int scope) {
        return this.getByName(CardKey.class, name, scope);
    }

    @Override
    public Collection<CardKey> getKeyCollection(int scope) {
        return this.getObjectCollection(CardKey.class, scope);
    }

    @Override
    public Collection<CardKey> getKeyCollection(Filter<CardKey> filter, int scope) {
        return this.getObjectCollection(CardKey.class, filter, scope);
    }

    @Override
    public Map<Long, CardKey> getKeyIDMap(int scope) {
        return this.getIDMap(CardKey.class, scope);
    }

    @Override
    public Set<Long> getKeyIDSet(int scope) {
        return this.getIDSet(CardKey.class, scope);
    }

    @Override
    public long[] getKeyIDs(int scope) {
        return this.getIDs(CardKey.class, scope);
    }

    @Override
    public Long[] getKeyIDsLong(int scope) {
        return this.getIDsLong(CardKey.class, scope);
    }

    @Override
    public Map<String, CardKey> getKeyNameMap(int scope) {
        return this.getNameMap(CardKey.class, scope);
    }

    @Override
    public Set<String> getKeyNameSet(int scope) {
        return this.getNameSet(CardKey.class, scope);
    }

    @Override
    public String[] getKeyNames(int scope) {
        return this.getNames(CardKey.class, scope);
    }

    @Override
    public CardKey[] getKeys(int scope) {
        return this.getObjectCollection(CardKey.class, scope).toArray(new CardKey[0]);
    }

    @Override
    public CardKey[] getKeys(Filter<CardKey> filter, int scope) {
        return (CardKey[])this.getObjects(CardKey.class, filter, scope);
    }

    @Override
    public Map<String, CardObject> getNameMap(int scope) {
        HashMap<String, CardObject> resultMap = new HashMap<String, CardObject>();
        resultMap.putAll(this.getNameMap(CardApplication.class, scope));
        resultMap.putAll(this.getNameMap(CardPin.class, scope));
        resultMap.putAll(this.getNameMap(CardFile.class, scope));
        resultMap.putAll(this.getNameMap(CardKey.class, scope));
        return resultMap;
    }

    @Override
    public <T extends CardObject> Map<String, T> getNameMap(Class<T> clazz, int scope) {
        if (super.isDisposed()) {
            return new HashMap();
        }
        if (clazz == CardObject.class) {
            return CollectionUtil.cast(String.class, clazz, this.getNameMap(scope));
        }
        Map<String, T> result = null;
        switch (scope) {
            case 0: {
                result = this.getMapByClass(clazz).getNamedMap();
                break;
            }
            case 1: {
                result = new HashMap<String, T>(this.getMapByClass(clazz).getNamedMap());
                Collection<CardApplication> applicationList = this.getApplicationCollection(0);
                Iterator<CardApplication> applicationIterator = applicationList.iterator();
                while (applicationIterator.hasNext()) {
                    result.putAll(applicationIterator.next().getNameMap(clazz, scope));
                }
                break;
            }
        }
        return result;
    }

    @Override
    public Set<String> getNameSet(int scope) {
        return this.getNameMap(scope).keySet();
    }

    @Override
    public <T extends CardObject> Set<String> getNameSet(Class<T> clazz, int scope) {
        return this.getNameMap(clazz, scope).keySet();
    }

    @Override
    public String[] getNames(int scope) {
        return this.getNameSet(scope).toArray(new String[0]);
    }

    @Override
    public <T extends CardObject> String[] getNames(Class<T> clazz, int scope) {
        return this.getNameMap(clazz, scope).keySet().toArray(new String[0]);
    }

    @Override
    public Collection<CardObject> getObjectCollection(int scope) {
        ArrayList<CardObject> resultCollection = new ArrayList<CardObject>();
        resultCollection.addAll(this.getObjectCollection(CardApplication.class, scope));
        resultCollection.addAll(this.getObjectCollection(CardPin.class, scope));
        resultCollection.addAll(this.getObjectCollection(CardFile.class, scope));
        resultCollection.addAll(this.getObjectCollection(CardKey.class, scope));
        return resultCollection;
    }

    @Override
    public <T extends CardObject> Collection<T> getObjectCollection(Class<T> clazz, int scope) {
        if (super.isDisposed()) {
            return new ArrayList();
        }
        if (clazz == CardObject.class) {
            Collection<CardObject> collection = this.getObjectCollection(scope);
            return CollectionUtil.cast(clazz, collection);
        }
        Collection<Object> result = null;
        switch (scope) {
            case 0: {
                result = this.getMapByClass(clazz).values();
                break;
            }
            case 1: {
                result = new ArrayList();
                result.addAll(this.getMapByClass(clazz).values());
                Collection<CardApplication> applicationList = this.getApplicationCollection(0);
                Iterator<CardApplication> applicationIterator = applicationList.iterator();
                while (applicationIterator.hasNext()) {
                    result.addAll(applicationIterator.next().getObjectCollection(clazz, scope));
                }
                break;
            }
        }
        return result;
    }

    @Override
    public Collection<CardObject> getObjectCollection(Filter<CardObject> filter, int scope) {
        ArrayList<CardObject> resultCollection = new ArrayList<CardObject>();
        resultCollection.addAll(this.getObjectCollection(CardApplication.class, FilterUtil.cast(CardApplication.class, filter), scope));
        resultCollection.addAll(this.getObjectCollection(CardPin.class, FilterUtil.cast(CardPin.class, filter), scope));
        resultCollection.addAll(this.getObjectCollection(CardFile.class, FilterUtil.cast(CardFile.class, filter), scope));
        resultCollection.addAll(this.getObjectCollection(CardKey.class, FilterUtil.cast(CardKey.class, filter), scope));
        return resultCollection;
    }

    @Override
    public <T extends CardObject> Collection<T> getObjectCollection(Class<T> clazz, Filter<T> filter, int scope) {
        if (super.isDisposed()) {
            return new ArrayList();
        }
        if (clazz == CardObject.class) {
            Collection<CardObject> collection = this.getObjectCollection(FilterUtil.cast(CardObject.class, filter), scope);
            return CollectionUtil.cast(clazz, collection);
        }
        Collection<Object> result = null;
        switch (scope) {
            case 0: {
                result = FilterUtil.filter(filter, this.getMapByClass(clazz).values());
                break;
            }
            case 1: {
                result = new ArrayList<T>();
                result.addAll(FilterUtil.filter(filter, this.getMapByClass(clazz).values()));
                Collection<CardApplication> applicationList = this.getApplicationCollection(0);
                Iterator<CardApplication> applicationIterator = applicationList.iterator();
                while (applicationIterator.hasNext()) {
                    result.addAll(applicationIterator.next().getObjectCollection(clazz, filter, scope));
                }
                break;
            }
        }
        return result;
    }

    @Override
    public CardObject[] getObjects(int scope) {
        return this.getObjectCollection(scope).toArray(new CardObject[0]);
    }

    @Override
    public <T extends CardObject> T[] getObjects(Class<T> clazz, int scope) {
        return (CardObject[])CardObjectManagerImpl.getArrayByClass(clazz, this.getObjectCollection(clazz, scope));
    }

    @Override
    public CardObject[] getObjects(Filter<CardObject> filter, int scope) {
        return this.getObjectCollection(filter, scope).toArray(new CardObject[0]);
    }

    @Override
    public <T extends CardObject> T[] getObjects(Class<T> clazz, Filter<T> filter, int scope) {
        return this.getObjectCollection(clazz, filter, scope).toArray((CardObject[])ArrayUtil.getEmptyArray(clazz));
    }

    @Override
    public CardPin getPin(Object key, int scope) {
        return this.get(CardPin.class, key, scope);
    }

    @Override
    public CardPin getPinByID(long id, int scope) {
        return this.getByID(CardPin.class, id, scope);
    }

    @Override
    public CardPin getPinByName(String name, int scope) {
        return this.getByName(CardPin.class, name, scope);
    }

    @Override
    public Collection<CardPin> getPinCollection(int scope) {
        return this.getObjectCollection(CardPin.class, scope);
    }

    @Override
    public Collection<CardPin> getPinCollection(Filter<CardPin> filter, int scope) {
        return this.getObjectCollection(CardPin.class, filter, scope);
    }

    @Override
    public Map<Long, CardPin> getPinIDMap(int scope) {
        return this.getIDMap(CardPin.class, scope);
    }

    @Override
    public Set<Long> getPinIDSet(int scope) {
        return this.getIDSet(CardPin.class, scope);
    }

    @Override
    public long[] getPinIDs(int scope) {
        return this.getIDs(CardPin.class, scope);
    }

    @Override
    public Long[] getPinIDsLong(int scope) {
        return this.getIDsLong(CardPin.class, scope);
    }

    @Override
    public Map<String, CardPin> getPinNameMap(int scope) {
        return this.getNameMap(CardPin.class, scope);
    }

    @Override
    public Set<String> getPinNameSet(int scope) {
        return this.getNameSet(CardPin.class, scope);
    }

    @Override
    public String[] getPinNames(int scope) {
        return this.getNames(CardPin.class, scope);
    }

    @Override
    public CardPin[] getPins(int scope) {
        return this.getObjectCollection(CardPin.class, scope).toArray(new CardPin[0]);
    }

    @Override
    public CardPin[] getPins(Filter<CardPin> filter, int scope) {
        return (CardPin[])this.getObjects(CardPin.class, filter, scope);
    }

    @Override
    public void put(CardObject cardObject) {
        if (CardApplication.class.isInstance(cardObject)) {
            this.putApplication((CardApplication)cardObject);
        } else if (CardPin.class.isInstance(cardObject)) {
            this.putPin((CardPin)cardObject);
        } else if (CardFile.class.isInstance(cardObject)) {
            this.putFile((CardFile)cardObject);
        } else if (CardKey.class.isInstance(cardObject)) {
            this.putKey((CardKey)cardObject);
        }
    }

    @Override
    public void remove(CardObject cardObject, int scope) {
        this.remove(CardObject.class, cardObject, scope);
    }

    @Override
    public <T extends CardObject> void remove(Class<T> clazz, T cardObject, int scope) {
        this.removeByID(clazz, cardObject.getID(), scope);
    }

    @Override
    public void removeApplication(CardApplication application, int scope) {
        this.remove(CardApplication.class, application, scope);
    }

    @Override
    public void removeApplicationByID(long id, int scope) {
        this.removeByID(CardApplication.class, id, scope);
    }

    @Override
    public void removeApplicationByName(String name, int scope) {
        this.removeByName(CardApplication.class, name, scope);
    }

    @Override
    public void removeByID(long id, int scope) {
        this.removeByID(CardObject.class, id, scope);
    }

    @Override
    public <T extends CardObject> void removeByID(Class<T> clazz, long id, int scope) {
        if (super.isDisposed()) {
            return;
        }
        CardObject entry = this.getByID(id, scope);
        if (entry != null && clazz.isInstance(entry)) {
            if (entry.getParentApplicationID() == this.id) {
                this.getMapByClass(entry.getClass()).removeByID(id);
            } else {
                CardApplication parentApplication = entry.getParentApplication();
                if (parentApplication != null) {
                    parentApplication.remove(entry, 0);
                }
            }
        }
    }

    @Override
    public void removeByName(String name, int scope) {
        this.removeByName(CardObject.class, name, scope);
    }

    @Override
    public <T extends CardObject> void removeByName(Class<T> clazz, String name, int scope) {
        if (super.isDisposed()) {
            return;
        }
        CardObject entry = this.getByName(name, scope);
        if (entry != null && clazz.isInstance(entry)) {
            if (entry.getParentApplicationID() == this.id) {
                this.getMapByClass(entry.getClass()).removeByName(name);
            } else {
                CardApplication parentApplication = entry.getParentApplication();
                if (parentApplication != null) {
                    parentApplication.remove(entry, 0);
                }
            }
        }
    }

    @Override
    public void removeFile(CardFile file, int scope) {
        this.remove(CardFile.class, file, scope);
    }

    @Override
    public void removeFileByID(long id, int scope) {
        this.removeByID(CardFile.class, id, scope);
    }

    @Override
    public void removeFileByName(String name, int scope) {
        this.removeByName(CardFile.class, name, scope);
    }

    @Override
    public void removeKey(CardKey key, int scope) {
        this.remove(CardKey.class, key, scope);
    }

    @Override
    public void removeKeyByID(long id, int scope) {
        this.removeByID(CardKey.class, id, scope);
    }

    @Override
    public void removeKeyByName(String name, int scope) {
        this.removeByName(CardKey.class, name, scope);
    }

    @Override
    public void removePin(CardPin pin, int scope) {
        this.remove(CardPin.class, pin, scope);
    }

    @Override
    public void removePinByID(long id, int scope) {
        this.removeByID(CardPin.class, id, scope);
    }

    @Override
    public void removePinByName(String name, int scope) {
        this.removeByName(CardPin.class, name, scope);
    }

    private <T extends CardObject> String createCardObjectCollectionString(String collectionHeadline, Collection<T> collection, String indent) {
        StringBuffer resultString = new StringBuffer();
        if (collection.size() == 0) {
            return "";
        }
        resultString.append("\n" + indent + collectionHeadline + " (" + collection.size() + "):");
        for (CardObject element : collection) {
            if (CardApplication.class.isInstance(element)) {
                resultString.append("\n" + element.toString(indent + "--"));
                continue;
            }
            resultString.append("\n" + indent + "--type: " + element.getClass().getSimpleName() + " - name: " + element.getName() + " - id: " + element.getID() + " - parent application id: " + element.getParentApplicationID());
        }
        resultString.append("\n" + indent + "------");
        return resultString.toString();
    }

    @Override
    public String toString(String indent) {
        Collection<CardApplication> applicationCollection = this.getMapByClass(CardApplication.class).values();
        Collection<CardPin> pinCollection = this.getMapByClass(CardPin.class).values();
        Collection<CardFile> fileCollection = this.getMapByClass(CardFile.class).values();
        Collection<CardKey> keyCollection = this.getMapByClass(CardKey.class).values();
        String applicationString = this.createCardObjectCollectionString("Applications", applicationCollection, indent);
        String pinString = this.createCardObjectCollectionString("Pins", pinCollection, indent);
        String fileString = this.createCardObjectCollectionString("Files", fileCollection, indent);
        String keyString = this.createCardObjectCollectionString("Keys", keyCollection, indent);
        return applicationString + pinString + fileString + keyString;
    }

    private static long[] toPrimitiveLongArray(Long[] values) {
        long[] result = new long[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = values[i];
        }
        return result;
    }

    @Override
    public void put(Object object) {
        if (CardObject.class.isInstance(object)) {
            this.put((CardObject)object);
        }
    }

    @Override
    public void remove(Object object, int scope) {
        if (CardObject.class.isInstance(object)) {
            this.remove((CardObject)object, scope);
        } else if (Long.class.isInstance(object)) {
            this.removeByID((Long)object, scope);
        } else if (String.class.isInstance(object)) {
            this.removeByName((String)object, scope);
        }
    }

    @Override
    public void removeApplication(Object key, int scope) {
        if (Long.class.isInstance(key)) {
            this.removeApplicationByID((Long)key, scope);
        } else if (String.class.isInstance(key)) {
            this.removeApplicationByName((String)key, scope);
        }
    }

    @Override
    public void removePin(Object key, int scope) {
        if (Long.class.isInstance(key)) {
            this.removePinByID((Long)key, scope);
        } else if (String.class.isInstance(key)) {
            this.removePinByName((String)key, scope);
        }
    }

    @Override
    public void removeFile(Object key, int scope) {
        if (Long.class.isInstance(key)) {
            this.removeFileByID((Long)key, scope);
        } else if (String.class.isInstance(key)) {
            this.removeFileByName((String)key, scope);
        }
    }

    @Override
    public void removeKey(Object key, int scope) {
        if (Long.class.isInstance(key)) {
            this.removeKeyByID((Long)key, scope);
        } else if (String.class.isInstance(key)) {
            this.removeKeyByName((String)key, scope);
        }
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public void initID(long id) {
    }
}

