/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.OCFCertificateBag;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractCardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opencard.core.terminal.CardTerminalException;

public class CardKeyImpl
extends AbstractCardObject<FileEntry, DIDInfoType>
implements CardKey {
    private boolean signInitialized = false;
    private Boolean stapleSign = null;
    private Boolean multiSign = null;
    private Integer stapleSignCounter = null;
    private AlgorithmProvider<OCFPrivateKey> algorithmProvider;
    private List<CardPin> pinList = null;
    private List<CardFile> certificateChainFileList = null;
    private List<CardFile> attributeCertificateFileList = null;
    private List<CardPin> unmodifiablePinList = null;
    private List<CardFile> unmodifiableCertificateChainFileList = null;
    private List<CardFile> unmodifiableAttributeCertificateList = null;
    private OCFCertificateBag certificateBag = null;
    private OCFCertificateInfo info = null;
    private long[] idOfPins = null;
    private long[] idOfCertificateChainFiles = null;
    private long[] idOfAttributeCertificateFiles = null;
    private List<Long> idOfPinList = null;
    private List<Long> idOfCertificateChainFilesList = null;
    private List<Long> idOfAttributeCertificateFilesList = null;
    private KeyID keyID = null;
    private GovCS cs = null;

    @Override
    public String getRelatedProviderName() {
        return this.algorithmProvider.getRelatedProviderName();
    }

    @Override
    public List<Algorithm<OCFPrivateKey, ?>> getAlgorithms() {
        return this.algorithmProvider.getAlgorithms();
    }

    @Override
    public boolean isSignatureRelated() {
        return this.algorithmProvider.isSignatureRelated();
    }

    @Override
    public List<Algorithm<OCFPrivateKey, ?>> getAlgorithms(UsageRelated.Usage usage) throws IllegalArgumentException {
        return this.algorithmProvider.getAlgorithms(usage);
    }

    @Override
    public boolean isAuthenticationRelated() {
        return this.algorithmProvider.isAuthenticationRelated();
    }

    @Override
    public Algorithm<OCFPrivateKey, ?> getRecommendedAlgorithm(UsageRelated.Usage usage) throws IllegalArgumentException {
        Algorithm<OCFPrivateKey, ?> recommendedAlgorithm = this.algorithmProvider.getRecommendedAlgorithm(usage);
        if (usage == UsageRelated.Usage.SIGNATURE && recommendedAlgorithm == null) {
            try {
                recommendedAlgorithm = this.algorithmProvider.getRecommendedAlgorithm(UsageRelated.Usage.AUTHENTICATION);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return recommendedAlgorithm;
    }

    @Override
    public <S extends CardExecutionParameterSpec> Algorithm<OCFPrivateKey, S> getRecommendedAlgorithm(UsageRelated.Usage usage, Class<S> specClass) throws IllegalArgumentException {
        Algorithm<OCFPrivateKey, S> recommendedAlgorithm = this.algorithmProvider.getRecommendedAlgorithm(usage, specClass);
        if (usage == UsageRelated.Usage.SIGNATURE && recommendedAlgorithm == null) {
            try {
                recommendedAlgorithm = this.algorithmProvider.getRecommendedAlgorithm(UsageRelated.Usage.AUTHENTICATION, specClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return recommendedAlgorithm;
    }

    @Override
    public boolean isDecryptionRelated() {
        return this.algorithmProvider.isDecryptionRelated();
    }

    @Override
    public List<UsageRelated.Usage> getUsageList() {
        return this.algorithmProvider.getUsageList();
    }

    public CardKeyImpl(String name, long id, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, CardKey.CardKeyTypeEnum.UNKNOWN.getType(), innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardKeyImpl(Object lock, String name, long id, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(lock, name, id, CardKey.CardKeyTypeEnum.UNKNOWN.getType(), innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardKeyImpl(String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardKeyImpl(Object lock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry, null, -1L, -1L, null);
    }

    public CardKeyImpl(Object lock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry, OCFCertificateInfo info, long idOfCerFile, long idOfPin, KeyID keyID) {
        this(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry, info, new long[]{idOfCerFile}, new long[0], new long[]{idOfPin}, keyID);
    }

    public CardKeyImpl(Object lock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry, OCFCertificateInfo info, long[] idOfCertificateChainFiles, long[] idOfAttributeCertificateFiles, long[] idOfPins, KeyID keyID) {
        super(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
        this.idOfPins = idOfPins;
        this.idOfCertificateChainFiles = idOfCertificateChainFiles;
        this.idOfAttributeCertificateFiles = idOfAttributeCertificateFiles;
        this.idOfPinList = this.createUnmodiableIDList(this.idOfPins);
        this.idOfCertificateChainFilesList = this.createUnmodiableIDList(this.idOfCertificateChainFiles);
        this.idOfAttributeCertificateFilesList = this.createUnmodiableIDList(this.idOfAttributeCertificateFiles);
        this.keyID = keyID;
        this.info = info;
        this.cs = cs;
    }

    private List<Long> createUnmodiableIDList(long[] ids) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (int i = 0; ids != null && i < ids.length; ++i) {
            result.add(ids[i]);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public OCFCertificateInfo getInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFPrivateKey getKey() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return this.certificateBag.getPrivateKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CardPin> getPinList() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.pinList == null) {
                this.pinList = new ArrayList<CardPin>();
                this.unmodifiablePinList = Collections.unmodifiableList(this.pinList);
                for (int i = 0; this.idOfPins != null && i < this.idOfPins.length; ++i) {
                    CardPin pin = super.getCard().getPinByID(this.idOfPins[i], 1);
                    this.pinList.add(pin);
                }
            }
            return this.unmodifiablePinList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFCertificateBag getCertificateBag() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.info != null) {
                return this.info.getCertificateBag();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return false;
            }
            this.idOfPins = null;
            this.idOfCertificateChainFiles = null;
            this.idOfAttributeCertificateFiles = null;
            this.keyID = null;
            this.certificateBag = null;
            this.unmodifiablePinList = null;
            this.unmodifiableCertificateChainFileList = null;
            this.unmodifiableAttributeCertificateList = null;
            if (this.pinList != null) {
                this.pinList.clear();
            }
            this.pinList = null;
            if (this.certificateChainFileList != null) {
                this.certificateChainFileList.clear();
            }
            this.certificateChainFileList = null;
            if (this.attributeCertificateFileList != null) {
                this.attributeCertificateFileList.clear();
            }
            this.attributeCertificateFileList = null;
            return true;
        }
    }

    @Override
    public List<Long> getIDofPinList() {
        return this.idOfPinList;
    }

    @Override
    public List<Long> getIDofCertificateChainFileList() {
        return this.idOfCertificateChainFilesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyID getKeyID() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return this.keyID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CardFile> getAttributeCertificateList() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.attributeCertificateFileList == null) {
                this.attributeCertificateFileList = new ArrayList<CardFile>();
                this.unmodifiableAttributeCertificateList = Collections.unmodifiableList(this.attributeCertificateFileList);
                for (int i = 0; this.idOfAttributeCertificateFiles != null && i < this.idOfAttributeCertificateFiles.length; ++i) {
                    CardFile cerFile = super.getCard().getFileByID(this.idOfAttributeCertificateFiles[i], 1);
                    this.attributeCertificateFileList.add(cerFile);
                }
            }
            return this.unmodifiableAttributeCertificateList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CardFile> getCertificateChainList() {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.certificateChainFileList == null) {
                this.certificateChainFileList = new ArrayList<CardFile>();
                this.unmodifiableCertificateChainFileList = Collections.unmodifiableList(this.certificateChainFileList);
                for (int i = 0; this.idOfCertificateChainFiles != null && i < this.idOfCertificateChainFiles.length; ++i) {
                    CardFile cerFile = super.getCard().getFileByID(this.idOfCertificateChainFiles[i], 1);
                    this.certificateChainFileList.add(cerFile);
                }
            }
            return this.unmodifiableCertificateChainFileList;
        }
    }

    @Override
    public List<Long> getIDofAttributeCertificateFilesList() {
        return this.idOfAttributeCertificateFilesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GovCS.ResultObject authentify(byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, OperationCancelledException {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return this.cs.authentify(this.info, _hashValue, _pin, _hashAlgorithm, algorithmParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GovCS.ResultObject decrypt(byte[] _encryptedBytes, char[] _pin, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, OperationCancelledException {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return this.cs.decrypt(this.info, _encryptedBytes, _pin, algorithmParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GovCS.ResultObject signHash(byte[] _hashValue, char[] _pin, String _hashAlgorithm, AlgorithmParameters algorithmParameters) throws WrongPinException, RetryCounterExpiredException, NotYetInitializedException, ResponseCodeException, CardTerminalException, OperationCancelledException {
        CardKeyImpl cardKeyImpl = this;
        synchronized (cardKeyImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return this.cs.signHash(this.info, _hashValue, _pin, _hashAlgorithm, null);
        }
    }

    @Override
    public AlgorithmProvider<OCFPrivateKey> getAlgorithmProvider() {
        return this.algorithmProvider;
    }

    @Override
    public synchronized void setAlgorithmProvider(AlgorithmProvider<OCFPrivateKey> algorithmProvider) throws IllegalStateException, IllegalArgumentException {
        AssertUtil.notNull(algorithmProvider, "algorithm provider");
        if (this.algorithmProvider != null) {
            throw new IllegalStateException("algorithm provider already set");
        }
        this.algorithmProvider = algorithmProvider;
    }

    @Override
    public Algorithm<OCFPrivateKey, ?> getAlgorithm(UsageRelated.Usage usage, String algorithmName) throws IllegalArgumentException {
        return this.algorithmProvider.getAlgorithm(usage, algorithmName);
    }

    @Override
    public boolean isKeyAgreementRelated() {
        return this.algorithmProvider.isKeyAgreementRelated();
    }

    @Override
    public synchronized boolean isAlgorithmProviderSet() {
        return this.algorithmProvider != null;
    }

    @Override
    public boolean isMultiSign() {
        if (this.signInitialized && this.multiSign != null) {
            return this.multiSign;
        }
        return this.cs.isMultiSign();
    }

    @Override
    public boolean isStapleSign() {
        if (this.signInitialized && this.stapleSign != null) {
            return this.stapleSign;
        }
        return this.cs.isStapleSign();
    }

    @Override
    public Integer getStapleSignCounter() {
        if (this.signInitialized && this.stapleSignCounter != null) {
            return this.stapleSignCounter;
        }
        return this.cs.getStapleSignCounter();
    }

    @Override
    public synchronized void initSignAttributes(Boolean pStapleSign, Boolean pMultiSign, Integer pStapleSignCounter) throws IllegalStateException, IllegalArgumentException {
        if (this.signInitialized) {
            throw new IllegalStateException("CardKey's sign attributes already initialized");
        }
        this.multiSign = pMultiSign;
        this.stapleSign = pStapleSign;
        this.stapleSignCounter = pStapleSignCounter;
        this.signInitialized = true;
    }
}

