/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.gov2.jca_provider.OCFCertificateBag;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractCardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;

public class CardFileImpl
extends AbstractCardObject<FileEntry, DataSetInfoType>
implements CardFile {
    private OCFCertificateInfo info = null;
    private CardKey key = null;
    private long keyID = -1L;

    public CardFileImpl(String name, long id, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardFileImpl(Object lock, String name, long id, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(lock, name, id, CardFile.CardFileTypeEnum.TRANSPARENT.getType(), innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardFileImpl(String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardFileImpl(Object lock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry, -1L);
    }

    public CardFileImpl(Object lock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry, long keyID) {
        this(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry, keyID, null);
    }

    public CardFileImpl(Object lock, String name, long id, Type type, FileEntry innerObject, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry, long keyID, OCFCertificateInfo info) {
        super(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
        this.keyID = keyID;
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFCertificateInfo getInfo() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            CardKey key;
            if (super.isDisposed()) {
                return null;
            }
            if (this.info == null && (key = this.getKey()) != null) {
                this.info = key.getInfo();
            }
            return this.info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardKey getKey() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.key == null) {
                this.key = super.getCard().getKeyByID(this.keyID, 1);
            }
            return this.key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileReference getAbsolutePath() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            if (super.isDisposed()) {
                return null;
            }
            if (this.info != null) {
                return this.info.getFile();
            }
            return null;
        }
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public FileEntry getEntry() {
        return (FileEntry)super.getInnerObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            if (super.isDisposed()) {
                return false;
            }
            this.info = null;
            this.key = null;
            this.keyID = -1L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCertInfo() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            if (super.isDisposed()) {
                return false;
            }
            if (this.key == null) {
                this.getKey();
            }
            return this.key == null || this.key.getInfo() != this.info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyInfo() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            if (super.isDisposed()) {
                return false;
            }
            return !this.isCertInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFCertificateBag getCertificateBag() {
        CardFileImpl cardFileImpl = this;
        synchronized (cardFileImpl) {
            if (super.isDisposed()) {
                return null;
            }
            return this.getInfo().getCertificateBag();
        }
    }
}

