/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.impl;

import de.bos_bremen.common.Filter;
import de.bos_bremen.gov2.jca_provider.OCFCertificateBag;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.AbstractCardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardApplication;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObject;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardObjectManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardRegistry;
import de.bos_bremen.gov2.jca_provider.ocf.model.Type;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardFileImpl;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CardApplicationImpl
extends AbstractCardObject<FileEntry, CardApplicationType>
implements CardApplication {
    private CardObjectManager objectManager = null;
    private OCFCertificateInfo[] localInfos = null;
    private OCFCertificateInfo[] globalInfos = null;
    private final Object disposeManagerLock = new Object();
    private CardFile file = null;

    public CardApplicationImpl(String name, long id, FileEntry innerObject, CardObjectManager manager, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), innerObject, manager, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardApplicationImpl(Object lock, String name, long id, FileEntry innerObject, CardObjectManager manager, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(lock, name, id, CardApplication.CardApplicationTypeEnum.UNKNOWN.getType(), innerObject, manager, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardApplicationImpl(String name, long id, Type type, FileEntry innerObject, CardObjectManager manager, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        this(NO_LOCK, name, id, type, innerObject, manager, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
    }

    public CardApplicationImpl(Object lock, String name, long id, Type type, FileEntry innerObject, CardObjectManager manager, long cardID, long parentApplicationID, long terminalID, int slotID, GovCS cs, CardRegistry cardRegistry) {
        super(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
        this.file = new CardFileImpl(lock, name, id, type, innerObject, cardID, parentApplicationID, terminalID, slotID, cs, cardRegistry);
        manager.changeLock(NO_LOCK, this.disposeManagerLock);
        this.objectManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFCertificateInfo[] getAllCertificates() {
        CardApplicationImpl cardApplicationImpl = this;
        synchronized (cardApplicationImpl) {
            if (super.isDisposed()) {
                return new OCFCertificateInfo[0];
            }
            if (this.globalInfos == null) {
                this.globalInfos = this.getInfosInt(1);
            }
            return this.globalInfos;
        }
    }

    private OCFCertificateInfo[] getInfosInt(int scope) {
        Collection<CardKey> keys = this.getKeyCollection(scope);
        ArrayList<OCFCertificateInfo> collection = new ArrayList<OCFCertificateInfo>();
        for (CardKey tmp : keys) {
            collection.add(tmp.getInfo());
        }
        Collection<CardFile> files = this.getFileCollection(scope);
        for (CardFile tmp : files) {
            if (!tmp.isCertInfo() || tmp.getInfo() == null || collection.contains(tmp.getInfo())) continue;
            collection.add(tmp.getInfo());
        }
        return collection.toArray(new OCFCertificateInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFCertificateInfo[] getCertificates() {
        CardApplicationImpl cardApplicationImpl = this;
        synchronized (cardApplicationImpl) {
            if (super.isDisposed()) {
                return new OCFCertificateInfo[0];
            }
            if (this.localInfos == null) {
                this.localInfos = this.getInfosInt(0);
            }
            return this.localInfos;
        }
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        return super.toString(indent) + "\n" + indent + "Objects:" + this.objectManager.toString(indent + "--");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean disposeInt() {
        CardApplicationImpl cardApplicationImpl = this;
        synchronized (cardApplicationImpl) {
            if (super.isDisposed()) {
                return false;
            }
            this.localInfos = null;
            this.globalInfos = null;
            this.objectManager.dispose(this.disposeManagerLock);
            this.objectManager = null;
            return true;
        }
    }

    @Override
    public <T extends CardObject> T get(Class<T> clazz, Object key, int scope) {
        return this.objectManager.get(clazz, key, scope);
    }

    @Override
    public CardObject get(Object key, int scope) {
        return this.objectManager.get(key, scope);
    }

    @Override
    public CardApplication getApplication(Object key, int scope) {
        return this.objectManager.getApplication(key, scope);
    }

    @Override
    public CardApplication getApplicationByID(long id, int scope) {
        return this.objectManager.getApplicationByID(id, scope);
    }

    @Override
    public CardApplication getApplicationByName(String name, int scope) {
        return this.objectManager.getApplicationByName(name, scope);
    }

    @Override
    public Collection<CardApplication> getApplicationCollection(Filter<CardApplication> filter, int scope) {
        return this.objectManager.getApplicationCollection(filter, scope);
    }

    @Override
    public Collection<CardApplication> getApplicationCollection(int scope) {
        return this.objectManager.getApplicationCollection(scope);
    }

    @Override
    public Map<Long, CardApplication> getApplicationIDMap(int scope) {
        return this.objectManager.getApplicationIDMap(scope);
    }

    @Override
    public long[] getApplicationIDs(int scope) {
        return this.objectManager.getApplicationIDs(scope);
    }

    @Override
    public Set<Long> getApplicationIDSet(int scope) {
        return this.objectManager.getApplicationIDSet(scope);
    }

    @Override
    public Long[] getApplicationIDsLong(int scope) {
        return this.objectManager.getApplicationIDsLong(scope);
    }

    @Override
    public Map<String, CardApplication> getApplicationNameMap(int scope) {
        return this.objectManager.getApplicationNameMap(scope);
    }

    @Override
    public String[] getApplicationNames(int scope) {
        return this.objectManager.getApplicationNames(scope);
    }

    @Override
    public Set<String> getApplicationNameSet(int scope) {
        return this.objectManager.getApplicationNameSet(scope);
    }

    @Override
    public CardApplication[] getApplications(Filter<CardApplication> filter, int scope) {
        return this.objectManager.getApplications(filter, scope);
    }

    @Override
    public CardApplication[] getApplications(int scope) {
        return this.objectManager.getApplications(scope);
    }

    @Override
    public <T extends CardObject> T getByID(Class<T> clazz, long id, int scope) {
        return this.objectManager.getByID(clazz, id, scope);
    }

    @Override
    public CardObject getByID(long id, int scope) {
        return this.objectManager.getByID(id, scope);
    }

    @Override
    public <T extends CardObject> T getByName(Class<T> clazz, String name, int scope) {
        return this.objectManager.getByName(clazz, name, scope);
    }

    @Override
    public CardObject getByName(String name, int scope) {
        return this.objectManager.getByName(name, scope);
    }

    @Override
    public CardFile getFile(Object key, int scope) {
        return this.objectManager.getFile(key, scope);
    }

    @Override
    public CardFile getFileByID(long id, int scope) {
        return this.objectManager.getFileByID(id, scope);
    }

    @Override
    public CardFile getFileByName(String name, int scope) {
        return this.objectManager.getFileByName(name, scope);
    }

    @Override
    public Collection<CardFile> getFileCollection(Filter<CardFile> filter, int scope) {
        return this.objectManager.getFileCollection(filter, scope);
    }

    @Override
    public Collection<CardFile> getFileCollection(int scope) {
        return this.objectManager.getFileCollection(scope);
    }

    @Override
    public Map<Long, CardFile> getFileIDMap(int scope) {
        return this.objectManager.getFileIDMap(scope);
    }

    @Override
    public long[] getFileIDs(int scope) {
        return this.objectManager.getFileIDs(scope);
    }

    @Override
    public Set<Long> getFileIDSet(int scope) {
        return this.objectManager.getFileIDSet(scope);
    }

    @Override
    public Long[] getFileIDsLong(int scope) {
        return this.objectManager.getFileIDsLong(scope);
    }

    @Override
    public Map<String, CardFile> getFileNameMap(int scope) {
        return this.objectManager.getFileNameMap(scope);
    }

    @Override
    public String[] getFileNames(int scope) {
        return this.objectManager.getFileNames(scope);
    }

    @Override
    public Set<String> getFileNameSet(int scope) {
        return this.objectManager.getFileNameSet(scope);
    }

    @Override
    public CardFile[] getFiles(Filter<CardFile> filter, int scope) {
        return this.objectManager.getFiles(filter, scope);
    }

    @Override
    public CardFile[] getFiles(int scope) {
        return this.objectManager.getFiles(scope);
    }

    @Override
    public <T extends CardObject> Map<Long, T> getIDMap(Class<T> clazz, int scope) {
        return this.objectManager.getIDMap(clazz, scope);
    }

    @Override
    public Map<Long, CardObject> getIDMap(int scope) {
        return this.objectManager.getIDMap(scope);
    }

    @Override
    public <T extends CardObject> long[] getIDs(Class<T> clazz, int scope) {
        return this.objectManager.getIDs(clazz, scope);
    }

    @Override
    public long[] getIDs(int scope) {
        return this.objectManager.getIDs(scope);
    }

    @Override
    public <T extends CardObject> Set<Long> getIDSet(Class<T> clazz, int scope) {
        return this.objectManager.getIDSet(clazz, scope);
    }

    @Override
    public Set<Long> getIDSet(int scope) {
        return this.objectManager.getIDSet(scope);
    }

    @Override
    public <T extends CardObject> Long[] getIDsLong(Class<T> clazz, int scope) {
        return this.objectManager.getIDsLong(clazz, scope);
    }

    @Override
    public Long[] getIDsLong(int scope) {
        return this.objectManager.getIDsLong(scope);
    }

    @Override
    public CardKey getKey(Object key, int scope) {
        return this.objectManager.getKey(key, scope);
    }

    @Override
    public CardKey getKeyByID(long id, int scope) {
        return this.objectManager.getKeyByID(id, scope);
    }

    @Override
    public CardKey getKeyByName(String name, int scope) {
        return this.objectManager.getKeyByName(name, scope);
    }

    @Override
    public Collection<CardKey> getKeyCollection(Filter<CardKey> filter, int scope) {
        return this.objectManager.getKeyCollection(filter, scope);
    }

    @Override
    public Collection<CardKey> getKeyCollection(int scope) {
        return this.objectManager.getKeyCollection(scope);
    }

    @Override
    public Map<Long, CardKey> getKeyIDMap(int scope) {
        return this.objectManager.getKeyIDMap(scope);
    }

    @Override
    public long[] getKeyIDs(int scope) {
        return this.objectManager.getKeyIDs(scope);
    }

    @Override
    public Set<Long> getKeyIDSet(int scope) {
        return this.objectManager.getKeyIDSet(scope);
    }

    @Override
    public Long[] getKeyIDsLong(int scope) {
        return this.objectManager.getKeyIDsLong(scope);
    }

    @Override
    public Map<String, CardKey> getKeyNameMap(int scope) {
        return this.objectManager.getKeyNameMap(scope);
    }

    @Override
    public String[] getKeyNames(int scope) {
        return this.objectManager.getKeyNames(scope);
    }

    @Override
    public Set<String> getKeyNameSet(int scope) {
        return this.objectManager.getKeyNameSet(scope);
    }

    @Override
    public CardKey[] getKeys(Filter<CardKey> filter, int scope) {
        return this.objectManager.getKeys(filter, scope);
    }

    @Override
    public CardKey[] getKeys(int scope) {
        return this.objectManager.getKeys(scope);
    }

    @Override
    public <T extends CardObject> Map<String, T> getNameMap(Class<T> clazz, int scope) {
        return this.objectManager.getNameMap(clazz, scope);
    }

    @Override
    public Map<String, CardObject> getNameMap(int scope) {
        return this.objectManager.getNameMap(scope);
    }

    @Override
    public <T extends CardObject> String[] getNames(Class<T> clazz, int scope) {
        return this.objectManager.getNames(clazz, scope);
    }

    @Override
    public String[] getNames(int scope) {
        return this.objectManager.getNames(scope);
    }

    @Override
    public <T extends CardObject> Set<String> getNameSet(Class<T> clazz, int scope) {
        return this.objectManager.getNameSet(clazz, scope);
    }

    @Override
    public Set<String> getNameSet(int scope) {
        return this.objectManager.getNameSet(scope);
    }

    @Override
    public <T extends CardObject> Collection<T> getObjectCollection(Class<T> clazz, Filter<T> filter, int scope) {
        return this.objectManager.getObjectCollection(clazz, filter, scope);
    }

    @Override
    public <T extends CardObject> Collection<T> getObjectCollection(Class<T> clazz, int scope) {
        return this.objectManager.getObjectCollection(clazz, scope);
    }

    @Override
    public Collection<CardObject> getObjectCollection(Filter<CardObject> filter, int scope) {
        return this.objectManager.getObjectCollection(filter, scope);
    }

    @Override
    public Collection<CardObject> getObjectCollection(int scope) {
        return this.objectManager.getObjectCollection(scope);
    }

    @Override
    public <T extends CardObject> T[] getObjects(Class<T> clazz, Filter<T> filter, int scope) {
        return this.objectManager.getObjects(clazz, filter, scope);
    }

    @Override
    public <T extends CardObject> T[] getObjects(Class<T> clazz, int scope) {
        return this.objectManager.getObjects(clazz, scope);
    }

    @Override
    public CardObject[] getObjects(Filter<CardObject> filter, int scope) {
        return this.objectManager.getObjects(filter, scope);
    }

    @Override
    public CardObject[] getObjects(int scope) {
        return this.objectManager.getObjects(scope);
    }

    @Override
    public CardPin getPin(Object key, int scope) {
        return this.objectManager.getPin(key, scope);
    }

    @Override
    public CardPin getPinByID(long id, int scope) {
        return this.objectManager.getPinByID(id, scope);
    }

    @Override
    public CardPin getPinByName(String name, int scope) {
        return this.objectManager.getPinByName(name, scope);
    }

    @Override
    public Collection<CardPin> getPinCollection(Filter<CardPin> filter, int scope) {
        return this.objectManager.getPinCollection(filter, scope);
    }

    @Override
    public Collection<CardPin> getPinCollection(int scope) {
        return this.objectManager.getPinCollection(scope);
    }

    @Override
    public Map<Long, CardPin> getPinIDMap(int scope) {
        return this.objectManager.getPinIDMap(scope);
    }

    @Override
    public long[] getPinIDs(int scope) {
        return this.objectManager.getPinIDs(scope);
    }

    @Override
    public Set<Long> getPinIDSet(int scope) {
        return this.objectManager.getPinIDSet(scope);
    }

    @Override
    public Long[] getPinIDsLong(int scope) {
        return this.objectManager.getPinIDsLong(scope);
    }

    @Override
    public Map<String, CardPin> getPinNameMap(int scope) {
        return this.objectManager.getPinNameMap(scope);
    }

    @Override
    public String[] getPinNames(int scope) {
        return this.objectManager.getPinNames(scope);
    }

    @Override
    public Set<String> getPinNameSet(int scope) {
        return this.objectManager.getPinNameSet(scope);
    }

    @Override
    public CardPin[] getPins(Filter<CardPin> filter, int scope) {
        return this.objectManager.getPins(filter, scope);
    }

    @Override
    public CardPin[] getPins(int scope) {
        return this.objectManager.getPins(scope);
    }

    @Override
    public void put(CardObject cardObject) {
        this.objectManager.put(cardObject);
    }

    @Override
    public <T extends CardObject> void put(Class<T> clazz, T cardObject) {
        this.objectManager.put(clazz, cardObject);
    }

    @Override
    public void putApplication(CardApplication application) {
        this.objectManager.putApplication(application);
    }

    @Override
    public void putFile(CardFile file) {
        this.objectManager.putFile(file);
    }

    @Override
    public void putKey(CardKey key) {
        this.objectManager.putKey(key);
    }

    @Override
    public void putPin(CardPin pin) {
        this.objectManager.putPin(pin);
    }

    @Override
    public void remove(CardObject cardObject, int scope) {
        this.objectManager.remove(cardObject, scope);
    }

    @Override
    public <T extends CardObject> void remove(Class<T> clazz, T cardObject, int scope) {
        this.objectManager.remove(clazz, cardObject, scope);
    }

    @Override
    public void removeApplication(CardApplication application, int scope) {
        this.objectManager.removeApplication(application, scope);
    }

    @Override
    public void removeApplicationByID(long id, int scope) {
        this.objectManager.removeApplicationByID(id, scope);
    }

    @Override
    public void removeApplicationByName(String name, int scope) {
        this.objectManager.removeApplicationByName(name, scope);
    }

    @Override
    public <T extends CardObject> void removeByID(Class<T> clazz, long id, int scope) {
        this.objectManager.removeByID(clazz, id, scope);
    }

    @Override
    public void removeByID(long id, int scope) {
        this.objectManager.removeByID(id, scope);
    }

    @Override
    public <T extends CardObject> void removeByName(Class<T> clazz, String name, int scope) {
        this.objectManager.removeByName(clazz, name, scope);
    }

    @Override
    public void removeByName(String name, int scope) {
        this.objectManager.removeByName(name, scope);
    }

    @Override
    public void removeFile(CardFile file, int scope) {
        this.objectManager.removeFile(file, scope);
    }

    @Override
    public void removeFileByID(long id, int scope) {
        this.objectManager.removeFileByID(id, scope);
    }

    @Override
    public void removeFileByName(String name, int scope) {
        this.objectManager.removeFileByName(name, scope);
    }

    @Override
    public void removeKey(CardKey key, int scope) {
        this.objectManager.removeKey(key, scope);
    }

    @Override
    public void removeKeyByID(long id, int scope) {
        this.objectManager.removeKeyByID(id, scope);
    }

    @Override
    public void removeKeyByName(String name, int scope) {
        this.objectManager.removeKeyByName(name, scope);
    }

    @Override
    public void removePin(CardPin pin, int scope) {
        this.objectManager.removePin(pin, scope);
    }

    @Override
    public void removePinByID(long id, int scope) {
        this.objectManager.removePinByID(id, scope);
    }

    @Override
    public void removePinByName(String name, int scope) {
        this.objectManager.removePinByName(name, scope);
    }

    @Override
    public void put(Object object) {
        this.objectManager.put(object);
    }

    @Override
    public void remove(Object object, int scope) {
        this.objectManager.remove(object, scope);
    }

    @Override
    public boolean isRootApplication() {
        return super.getParentApplicationID() == super.getID();
    }

    @Override
    public void removeApplication(Object key, int scope) {
        this.objectManager.removeApplication(key, scope);
    }

    @Override
    public void removeFile(Object key, int scope) {
        this.objectManager.removeFile(key, scope);
    }

    @Override
    public void removeKey(Object key, int scope) {
        this.objectManager.removeKey(key, scope);
    }

    @Override
    public void removePin(Object key, int scope) {
        this.objectManager.removePin(key, scope);
    }

    @Override
    public List<String> getKeyNameList() {
        OCFCertificateInfo[] infos = this.getCertificates();
        ArrayList<String> result = new ArrayList<String>();
        OCFCertificateBag bag = null;
        for (int i = 0; i < infos.length; ++i) {
            bag = infos[i].getCertificateBag();
            if (bag == null || !bag.isKeyEntry()) continue;
            result.add(bag.getAlias());
        }
        return result;
    }

    @Override
    public FileEntry getFileEntry() {
        return (FileEntry)super.getInnerObject();
    }
}

