/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl;

import de.bos_bremen.basecard.common.dialog.BDialogMode;
import de.bos_bremen.basecard.common.pin.PinModifyParameters;
import de.bos_bremen.basecard.common.pin.PinVerifyParameters;
import de.bos_bremen.basecard.common.pin.coding.PinEncoder;
import de.bos_bremen.basecard.terminal.pcsc.Pcsc20Features;
import de.bos_bremen.basecard.terminal.pcsc.TLVProperty;
import de.bos_bremen.basecard.terminal.pcsc.handler.Pcsc20PinStructureHandler;
import de.bos_bremen.basecard.terminal.pcsc.handler.impl.Pcsc20PinStructureHandlerFactory;
import de.bos_bremen.basecard.terminal.pcsc.handler.structures.AbstractPinStructure;
import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.CharUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.system.LanguageEnum;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVConfiguration;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialogProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.PinInformationProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.TerminalOperationHandler;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.DisplayStatus;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.IFDCapabilities;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.IFDStatus;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.IFDTerminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.InputUnit;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.KeyPadStatus;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.ModifyVerificationDataParameter;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.PasswordAttributes;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.PinInput;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.SlotStatus;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.VerifyUserParameter;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.AbstractIFDTerminal;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.DisplayCapabilityImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.DisplayStatusImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.IFDCapabilitiesImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.IFDStatusImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.KeyPadCapabilityImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.KeyPadStatusImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.SlotCapabilityImpl;
import de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd.impl.SlotStatusImpl;
import de.bos_bremen.java.pcsc.Protocol;
import de.bos_bremen.jni.pcsc.PCSCReaderState;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class PcscIFDTerminalImpl
extends AbstractIFDTerminal<PCSCCardTerminal>
implements IFDTerminal {
    public static final String EMPTY_STRING = "";
    public static final String OS_NAME_LINUX = "linux";
    public static final String SYSTEM_PROPERTY_KEY_OS_NAME = "os.name";

    PcscIFDTerminalImpl(PCSCCardTerminal cardTerminal) {
        super(cardTerminal);
    }

    @Override
    public IFDCapabilities getCapabilities(long contextHandle, String ifdName) throws Exception {
        Pcsc20Features features = ((PCSCCardTerminal)this.terminal).getPcsc20Features();
        byte[] tlvProperties = null;
        Map<TLVProperty, ASN1> tlvPropertyMap = null;
        byte[] keypadProperties = null;
        byte[] displayProperties = null;
        if (features.isFeatureSupported(18)) {
            tlvProperties = ((PCSCCardTerminal)this.terminal).sendTerminalCommand(features.getGetTLVProperties().valueAsNumber(), new byte[0]);
            tlvPropertyMap = TLVProperty.parse(tlvProperties);
        }
        if (features.isFeatureSupported(10)) {
            keypadProperties = ((PCSCCardTerminal)this.terminal).sendTerminalCommand(features.getIfdDisplayProperties().valueAsNumber(), new byte[0]);
        }
        if (features.isFeatureSupported(17)) {
            displayProperties = ((PCSCCardTerminal)this.terminal).sendTerminalCommand(features.getIFDPINProperties().valueAsNumber(), new byte[0]);
        }
        List slotCapabilitiesList = null;
        List displayCapabilitiesList = null;
        List keypadCapabilitiesList = null;
        List<?> bioSensorCapabilityList = null;
        List<String> protocolList = Arrays.asList("0", "1");
        SlotCapabilityImpl slotCapability = new SlotCapabilityImpl(0, protocolList);
        slotCapabilitiesList.add(slotCapability);
        if (!ArrayUtil.isNullOrEmpty(displayProperties) || !CollectionUtil.isNullOrEmpty(tlvPropertyMap) && tlvPropertyMap.containsKey(TLVProperty.DISPLAY_LAYOUT)) {
            int lines = -1;
            int columns = -1;
            if (!ArrayUtil.isNullOrEmpty(displayProperties)) {
                byte[][] splittedDisplaysProperties = ByteUtil.split(displayProperties, 2);
                columns = !ArrayUtil.isNullOrEmpty((Object[])splittedDisplaysProperties) && splittedDisplaysProperties.length >= 1 && !ArrayUtil.isNullOrEmpty(splittedDisplaysProperties[0]) ? new BigInteger(splittedDisplaysProperties[0]).intValue() : 16;
                lines = !ArrayUtil.isNullOrEmpty((Object[])splittedDisplaysProperties) && splittedDisplaysProperties.length >= 2 && !ArrayUtil.isNullOrEmpty(splittedDisplaysProperties[1]) ? new BigInteger(splittedDisplaysProperties[1]).intValue() : 1;
            } else {
                ASN1 maxCharLine = tlvPropertyMap.get(TLVProperty.DISPLAY_MAX_CHARACTERS_PER_LINE);
                columns = maxCharLine != null ? new BigInteger(maxCharLine.getValue()).intValue() : 16;
                ASN1 maxLines = tlvPropertyMap.get(TLVProperty.DISPLAY_MAX_LINES);
                lines = maxLines != null ? new BigInteger(maxLines.getValue()).intValue() : 1;
            }
            DisplayCapabilityImpl displayCapability = new DisplayCapabilityImpl(0, lines, columns);
            displayCapabilitiesList.add(displayCapability);
        }
        if (!ArrayUtil.isNullOrEmpty(keypadProperties) || !CollectionUtil.isNullOrEmpty(tlvPropertyMap) && (tlvPropertyMap.containsKey(TLVProperty.PINPAD_MAX_PIN_SIZE) || tlvPropertyMap.containsKey(TLVProperty.PINPAD_MAX_PIN_SIZE))) {
            KeyPadCapabilityImpl keypadCapability = new KeyPadCapabilityImpl(0, 16);
            keypadCapabilitiesList.add(keypadCapability);
        } else if (features.isFeatureSupported(6) || features.isFeatureSupported(1)) {
            KeyPadCapabilityImpl keypadCapability = new KeyPadCapabilityImpl(0, 16);
            keypadCapabilitiesList.add(keypadCapability);
        }
        IFDCapabilitiesImpl result = new IFDCapabilitiesImpl(null);
        result.setSlotCapabilityList(slotCapabilitiesList);
        if (!CollectionUtil.isEmpty(displayCapabilitiesList)) {
            result.setDisplayCapabilityList(displayCapabilitiesList);
        }
        if (!CollectionUtil.isEmpty(keypadCapabilitiesList)) {
            result.setKeyPadCapabilityList(keypadCapabilitiesList);
        }
        if (!CollectionUtil.isEmpty(bioSensorCapabilityList)) {
            result.setBioSensorCapabilityList(bioSensorCapabilityList);
        }
        result.setOpticalSignalUnitAvailable(false);
        result.setAcousticalSignalUnitAvailable(false);
        return result;
    }

    @Override
    public List<IFDStatus> getStatus(long contextHandle) throws Exception {
        PCSCReaderState readerState = ((PCSCCardTerminal)this.terminal).getStatus(contextHandle, 0);
        boolean connected = ((PCSCCardTerminal)this.terminal).isConnected();
        IFDStatusImpl result = new IFDStatusImpl(readerState.getName());
        result.setConnected(connected);
        ArrayList<SlotStatus> slotStatusList = new ArrayList<SlotStatus>();
        SlotStatusImpl slotStatusImpl = new SlotStatusImpl(0, (readerState.getEventState() & 0x20) != 0, readerState.getATR());
        slotStatusList.add(slotStatusImpl);
        result.setSlotStatusList(slotStatusList);
        Pcsc20Features features = ((PCSCCardTerminal)this.terminal).getPcsc20Features();
        if (features.isFeatureSupported(6) || features.isFeatureSupported(1)) {
            if (features.isFeatureSupported(17)) {
                ArrayList<DisplayStatus> displayStatusList = new ArrayList<DisplayStatus>();
                DisplayStatusImpl displayStatusImpl = new DisplayStatusImpl(0, true);
                displayStatusList.add(displayStatusImpl);
                result.setDisplayStatusList(displayStatusList);
            }
            ArrayList<KeyPadStatus> keyPadStatusList = new ArrayList<KeyPadStatus>();
            KeyPadStatusImpl keyPadStatusImpl = new KeyPadStatusImpl(0, true);
            keyPadStatusList.add(keyPadStatusImpl);
            result.setKeyPadStatusList(keyPadStatusList);
        }
        return Arrays.asList(result);
    }

    @Override
    public long establishContext() throws Exception {
        return ((PCSCCardTerminal)this.terminal).establishContext();
    }

    @Override
    public void releaseContext(long contextHandle) throws Exception {
        ((PCSCCardTerminal)this.terminal).releaseContext(contextHandle);
    }

    @Override
    public long connect(long contextHandle, int slotID, boolean exclusive) throws Exception {
        return ((PCSCCardTerminal)this.terminal).connect(contextHandle, slotID, exclusive, null);
    }

    @Override
    public long connect(long contextHandle, int slotID, boolean exclusive, Protocol protocol) throws Exception {
        return ((PCSCCardTerminal)this.terminal).connect(contextHandle, slotID, exclusive, protocol);
    }

    @Override
    public void disconnect(long slotHandle, int disposition) throws Exception {
        ((PCSCCardTerminal)this.terminal).disconnect(slotHandle, disposition);
    }

    @Override
    public boolean beginTransaction(long slotHandle, long timeout) throws Exception {
        return ((PCSCCardTerminal)this.terminal).beginTransaction(slotHandle, timeout);
    }

    @Override
    public void endTransaction(long slotHandle) throws Exception {
        ((PCSCCardTerminal)this.terminal).endTransaction(slotHandle);
    }

    @Override
    public byte[] transmit(long slotHandle, byte[] cmd) throws Exception {
        ResponseAPDU response = ((PCSCCardTerminal)this.terminal).transmit(slotHandle, 0, new CommandAPDU(cmd), -1);
        return response.getBytes();
    }

    @Override
    public byte[] controlIFD(long contextHandle, byte[] cmd) throws Exception {
        return ((PCSCCardTerminal)this.terminal).sendTerminalCommand(cmd);
    }

    @Override
    public void output(long contextHandle, long timeout, int displayIndex, String message, boolean acousticalSignal, boolean opticalSignal) throws Exception {
        throw new UnsupportedOperationException("for any card reader the may be a service, but all these services for any reader must be known and supported, nothing can be done in one life or at least with very much invest of time");
    }

    private boolean usesCCID(String terminalName) {
        boolean usesCCID = System.getProperty(SYSTEM_PROPERTY_KEY_OS_NAME, EMPTY_STRING).toLowerCase().contains(OS_NAME_LINUX) && terminalName.startsWith("*");
        return usesCCID;
    }

    private PinInformationProvider createPinInformationProvider(InputUnit inputUnit, final char[] oldReferenceData, final int retryCounter) {
        boolean initialized = true;
        int tmpMaxPinLength = 0;
        int tmpMinPinLength = 0;
        int tmpPasswordBlockLength = 0;
        byte tmpPasswordBlockFiller = 0;
        PinEncoder tmpEncoder = null;
        try {
            AssertUtil.notNull(inputUnit, "input unit");
            if (!PinInput.class.isInstance(inputUnit)) {
                throw new IllegalArgumentException("not supported type of input unit type: " + inputUnit + ", only PinInput supported");
            }
            PinInput tmpPinInput = (PinInput)inputUnit;
            PasswordAttributes tmpPasswordAttributes = tmpPinInput.getPasswordAttributes();
            AssertUtil.notNull(tmpPasswordAttributes, "pin attributes flags");
            tmpMaxPinLength = tmpPasswordAttributes.getMaxLength();
            tmpMinPinLength = tmpPasswordAttributes.getMinLength();
            tmpPasswordBlockLength = tmpPasswordAttributes.getStoredLength();
            tmpPasswordBlockFiller = (byte)tmpPasswordAttributes.getPadChar().charValue();
            tmpEncoder = (PinEncoder)IFD_ENCODING_MAPPING.get(tmpPasswordAttributes.getPwdType());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("parameters not usable");
        }
        final int maxPINLength = tmpMaxPinLength;
        final int minPINLength = tmpMinPinLength;
        final int passwordBlockLength = tmpPasswordBlockLength;
        final byte passwordBlockFiller = tmpPasswordBlockFiller;
        final PinEncoder encoder = tmpEncoder;
        return new PinInformationProvider(){

            @Override
            public int getMaxPINLength(OCFCertificateInfo _info) {
                return maxPINLength;
            }

            @Override
            public int getMinPINLength(OCFCertificateInfo _info) {
                return minPINLength;
            }

            @Override
            public PinEncoder getPinEncoder(OCFCertificateInfo _info) {
                return encoder;
            }

            @Override
            public byte getPasswordBlockFiller(OCFCertificateInfo _info) {
                return passwordBlockFiller;
            }

            @Override
            public int getPasswordBlockLength(OCFCertificateInfo _info) {
                return passwordBlockLength;
            }

            @Override
            public boolean isCyberJack() {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] padPin(OCFCertificateInfo _info, char[] _pin) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte getPinID(OCFCertificateInfo _info) {
                throw new UnsupportedOperationException();
            }

            @Override
            public char[] getInitPin(OCFCertificateInfo _info) {
                return oldReferenceData;
            }

            @Override
            public int getRetryCount(OCFCertificateInfo _info) {
                return retryCounter;
            }

            @Override
            public boolean isInitialized(OCFCertificateInfo _info) {
                return true;
            }

            @Override
            public boolean usesNullPin(OCFCertificateInfo _info) {
                return false;
            }

            @Override
            public Integer getMaxPINLengthInit(OCFCertificateInfo _info) {
                return null;
            }

            @Override
            public Integer getMinPINLengthInit(OCFCertificateInfo _info) {
                return null;
            }
        };
    }

    @Override
    public byte[] verifyUser(VerifyUserParameter parameter) throws Exception {
        int maxL;
        byte[] template = null;
        try {
            template = parameter.getTemplate();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("template expected as byte-array");
        }
        AssertUtil.notNullOrEmpty(template, "template");
        int timeout1 = 30;
        try {
            timeout1 = parameter.getTimeoutUntilFirstKey() != null ? parameter.getTimeoutUntilFirstKey() : 30;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("timeout1 expected as integer");
        }
        int timeout2 = 5;
        try {
            timeout2 = parameter.getTimeoutAfterFirstKey() != null ? parameter.getTimeoutAfterFirstKey() : 5;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("timeout2 expected as integer");
        }
        PinInformationProvider pip = this.createPinInformationProvider(parameter.getInputUnit(), null, -1);
        String terminalName = ((PCSCCardTerminal)this.terminal).getName();
        boolean usesCCID = this.usesCCID(terminalName);
        Pcsc20PinStructureHandler handler = Pcsc20PinStructureHandlerFactory.getHandler(terminalName.toLowerCase());
        PinEncoder encoder = pip.getPinEncoder(null);
        int n = maxL = pip.getMaxPINLength(null) == 0 ? 12 : pip.getMaxPINLength(null);
        if (PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK == encoder) {
            maxL = 12;
        }
        PinVerifyParameters pvp = new PinVerifyParameters(template, encoder, (Integer)pip.getPasswordBlockLength(null), (Byte)pip.getPasswordBlockFiller(null), encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK, Math.max(pip.getMinPINLength(null), 4), maxL, timeout1, timeout2, LanguageEnum.GERMAN, usesCCID);
        AbstractPinStructure pvs = handler.buildPinOperationStructure(pvp);
        GovCHVDialog chvDialog = GovCHVDialogProvider.getInstance().getDialogClass().newInstance();
        OCFCertificateInfo info = new OCFCertificateInfo();
        info.setUsages(new boolean[]{true, true, false, true, false, false, false, false});
        GovCHVConfiguration configuration = new GovCHVConfiguration(-1, BDialogMode.CARD_VERIFY, pip.getMinPINLength(null), pip.getMaxPINLength(null), info, terminalName, null, null, null, null);
        chvDialog.setConfiguration(configuration);
        CommandAPDU cmd = new CommandAPDU(pvs.getEncoded());
        ResponseAPDU response = TerminalOperationHandler.Util.sendTerminalCMD(this.terminal, cmd, chvDialog, true, pip, ((PCSCCardTerminal)this.terminal).getPcsc20Features());
        if (response == null) {
            throw new CardTerminalException("no response received");
        }
        return response.getBytes();
    }

    @Override
    public byte[] modificationVerificationData(ModifyVerificationDataParameter parameter) throws Exception {
        int maxL;
        byte[] template = null;
        try {
            template = parameter.getTemplate();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("template expected as byte-array");
        }
        AssertUtil.notNullOrEmpty(template, "template");
        int timeout1 = 30;
        try {
            timeout1 = parameter.getTimeoutUntilFirstKey() != null ? parameter.getTimeoutUntilFirstKey() : 30;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("timeout1 expected as integer");
        }
        int timeout2 = 5;
        try {
            timeout2 = parameter.getTimeoutAfterFirstKey() != null ? parameter.getTimeoutAfterFirstKey() : 5;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("timeout2 expected as integer");
        }
        PinInformationProvider pip = this.createPinInformationProvider(parameter.getInputUnit(), parameter.getOldReferenceData() != null ? CharUtil.convert(parameter.getOldReferenceData()) : null, -1);
        String terminalName = ((PCSCCardTerminal)this.terminal).getName();
        boolean usesCCID = this.usesCCID(terminalName);
        Pcsc20PinStructureHandler handler = Pcsc20PinStructureHandlerFactory.getHandler(terminalName.toLowerCase());
        PinEncoder encoder = pip.getPinEncoder(null);
        int n = maxL = pip.getMaxPINLength(null) == 0 ? 12 : pip.getMaxPINLength(null);
        if (PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK == encoder) {
            maxL = 12;
        }
        PinModifyParameters pmp = new PinModifyParameters(template, encoder, (Integer)pip.getPasswordBlockLength(null), (Byte)pip.getPasswordBlockFiller(null), encoder == PinEncoder.ENCODER_FORMAT_1_PIN_BLOCK || encoder == PinEncoder.ENCODER_FORMAT_2_PIN_BLOCK, Math.max(pip.getMinPINLength(null), 4), maxL, timeout1, timeout2, LanguageEnum.GERMAN, usesCCID, null);
        AbstractPinStructure pms = handler.buildPinOperationStructure(pmp);
        GovCHVDialog chvDialog = GovCHVDialogProvider.getInstance().getDialogClass().newInstance();
        OCFCertificateInfo info = new OCFCertificateInfo();
        info.setUsages(new boolean[]{true, true, false, true, false, false, false, false});
        GovCHVConfiguration configuration = new GovCHVConfiguration(-1, BDialogMode.CARD_CHANGE, pip.getMinPINLength(null), pip.getMaxPINLength(null), info, terminalName, null, null, null, null);
        chvDialog.setConfiguration(configuration);
        CommandAPDU cmd = new CommandAPDU(pms.getEncoded());
        ResponseAPDU response = TerminalOperationHandler.Util.sendTerminalCMD(this.terminal, cmd, chvDialog, false, pip, ((PCSCCardTerminal)this.terminal).getPcsc20Features());
        if (response == null) {
            throw new CardTerminalException("no response received");
        }
        return response.getBytes();
    }

    @Override
    public void waitFor() throws Exception {
    }

    @Override
    public void cancel() throws Exception {
    }
}

