/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.model.ecard.isoifd;

import de.bos_bremen.common.asn1.cvc.BitIdentifier;
import de.bos_bremen.common.asn1.cvc.BitIdentifierImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public interface PasswordAttributes {
    public byte[] getPwdFlags();

    public void setPwdFlags(byte[] var1);

    public String getPwdType();

    public void setPwdType(String var1);

    public int getMinLength();

    public void setMinLength(int var1);

    public int getStoredLength();

    public void setStoredLength(int var1);

    public Integer getMaxLength();

    public void setMaxLength(Integer var1);

    public Character getPadChar();

    public void setPadChar(Character var1);

    public Date getLastPasswordChange();

    public void setLastPasswordChange(Date var1);

    public static interface PwdFlagConstants {
        public static final BitIdentifier CASE_SENSISITIVE = new BitIdentifierImpl("case-sensitive", 0, 0);
        public static final BitIdentifier LOCAL = new BitIdentifierImpl("local", 0, CASE_SENSISITIVE.getBitIndex() + 1);
        public static final BitIdentifier CHANGE_DISABLED = new BitIdentifierImpl("change-disabled", 0, LOCAL.getBitIndex() + 1);
        public static final BitIdentifier UNBLOCK_DISABLED = new BitIdentifierImpl("unblock-disabled", 0, CHANGE_DISABLED.getBitIndex() + 1);
        public static final BitIdentifier INITIALIZED = new BitIdentifierImpl("initialized", 0, UNBLOCK_DISABLED.getBitIndex() + 1);
        public static final BitIdentifier NEEDS_PADDING = new BitIdentifierImpl("needs-padding", 0, INITIALIZED.getBitIndex() + 1);
        public static final BitIdentifier UNBLOCKING_PASSWORD = new BitIdentifierImpl("unblockingPassword", 0, NEEDS_PADDING.getBitIndex() + 1);
        public static final BitIdentifier SO_PASSWORD = new BitIdentifierImpl("soPassword", 0, UNBLOCKING_PASSWORD.getBitIndex() + 1);
        public static final BitIdentifier DISABLE_ALLOWED = new BitIdentifierImpl("disable-allowed", 1, SO_PASSWORD.getBitIndex() + 1);
        public static final BitIdentifier INTEGRITY_PROTECTED = new BitIdentifierImpl("integrity-protected", 1, DISABLE_ALLOWED.getBitIndex() + 1);
        public static final BitIdentifier CONFIDENTIALITY_PROTECTED = new BitIdentifierImpl("confidentiality-protected", 1, INTEGRITY_PROTECTED.getBitIndex() + 1);
        public static final BitIdentifier EXCHANGE_REF_DATA = new BitIdentifierImpl("exchangeRefData", 1, CONFIDENTIALITY_PROTECTED.getBitIndex() + 1);
        public static final BitIdentifier RESET_RETRY_COUNTER_1 = new BitIdentifierImpl("resetRetryCounter1", 1, EXCHANGE_REF_DATA.getBitIndex() + 1);
        public static final BitIdentifier RESET_RETRY_COUNTER_2 = new BitIdentifierImpl("resetRetryCounter2", 1, RESET_RETRY_COUNTER_1.getBitIndex() + 1);
        public static final List<BitIdentifier> LIST_PWD_FLAGS = Collections.unmodifiableList(Arrays.asList(CASE_SENSISITIVE, LOCAL, CHANGE_DISABLED, UNBLOCK_DISABLED, INITIALIZED, NEEDS_PADDING, UNBLOCKING_PASSWORD, SO_PASSWORD, DISABLE_ALLOWED, INTEGRITY_PROTECTED, CONFIDENTIALITY_PROTECTED, EXCHANGE_REF_DATA, RESET_RETRY_COUNTER_1, RESET_RETRY_COUNTER_2));
    }
}

